/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.farm.plugin;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.management.remote.JMXConnector;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import org.apache.geronimo.farm.config.BasicExtendedJMXConnectorInfo;
import org.apache.geronimo.farm.config.ExtendedJMXConnectorInfo;
import org.apache.geronimo.farm.config.NodeInfo;
import org.apache.geronimo.farm.plugin.JpaClusterInfo;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelRegistry;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.system.plugin.PluginInstaller;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;

@Entity(name="node")
@NamedQuery(name="nodeByName", query="SELECT a FROM node a WHERE a.name = :name")
public class JpaNodeInfo
implements NodeInfo,
PersistenceCapable {
    @Id
    private String name;
    private String userName;
    private String password;
    private String protocol;
    private String host;
    private int port = -1;
    private String urlPath;
    private boolean local;
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST})
    @JoinColumn(name="cluster", referencedColumnName="name")
    private JpaClusterInfo cluster;
    @Transient
    private Kernel kernel;
    @Transient
    private PluginInstaller pluginInstaller;
    @Transient
    private JMXConnector jmxConnector;
    @Transient
    private ConfigurationManager configurationManager;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$geronimo$farm$plugin$JpaClusterInfo;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo;
    private transient Object pcDetachedState;

    public JpaNodeInfo() {
    }

    public JpaNodeInfo(NodeInfo nodeInfo) {
        this.name = nodeInfo.getName();
        ExtendedJMXConnectorInfo connectorInfo = nodeInfo.getConnectorInfo();
        this.userName = connectorInfo.getUsername();
        this.password = connectorInfo.getPassword();
        this.protocol = connectorInfo.getProtocol();
        this.host = connectorInfo.getHost();
        this.port = connectorInfo.getPort();
        this.urlPath = connectorInfo.getUrlPath();
        this.local = connectorInfo.isLocal();
    }

    public JpaClusterInfo getCluster() {
        return JpaNodeInfo.pcGetcluster(this);
    }

    public void setCluster(JpaClusterInfo cluster) {
        JpaNodeInfo.pcSetcluster(this, cluster);
    }

    public String getName() {
        return JpaNodeInfo.pcGetname(this);
    }

    public void setName(String name) {
        JpaNodeInfo.pcSetname(this, name);
    }

    public ExtendedJMXConnectorInfo getConnectorInfo() {
        return new BasicExtendedJMXConnectorInfo(JpaNodeInfo.pcGetuserName(this), JpaNodeInfo.pcGetpassword(this), JpaNodeInfo.pcGetprotocol(this), JpaNodeInfo.pcGethost(this), JpaNodeInfo.pcGetport(this), JpaNodeInfo.pcGeturlPath(this), JpaNodeInfo.pcGetlocal(this));
    }

    public void setConnectorInfo(String userName, String password, String protocol, String host, int port, String urlPath, boolean local) {
        JpaNodeInfo.pcSetuserName(this, userName);
        JpaNodeInfo.pcSetpassword(this, password);
        JpaNodeInfo.pcSetprotocol(this, protocol);
        JpaNodeInfo.pcSethost(this, host);
        JpaNodeInfo.pcSetport(this, port);
        JpaNodeInfo.pcSeturlPath(this, urlPath);
        JpaNodeInfo.pcSetlocal(this, local);
    }

    public Kernel newKernel() throws IOException {
        if (this.kernel == null) {
            if (JpaNodeInfo.pcGetlocal(this)) {
                this.kernel = KernelRegistry.getSingleKernel();
            } else {
                ExtendedJMXConnectorInfo connectorInfo = this.getConnectorInfo();
                this.jmxConnector = connectorInfo.connect();
                return connectorInfo.newKernel(this.jmxConnector);
            }
        }
        return this.kernel;
    }

    public synchronized PluginInstaller getPluginInstaller() throws IOException {
        if (this.pluginInstaller != null) {
            return this.pluginInstaller;
        }
        Kernel kernel = this.newKernel();
        Set set = kernel.listGBeans(new AbstractNameQuery(PluginInstaller.class.getName()));
        Iterator i$ = set.iterator();
        if (i$.hasNext()) {
            AbstractName name = (AbstractName)i$.next();
            this.pluginInstaller = (PluginInstaller)kernel.getProxyManager().createProxy(name, PluginInstaller.class);
            return this.pluginInstaller;
        }
        throw new IllegalStateException("No plugin installer found");
    }

    public synchronized ConfigurationManager getConfigurationManager() throws IOException {
        if (this.configurationManager != null) {
            return this.configurationManager;
        }
        Kernel kernel = this.newKernel();
        Set set = kernel.listGBeans(new AbstractNameQuery(ConfigurationManager.class.getName()));
        Iterator i$ = set.iterator();
        if (i$.hasNext()) {
            AbstractName name = (AbstractName)i$.next();
            this.configurationManager = (ConfigurationManager)kernel.getProxyManager().createProxy(name, ConfigurationManager.class);
            return this.configurationManager;
        }
        throw new IllegalStateException("No plugin installer found");
    }

    public synchronized void disconnect() throws IOException {
        if (this.kernel != null) {
            if (this.pluginInstaller != null) {
                this.kernel.getProxyManager().destroyProxy((Object)this.pluginInstaller);
                this.pluginInstaller = null;
            }
            if (!JpaNodeInfo.pcGetlocal(this)) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
            this.kernel = null;
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcFieldNames = new String[]{"cluster", "host", "local", "name", "password", "port", "protocol", "urlPath", "userName"};
        Class[] classArray = new Class[9];
        Class clazz = class$Lorg$apache$geronimo$farm$plugin$JpaClusterInfo != null ? class$Lorg$apache$geronimo$farm$plugin$JpaClusterInfo : (class$Lorg$apache$geronimo$farm$plugin$JpaClusterInfo = JpaNodeInfo.class$("org.apache.geronimo.farm.plugin.JpaClusterInfo"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        classArray[1] = clazz2;
        classArray[2] = Boolean.TYPE;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        classArray[5] = Integer.TYPE;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaNodeInfo.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz3 = class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo != null ? class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo : (class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo = JpaNodeInfo.class$("org.apache.geronimo.farm.plugin.JpaNodeInfo"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"node", (PersistenceCapable)new JpaNodeInfo());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.cluster = null;
        this.host = null;
        this.local = false;
        this.name = null;
        this.password = null;
        this.port = 0;
        this.protocol = null;
        this.urlPath = null;
        this.userName = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaNodeInfo jpaNodeInfo = new JpaNodeInfo();
        if (bl) {
            jpaNodeInfo.pcClearFields();
        }
        jpaNodeInfo.pcStateManager = stateManager;
        jpaNodeInfo.pcCopyKeyFieldsFromObjectId(object);
        return jpaNodeInfo;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaNodeInfo jpaNodeInfo = new JpaNodeInfo();
        if (bl) {
            jpaNodeInfo.pcClearFields();
        }
        jpaNodeInfo.pcStateManager = stateManager;
        return jpaNodeInfo;
    }

    protected static int pcGetManagedFieldCount() {
        return 9;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.cluster = (JpaClusterInfo)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.host = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.local = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.port = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.protocol = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.urlPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.userName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.cluster);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.host);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.local);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 5: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.port);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.protocol);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.urlPath);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userName);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaNodeInfo jpaNodeInfo, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.cluster = jpaNodeInfo.cluster;
                return;
            }
            case 1: {
                this.host = jpaNodeInfo.host;
                return;
            }
            case 2: {
                this.local = jpaNodeInfo.local;
                return;
            }
            case 3: {
                this.name = jpaNodeInfo.name;
                return;
            }
            case 4: {
                this.password = jpaNodeInfo.password;
                return;
            }
            case 5: {
                this.port = jpaNodeInfo.port;
                return;
            }
            case 6: {
                this.protocol = jpaNodeInfo.protocol;
                return;
            }
            case 7: {
                this.urlPath = jpaNodeInfo.urlPath;
                return;
            }
            case 8: {
                this.userName = jpaNodeInfo.userName;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaNodeInfo jpaNodeInfo = (JpaNodeInfo)object;
        if (jpaNodeInfo.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaNodeInfo, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(3 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.name = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo != null ? class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo : (class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo = JpaNodeInfo.class$("org.apache.geronimo.farm.plugin.JpaNodeInfo"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo != null ? class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo : (class$Lorg$apache$geronimo$farm$plugin$JpaNodeInfo = JpaNodeInfo.class$("org.apache.geronimo.farm.plugin.JpaNodeInfo"));
        return new StringId(clazz, this.name);
    }

    private static final JpaClusterInfo pcGetcluster(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.cluster;
        }
        int n = pcInheritedFieldCount + 0;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.cluster;
    }

    private static final void pcSetcluster(JpaNodeInfo jpaNodeInfo, JpaClusterInfo jpaClusterInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.cluster = jpaClusterInfo;
            return;
        }
        jpaNodeInfo.pcStateManager.settingObjectField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 0, (Object)jpaNodeInfo.cluster, (Object)jpaClusterInfo, 0);
    }

    private static final String pcGethost(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.host;
        }
        int n = pcInheritedFieldCount + 1;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.host;
    }

    private static final void pcSethost(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.host = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 1, jpaNodeInfo.host, string, 0);
    }

    private static final boolean pcGetlocal(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.local;
        }
        int n = pcInheritedFieldCount + 2;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.local;
    }

    private static final void pcSetlocal(JpaNodeInfo jpaNodeInfo, boolean bl) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.local = bl;
            return;
        }
        jpaNodeInfo.pcStateManager.settingBooleanField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 2, jpaNodeInfo.local, bl, 0);
    }

    private static final String pcGetname(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.name;
        }
        int n = pcInheritedFieldCount + 3;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.name;
    }

    private static final void pcSetname(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.name = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 3, jpaNodeInfo.name, string, 0);
    }

    private static final String pcGetpassword(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.password;
        }
        int n = pcInheritedFieldCount + 4;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.password;
    }

    private static final void pcSetpassword(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.password = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 4, jpaNodeInfo.password, string, 0);
    }

    private static final int pcGetport(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.port;
        }
        int n = pcInheritedFieldCount + 5;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.port;
    }

    private static final void pcSetport(JpaNodeInfo jpaNodeInfo, int n) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.port = n;
            return;
        }
        jpaNodeInfo.pcStateManager.settingIntField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 5, jpaNodeInfo.port, n, 0);
    }

    private static final String pcGetprotocol(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.protocol;
        }
        int n = pcInheritedFieldCount + 6;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.protocol;
    }

    private static final void pcSetprotocol(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.protocol = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 6, jpaNodeInfo.protocol, string, 0);
    }

    private static final String pcGeturlPath(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.urlPath;
        }
        int n = pcInheritedFieldCount + 7;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.urlPath;
    }

    private static final void pcSeturlPath(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.urlPath = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 7, jpaNodeInfo.urlPath, string, 0);
    }

    private static final String pcGetuserName(JpaNodeInfo jpaNodeInfo) {
        if (jpaNodeInfo.pcStateManager == null) {
            return jpaNodeInfo.userName;
        }
        int n = pcInheritedFieldCount + 8;
        jpaNodeInfo.pcStateManager.accessingField(n);
        return jpaNodeInfo.userName;
    }

    private static final void pcSetuserName(JpaNodeInfo jpaNodeInfo, String string) {
        if (jpaNodeInfo.pcStateManager == null) {
            jpaNodeInfo.userName = string;
            return;
        }
        jpaNodeInfo.pcStateManager.settingStringField((PersistenceCapable)jpaNodeInfo, pcInheritedFieldCount + 8, jpaNodeInfo.userName, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

