/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.ResourceSource;
import org.apache.geronimo.persistence.PersistenceUnitGBean;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.Persistence;
import org.apache.xbean.osgi.bundle.util.BundleResourceFinder;
import org.apache.xbean.osgi.bundle.util.DiscoveryRange;
import org.apache.xbean.osgi.bundle.util.ResourceDiscoveryFilter;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

@GBean(j2eeType="ModuleBuilder")
public class PersistenceUnitBuilder
implements ModuleBuilderExtension {
    private static final QName PERSISTENCE_QNAME = new QName("http://java.sun.com/xml/ns/persistence", "persistence");
    private final Environment defaultEnvironment;
    private final String defaultPersistenceProviderClassName;
    private final Properties defaultPersistenceUnitProperties;
    private final AbstractNameQuery defaultJtaDataSourceName;
    private final AbstractNameQuery defaultNonJtaDataSourceName;
    private final AbstractNameQuery extendedEntityManagerRegistryName;
    private static final String ANON_PU_NAME = "AnonymousPersistenceUnit";
    private static final String RESOURCE_SOURCE_CLASS_NAME = ResourceSource.class.getName();
    private final PackageAdmin packageAdmin;

    public PersistenceUnitBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="defaultPersistenceProviderClassName") String defaultPersistenceProviderClassName, @ParamAttribute(name="defaultJtaDataSourceName") String defaultJtaDataSourceName, @ParamAttribute(name="defaultNonJtaDataSourceName") String defaultNonJtaDataSourceName, @ParamAttribute(name="extendedEntityManagerRegistryName") AbstractNameQuery extendedEntityManagerRegistryName, @ParamAttribute(name="defaultPersistenceUnitProperties") Properties defaultPersistenceUnitProperties, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws URISyntaxException {
        this.defaultEnvironment = defaultEnvironment;
        this.defaultPersistenceProviderClassName = defaultPersistenceProviderClassName;
        this.defaultJtaDataSourceName = defaultJtaDataSourceName == null ? null : this.getAbstractNameQuery(defaultJtaDataSourceName);
        this.defaultNonJtaDataSourceName = defaultNonJtaDataSourceName == null ? null : this.getAbstractNameQuery(defaultNonJtaDataSourceName);
        this.extendedEntityManagerRegistryName = extendedEntityManagerRegistryName;
        this.defaultPersistenceUnitProperties = defaultPersistenceUnitProperties == null ? new Properties() : defaultPersistenceUnitProperties;
        ServiceReference sr = bundleContext.getServiceReference(PackageAdmin.class.getName());
        this.packageAdmin = (PackageAdmin)bundleContext.getService(sr);
    }

    public void createModule(Module module, Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void createModule(Module module, Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment environment, Object moduleContextInfo, AbstractName earName, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module, Collection configurationStores, ConfigurationStore targetConfigurationStore, Collection repository) throws DeploymentException {
    }

    public void initContext(EARContext earContext, Module module, Bundle bundle) throws DeploymentException {
        if (module.getDeployable() instanceof DeployableBundle) {
            return;
        }
        XmlObject container = (XmlObject)module.getVendorDD();
        XmlObject[] raws = container.selectChildren(PERSISTENCE_QNAME);
        HashMap<String, Persistence.PersistenceUnit> overrides = new HashMap<String, Persistence.PersistenceUnit>();
        try {
            for (XmlObject raw : raws) {
                Persistence persistence = this.fromXmlObject(raw);
                for (Persistence.PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                    overrides.put(persistenceUnit.getName().trim(), persistenceUnit);
                }
            }
        }
        catch (JAXBException e) {
            throw new DeploymentException("Parse Persistence configuration file failed", (Throwable)e);
        }
        try {
            final LinkedHashSet<String> manifestcpCopy = new LinkedHashSet<String>();
            boolean resolveWARcp = false;
            if (!module.isStandAlone() && module.getType() == ConfigurationModuleType.WAR) {
                resolveWARcp = true;
            }
            LinkedHashSet manifestcp = module.getClassPath();
            for (String classpath : manifestcp) {
                if (resolveWARcp) {
                    manifestcpCopy.add(module.resolve(classpath).toString());
                    continue;
                }
                manifestcpCopy.add(classpath);
            }
            if (module.isStandAlone() && module.getType() == ConfigurationModuleType.EJB) {
                manifestcpCopy.add("");
            }
            BundleResourceFinder finder = new BundleResourceFinder(this.packageAdmin, bundle, "", "META-INF/persistence.xml", new ResourceDiscoveryFilter(){

                public boolean rangeDiscoveryRequired(DiscoveryRange discoveryRange) {
                    return discoveryRange == DiscoveryRange.BUNDLE_CLASSPATH || discoveryRange == DiscoveryRange.FRAGMENT_BUNDLES;
                }

                public boolean zipFileDiscoveryRequired(String s) {
                    return manifestcpCopy.contains(s);
                }

                public boolean directoryDiscoveryRequired(String s) {
                    boolean found = false;
                    if (manifestcpCopy.contains(s)) {
                        found = true;
                    } else if (s.endsWith("/") && manifestcpCopy.contains(s.substring(0, s.length() - 1))) {
                        found = true;
                    }
                    return found;
                }
            });
            final HashMap persistenceURLs = new HashMap();
            finder.find(new BundleResourceFinder.ResourceFinderCallback(){

                public boolean foundInDirectory(Bundle bundle, String baseDir, URL url) throws Exception {
                    persistenceURLs.put(url, baseDir);
                    return true;
                }

                public boolean foundInJar(Bundle bundle, String jarName, ZipEntry entry, InputStream inputStream) throws Exception {
                    URL jarURL = bundle.getEntry(jarName);
                    URL url = new URL("jar:" + jarURL.toString() + "!/" + entry.getName());
                    persistenceURLs.put(url, jarName);
                    return true;
                }
            });
            if (raws.length > 0 || persistenceURLs.size() > 0) {
                EnvironmentBuilder.mergeEnvironments((Environment)module.getEnvironment(), (Environment)this.defaultEnvironment);
            }
            for (Map.Entry entry : persistenceURLs.entrySet()) {
                Persistence persistence;
                URL persistenceUrl = (URL)entry.getKey();
                String persistenceLocation = (String)entry.getValue();
                InputStream in = persistenceUrl.openStream();
                try {
                    persistence = (Persistence)JaxbJavaee.unmarshal(Persistence.class, (InputStream)in, (boolean)false);
                }
                catch (JAXBException e) {
                    throw new DeploymentException("Could not parse persistence.xml file: " + persistenceUrl, (Throwable)e);
                }
                finally {
                    in.close();
                }
                this.buildPersistenceUnits(persistence, overrides, module, persistenceLocation);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Could not look for META-INF/persistence.xml files", (Throwable)e);
        }
        for (Persistence.PersistenceUnit persistenceUnit : overrides.values()) {
            GBeanData data = this.installPersistenceUnitGBean(persistenceUnit, module, module.getTargetPath());
            this.respectExcludeUnlistedClasses(data);
        }
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
    }

    private void buildPersistenceUnits(Persistence persistence, Map<String, Persistence.PersistenceUnit> overrides, Module module, String persistenceModulePath) throws DeploymentException {
        List persistenceUnits = persistence.getPersistenceUnit();
        for (Persistence.PersistenceUnit persistenceUnit : persistenceUnits) {
            GBeanData data = this.installPersistenceUnitGBean(persistenceUnit, module, persistenceModulePath);
            String unitName = persistenceUnit.getName().trim();
            if (overrides.get(unitName) != null) {
                this.setOverrideableProperties(overrides.remove(unitName), data);
            }
            this.respectExcludeUnlistedClasses(data);
        }
    }

    private GBeanData installPersistenceUnitGBean(Persistence.PersistenceUnit persistenceUnit, Module module, String persistenceModulePath) throws DeploymentException {
        AbstractName abstractName;
        EARContext moduleContext = module.getEarContext();
        String persistenceUnitName = persistenceUnit.getName().trim();
        if (persistenceUnitName.length() == 0) {
            persistenceUnitName = ANON_PU_NAME;
        }
        if (persistenceModulePath == null || persistenceModulePath.length() == 0) {
            abstractName = moduleContext.getNaming().createChildName(module.getModuleName(), persistenceUnitName, "PersistenceUnit");
        } else {
            abstractName = moduleContext.getNaming().createChildName(module.getModuleName(), persistenceModulePath, "PersistenceUnitModule");
            abstractName = moduleContext.getNaming().createChildName(abstractName, moduleContext.getConfigID(), persistenceUnitName, "PersistenceUnit");
        }
        GBeanData gbeanData = new GBeanData(abstractName, PersistenceUnitGBean.class);
        try {
            moduleContext.addGBean(gbeanData);
        }
        catch (GBeanAlreadyExistsException e) {
            throw new DeploymentException("Duplicate persistenceUnit name " + persistenceUnitName, (Throwable)e);
        }
        gbeanData.setAttribute("persistenceUnitName", (Object)persistenceUnitName);
        gbeanData.setAttribute("persistenceUnitRoot", (Object)persistenceModulePath);
        gbeanData.setPriority(1);
        gbeanData.setAttribute("persistenceProviderClassName", (Object)this.defaultPersistenceProviderClassName);
        gbeanData.setAttribute("persistenceUnitTransactionType", (Object)"JTA");
        if (this.defaultJtaDataSourceName != null) {
            gbeanData.setReferencePattern("JtaDataSourceWrapper", this.defaultJtaDataSourceName);
        }
        if (this.defaultNonJtaDataSourceName != null) {
            gbeanData.setReferencePattern("NonJtaDataSourceWrapper", this.defaultNonJtaDataSourceName);
        }
        gbeanData.setAttribute("mappingFileNames", new ArrayList());
        gbeanData.setAttribute("excludeUnlistedClasses", (Object)false);
        gbeanData.setAttribute("managedClassNames", new ArrayList());
        gbeanData.setAttribute("jarFileUrls", new ArrayList());
        Properties properties = new Properties();
        gbeanData.setAttribute("properties", (Object)properties);
        properties.putAll((Map<?, ?>)this.defaultPersistenceUnitProperties);
        AbstractNameQuery transactionManagerName = moduleContext.getTransactionManagerName();
        gbeanData.setReferencePattern("TransactionManager", transactionManagerName);
        gbeanData.setReferencePattern("EntityManagerRegistry", this.extendedEntityManagerRegistryName);
        AbstractName validatorName = moduleContext.getNaming().createChildName(module.getModuleName(), "ValidatorFactory", "ValidatorFactory");
        gbeanData.setReferencePattern("ValidatorFactory", validatorName);
        this.setOverrideableProperties(persistenceUnit, gbeanData);
        return gbeanData;
    }

    private void setOverrideableProperties(Persistence.PersistenceUnit persistenceUnit, GBeanData gbeanData) throws DeploymentException {
        if (persistenceUnit.getProvider() != null) {
            gbeanData.setAttribute("persistenceProviderClassName", (Object)persistenceUnit.getProvider().trim());
        }
        if (persistenceUnit.getTransactionType() != null) {
            gbeanData.setAttribute("persistenceUnitTransactionType", (Object)persistenceUnit.getTransactionType());
        }
        if (persistenceUnit.getJtaDataSource() != null) {
            String jtaDataSourceString = persistenceUnit.getJtaDataSource().trim();
            try {
                AbstractNameQuery jtaDataSourceNameQuery = this.getAbstractNameQuery(jtaDataSourceString);
                gbeanData.setReferencePattern("JtaDataSourceWrapper", jtaDataSourceNameQuery);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not create jta-data-source AbstractNameQuery from string: " + jtaDataSourceString, (Throwable)e);
            }
        }
        if (persistenceUnit.getNonJtaDataSource() != null) {
            String nonJtaDataSourceString = persistenceUnit.getNonJtaDataSource().trim();
            try {
                AbstractNameQuery nonJtaDataSourceNameQuery = this.getAbstractNameQuery(nonJtaDataSourceString);
                gbeanData.setReferencePattern("NonJtaDataSourceWrapper", nonJtaDataSourceNameQuery);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not create non-jta-data-source AbstractNameQuery from string: " + nonJtaDataSourceString, (Throwable)e);
            }
        }
        List mappingFileNames = (List)gbeanData.getAttribute("mappingFileNames");
        List mappingFileNameStrings = persistenceUnit.getMappingFile();
        for (String mappingFileNameString : mappingFileNameStrings) {
            mappingFileNames.add(mappingFileNameString.trim());
        }
        if (persistenceUnit.isExcludeUnlistedClasses() != null && persistenceUnit.isExcludeUnlistedClasses().booleanValue()) {
            gbeanData.setAttribute("excludeUnlistedClasses", (Object)persistenceUnit.isExcludeUnlistedClasses());
        }
        List managedClassNameStrings = persistenceUnit.getClazz();
        List managedClassNames = (List)gbeanData.getAttribute("managedClassNames");
        for (String managedClassNameString : managedClassNameStrings) {
            managedClassNames.add(managedClassNameString.trim());
        }
        List jarFileUrls = (List)gbeanData.getAttribute("jarFileUrls");
        List jarFileUrlStrings = persistenceUnit.getJarFile();
        for (String jarFileUrlString : jarFileUrlStrings) {
            jarFileUrls.add(jarFileUrlString.trim());
        }
        if (persistenceUnit.getProperties() != null) {
            Properties properties = (Properties)gbeanData.getAttribute("properties");
            for (Persistence.PersistenceUnit.Properties.Property propertyObject : persistenceUnit.getProperties().getProperty()) {
                String key = propertyObject.getName().trim();
                String value = propertyObject.getValue().trim();
                properties.setProperty(key, value);
            }
        }
    }

    private void respectExcludeUnlistedClasses(GBeanData gbeanData) {
        boolean excludeUnlistedClasses = (Boolean)gbeanData.getAttribute("excludeUnlistedClasses");
        if (excludeUnlistedClasses) {
            gbeanData.clearAttribute("jarFileUrls");
        }
    }

    private AbstractNameQuery getAbstractNameQuery(String dataSourceString) throws URISyntaxException {
        if (dataSourceString.indexOf(61) == -1) {
            dataSourceString = "?name=" + dataSourceString;
        }
        AbstractNameQuery dataSourceNameQuery = new AbstractNameQuery(new URI(dataSourceString + "#" + RESOURCE_SOURCE_CLASS_NAME));
        return dataSourceNameQuery;
    }

    private Persistence fromXmlObject(XmlObject xmlObject) throws JAXBException {
        XmlObject newXmlObject = XmlObject.Factory.newInstance();
        XmlCursor newXmlCursor = newXmlObject.newCursor();
        newXmlCursor.toNextToken();
        newXmlCursor.beginElement(PERSISTENCE_QNAME);
        XmlCursor oldXmlCursor = xmlObject.newCursor();
        oldXmlCursor.copyXmlContents(newXmlCursor);
        oldXmlCursor.dispose();
        newXmlCursor.dispose();
        XMLStreamReader reader = newXmlObject.newXMLStreamReader();
        JAXBContext context = JAXBContextFactory.newInstance((Class[])new Class[]{Persistence.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        return (Persistence)unmarshaller.unmarshal(reader);
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.singleton((QName)PERSISTENCE_QNAME);
    }
}

