/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.annotation.PersistenceContextAnnotationHelper;
import org.apache.geronimo.j2ee.deployment.annotation.PersistenceUnitAnnotationHelper;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.naming.reference.PersistenceContextReference;
import org.apache.geronimo.naming.reference.PersistenceUnitReference;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceContextTypeType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceUnitRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerPersistenceUnitRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPropertyType;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceContextType;
import org.apache.openejb.jee.PersistenceRef;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.Property;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

@GBean(j2eeType="ModuleBuilder")
public class PersistenceRefBuilder
extends AbstractNamingBuilder {
    private static final QName PERSISTENCE_UNIT_REF_QNAME = new QName("http://java.sun.com/xml/ns/javaee", "persistence-unit-ref");
    private static final QNameSet PERSISTENCE_UNIT_REF_QNAME_SET = QNameSet.singleton((QName)PERSISTENCE_UNIT_REF_QNAME);
    private static final QName GER_PERSISTENCE_UNIT_REF_QNAME = GerPersistenceUnitRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_PERSISTENCE_UNIT_REF_QNAME_SET = QNameSet.singleton((QName)GER_PERSISTENCE_UNIT_REF_QNAME);
    private static final Set PERSISTENCE_UNIT_INTERFACE_TYPES = Collections.singleton("org.apache.geronimo.persistence.PersistenceUnitGBean");
    private static final QName GER_PERSISTENCE_CONTEXT_REF_QNAME = GerPersistenceContextRefDocument.type.getDocumentElementName();
    private static final QNameSet GER_PERSISTENCE_CONTEXT_REF_QNAME_SET = QNameSet.singleton((QName)GER_PERSISTENCE_CONTEXT_REF_QNAME);
    private final AbstractNameQuery defaultPersistenceUnitAbstractNameQuery;
    private final boolean strictMatching;

    public PersistenceRefBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="defaultPersistenceUnitAbstractNameQuery") AbstractNameQuery defaultPersistenceUnitAbstractNameQuery, @ParamAttribute(name="strictMatching") boolean strictMatching) {
        super(defaultEnvironment);
        this.defaultPersistenceUnitAbstractNameQuery = defaultPersistenceUnitAbstractNameQuery;
        this.strictMatching = strictMatching;
    }

    protected boolean willMergeEnvironment(JndiConsumer specDD, XmlObject plan) throws DeploymentException {
        if (specDD != null && !specDD.getPersistenceUnitRef().isEmpty()) {
            return true;
        }
        return plan != null && plan.selectChildren(GER_PERSISTENCE_UNIT_REF_QNAME_SET).length > 0;
    }

    public void buildNaming(JndiConsumer specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        String persistenceContextRefName;
        String persistenceUnitRefName;
        Configuration localConfiguration = module.getEarContext().getConfiguration();
        ArrayList<DeploymentException> problems = new ArrayList<DeploymentException>();
        if (module.getClassFinder() != null) {
            this.processAnnotations(specDD, module);
        }
        Collection specPersistenceUnitRefsUntyped = specDD.getPersistenceUnitRef();
        Map<String, GerPersistenceUnitRefType> gerPersistenceUnitRefsUntyped = this.getGerPersistenceUnitRefs(plan);
        for (Map.Entry entry : specDD.getPersistenceUnitRefMap().entrySet()) {
            try {
                persistenceUnitRefName = (String)entry.getKey();
                PersistenceUnitRef persistenceUnitRef = (PersistenceUnitRef)entry.getValue();
                GerPersistenceUnitRefType gerPersistenceUnitRef = gerPersistenceUnitRefsUntyped.remove(persistenceUnitRefName);
                AbstractNameQuery persistenceUnitNameQuery = gerPersistenceUnitRef != null ? this.findPersistenceUnit(gerPersistenceUnitRef, localConfiguration) : this.findPersistenceUnitQuery(module, localConfiguration, (PersistenceRef)persistenceUnitRef);
                PersistenceUnitReference reference = new PersistenceUnitReference(module.getConfigId(), persistenceUnitNameQuery);
                this.put(persistenceUnitRefName, reference, ReferenceType.PERSISTENCE_UNIT, module.getJndiContext(), persistenceUnitRef.getInjectionTarget(), sharedContext);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        for (GerPersistenceUnitRefType gerPersistenceUnitRef : gerPersistenceUnitRefsUntyped.values()) {
            try {
                persistenceUnitRefName = gerPersistenceUnitRef.getPersistenceUnitRefName();
                AbstractNameQuery persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceUnitRef, localConfiguration);
                PersistenceUnitReference reference = new PersistenceUnitReference(module.getConfigId(), persistenceUnitNameQuery);
                this.put(persistenceUnitRefName, reference, ReferenceType.PERSISTENCE_UNIT, module.getJndiContext(), Collections.emptySet(), sharedContext);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        Collection specPersistenceContextRefsUntyped = specDD.getPersistenceContextRef();
        Map<String, GerPersistenceContextRefType> gerPersistenceContextRefsUntyped = this.getGerPersistenceContextRefs(plan);
        for (Map.Entry entry : specDD.getPersistenceContextRefMap().entrySet()) {
            try {
                AbstractNameQuery persistenceUnitNameQuery;
                persistenceContextRefName = (String)entry.getKey();
                PersistenceContextRef persistenceContextRef = (PersistenceContextRef)entry.getValue();
                PersistenceContextType persistenceContextType = persistenceContextRef.getPersistenceContextType();
                boolean transactionScoped = persistenceContextType == null || persistenceContextType.equals((Object)PersistenceContextType.TRANSACTION);
                List propertyTypes = persistenceContextRef.getPersistenceProperty();
                HashMap<String, String> properties = new HashMap<String, String>();
                for (Property propertyType : propertyTypes) {
                    String key = propertyType.getName();
                    String value = propertyType.getValue();
                    properties.put(key, value);
                }
                GerPersistenceContextRefType gerPersistenceContextRef = gerPersistenceContextRefsUntyped.remove(persistenceContextRefName);
                if (gerPersistenceContextRef != null) {
                    persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceContextRef, localConfiguration);
                    this.addProperties(gerPersistenceContextRef, properties);
                } else {
                    persistenceUnitNameQuery = this.findPersistenceUnitQuery(module, localConfiguration, (PersistenceRef)persistenceContextRef);
                }
                PersistenceContextReference reference = new PersistenceContextReference(module.getConfigId(), persistenceUnitNameQuery, transactionScoped, properties);
                this.put(persistenceContextRefName, reference, ReferenceType.PERSISTENCE_CONTEXT, module.getJndiContext(), persistenceContextRef.getInjectionTarget(), sharedContext);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        for (GerPersistenceContextRefType gerPersistenceContextRef : gerPersistenceContextRefsUntyped.values()) {
            try {
                persistenceContextRefName = gerPersistenceContextRef.getPersistenceContextRefName();
                GerPersistenceContextTypeType.Enum persistenceContextType = gerPersistenceContextRef.getPersistenceContextType();
                boolean transactionScoped = persistenceContextType == null || !persistenceContextType.equals(GerPersistenceContextTypeType.EXTENDED);
                HashMap<String, String> properties = new HashMap<String, String>();
                this.addProperties(gerPersistenceContextRef, properties);
                AbstractNameQuery persistenceUnitNameQuery = this.findPersistenceUnit(gerPersistenceContextRef, localConfiguration);
                PersistenceContextReference reference = new PersistenceContextReference(module.getConfigId(), persistenceUnitNameQuery, transactionScoped, properties);
                this.put(persistenceContextRefName, reference, ReferenceType.PERSISTENCE_CONTEXT, module.getJndiContext(), Collections.emptySet(), sharedContext);
            }
            catch (DeploymentException e) {
                problems.add(e);
            }
        }
        if (!problems.isEmpty()) {
            throw new DeploymentException("At least one deployment problem:", problems);
        }
    }

    private AbstractNameQuery findPersistenceUnitQuery(Module module, Configuration localConfiguration, PersistenceRef persistenceRef) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery;
        if (persistenceRef.getPersistenceUnitName() != null && !persistenceRef.getPersistenceUnitName().trim().isEmpty()) {
            String persistenceUnitName = persistenceRef.getPersistenceUnitName().trim();
            persistenceUnitNameQuery = this.findPersistenceUnit(module, localConfiguration, persistenceUnitName);
        } else {
            LinkedHashSet gbeans = new LinkedHashSet();
            do {
                AbstractName childName = module.getEarContext().getNaming().createChildName(module.getModuleName(), "", "PersistenceUnit");
                HashMap name = new HashMap(childName.getName());
                name.remove("name");
                persistenceUnitNameQuery = new AbstractNameQuery(null, name, PERSISTENCE_UNIT_INTERFACE_TYPES);
                Set<AbstractNameQuery> patterns = Collections.singleton(persistenceUnitNameQuery);
                gbeans = localConfiguration.findGBeanDatas(module.getEarContext().getConfiguration(), patterns);
                if (gbeans.isEmpty()) continue;
                persistenceUnitNameQuery = PersistenceRefBuilder.checkForDefaultPersistenceUnit(gbeans);
                break;
            } while ((module = module.getParentModule()) != null);
            if (gbeans.isEmpty()) {
                if (this.defaultPersistenceUnitAbstractNameQuery == null) {
                    throw new DeploymentException("No default PersistenceUnit specified, and none located");
                }
                persistenceUnitNameQuery = this.defaultPersistenceUnitAbstractNameQuery;
            }
            PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, false, false, new HashSet<AbstractName>());
        }
        return persistenceUnitNameQuery;
    }

    private AbstractNameQuery findPersistenceUnit(Module module, Configuration localConfiguration, String persistenceUnitName) throws DeploymentException {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put("j2eeType", "PersistenceUnit");
        nameMap.put("name", persistenceUnitName);
        AbstractNameQuery persistenceUnitNameQuery = new AbstractNameQuery(null, nameMap, PERSISTENCE_UNIT_INTERFACE_TYPES);
        HashSet<AbstractName> matches = new HashSet<AbstractName>();
        switch (PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, this.strictMatching, true, matches)) {
            case 1: {
                return persistenceUnitNameQuery;
            }
            case 0: {
                persistenceUnitName = "persistence/" + persistenceUnitName;
                nameMap.put("name", persistenceUnitName);
                persistenceUnitNameQuery = new AbstractNameQuery(null, nameMap, PERSISTENCE_UNIT_INTERFACE_TYPES);
                if (1 != PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, false, true, new HashSet<AbstractName>())) break;
                return persistenceUnitNameQuery;
            }
        }
        AbstractName childName = module.getEarContext().getNaming().createChildName(module.getModuleName(), persistenceUnitName, "PersistenceUnit");
        persistenceUnitNameQuery = new AbstractNameQuery(null, childName.getName(), PERSISTENCE_UNIT_INTERFACE_TYPES);
        try {
            PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, false, false, new HashSet<AbstractName>());
            return persistenceUnitNameQuery;
        }
        catch (DeploymentException e) {
            for (AbstractName abstractName : matches) {
                if (!this.isParentModule(abstractName.getName(), childName.getName())) continue;
                return new AbstractNameQuery(abstractName.getArtifact(), abstractName.getName(), PERSISTENCE_UNIT_INTERFACE_TYPES);
            }
            throw e;
        }
    }

    private static String getModuleType(Map name) {
        if (name.containsKey("WebModule")) {
            return "WebModule";
        }
        if (name.containsKey("EJBModule")) {
            return "EJBModule";
        }
        if (name.containsKey("AppClientModule")) {
            return "AppClientModule";
        }
        if (name.containsKey("AppClientModule")) {
            return "AppClientModule";
        }
        return null;
    }

    private boolean isParentModule(Map parent, Map child) {
        String parentModuleType = PersistenceRefBuilder.getModuleType(parent);
        String childModuleType = PersistenceRefBuilder.getModuleType(child);
        return parentModuleType == null && childModuleType != null;
    }

    private static int checkForGBean(Configuration localConfiguration, AbstractNameQuery persistenceQuery, boolean allowNone, boolean allowMultiple, Set<AbstractName> matches) throws DeploymentException {
        try {
            localConfiguration.findGBeanData(persistenceQuery);
            return 1;
        }
        catch (GBeanNotFoundException e) {
            if (e.hasMatches()) {
                if (allowMultiple) {
                    matches.addAll(e.getMatches());
                    return 2;
                }
                throw new DeploymentException("More than one reference at deploy time for query " + persistenceQuery + ". " + e.getMatches(), (Throwable)e);
            }
            if (allowNone) {
                return 0;
            }
            throw new DeploymentException("No references found at deploy time for query " + persistenceQuery, (Throwable)e);
        }
    }

    private static AbstractNameQuery checkForDefaultPersistenceUnit(LinkedHashSet<GBeanData> gbeans) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery = null;
        Iterator it = gbeans.iterator();
        while (it.hasNext()) {
            GBeanData gbean = (GBeanData)it.next();
            AbstractName name = gbean.getAbstractName();
            Map nameMap = name.getName();
            if ("cmp".equals(nameMap.get("name"))) {
                it.remove();
                continue;
            }
            persistenceUnitNameQuery = new AbstractNameQuery(null, name.getName());
        }
        if (gbeans.size() > 1) {
            throw new DeploymentException("Too many matches for no-name persistence unit: " + gbeans);
        }
        return persistenceUnitNameQuery;
    }

    private void processAnnotations(JndiConsumer specDD, Module module) throws DeploymentException {
        PersistenceUnitAnnotationHelper.processAnnotations((JndiConsumer)specDD, (AbstractFinder)module.getClassFinder());
        PersistenceContextAnnotationHelper.processAnnotations((JndiConsumer)specDD, (AbstractFinder)module.getClassFinder());
    }

    private AbstractNameQuery findPersistenceUnit(GerPersistenceUnitRefType gerPersistenceRef, Configuration localConfiguration) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery;
        if (gerPersistenceRef.isSetPersistenceUnitName()) {
            String persistenceUnitName = gerPersistenceRef.getPersistenceUnitName();
            persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
        } else {
            GerPatternType gbeanLocator = gerPersistenceRef.getPattern();
            persistenceUnitNameQuery = PersistenceRefBuilder.buildAbstractNameQuery((GerPatternType)gbeanLocator, null, null, (Set)PERSISTENCE_UNIT_INTERFACE_TYPES);
        }
        PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, false, false, new HashSet<AbstractName>());
        return persistenceUnitNameQuery;
    }

    private AbstractNameQuery findPersistenceUnit(GerPersistenceContextRefType persistenceContextRef, Configuration localConfiguration) throws DeploymentException {
        AbstractNameQuery persistenceUnitNameQuery;
        if (persistenceContextRef.isSetPersistenceUnitName()) {
            String persistenceUnitName = persistenceContextRef.getPersistenceUnitName();
            persistenceUnitNameQuery = new AbstractNameQuery(null, Collections.singletonMap("name", persistenceUnitName), PERSISTENCE_UNIT_INTERFACE_TYPES);
        } else {
            GerPatternType gbeanLocator = persistenceContextRef.getPattern();
            persistenceUnitNameQuery = PersistenceRefBuilder.buildAbstractNameQuery((GerPatternType)gbeanLocator, null, null, (Set)PERSISTENCE_UNIT_INTERFACE_TYPES);
        }
        PersistenceRefBuilder.checkForGBean(localConfiguration, persistenceUnitNameQuery, false, false, new HashSet<AbstractName>());
        return persistenceUnitNameQuery;
    }

    public QNameSet getSpecQNameSet() {
        SchemaConversionUtils.registerNamespaceConversions(Collections.singletonMap(GER_PERSISTENCE_UNIT_REF_QNAME.getLocalPart(), new NamespaceElementConverter(GER_PERSISTENCE_UNIT_REF_QNAME.getNamespaceURI())));
        return PERSISTENCE_UNIT_REF_QNAME_SET;
    }

    public QNameSet getPlanQNameSet() {
        return GER_PERSISTENCE_UNIT_REF_QNAME_SET;
    }

    private Map<String, GerPersistenceUnitRefType> getGerPersistenceUnitRefs(XmlObject plan) throws DeploymentException {
        HashMap<String, GerPersistenceUnitRefType> map = new HashMap<String, GerPersistenceUnitRefType>();
        if (plan != null) {
            List refs = PersistenceRefBuilder.convert((XmlObject[])plan.selectChildren(GER_PERSISTENCE_UNIT_REF_QNAME_SET), (NamespaceElementConverter)NAMING_CONVERTER, GerPersistenceUnitRefType.class, (SchemaType)GerPersistenceUnitRefType.type);
            for (GerPersistenceUnitRefType ref : refs) {
                map.put(PersistenceRefBuilder.getJndiName((String)ref.getPersistenceUnitRefName().trim()), ref);
            }
        }
        return map;
    }

    private void addProperties(GerPersistenceContextRefType persistenceContextRef, Map<String, String> properties) {
        GerPropertyType[] propertyTypes;
        for (GerPropertyType propertyType : propertyTypes = persistenceContextRef.getPropertyArray()) {
            String key = propertyType.getKey();
            String value = propertyType.getValue();
            properties.put(key, value);
        }
    }

    private Map<String, GerPersistenceContextRefType> getGerPersistenceContextRefs(XmlObject plan) throws DeploymentException {
        HashMap<String, GerPersistenceContextRefType> map = new HashMap<String, GerPersistenceContextRefType>();
        if (plan != null) {
            List refs = PersistenceRefBuilder.convert((XmlObject[])plan.selectChildren(GER_PERSISTENCE_CONTEXT_REF_QNAME_SET), (NamespaceElementConverter)NAMING_CONVERTER, GerPersistenceContextRefType.class, (SchemaType)GerPersistenceContextRefType.type);
            for (GerPersistenceContextRefType ref : refs) {
                map.put(PersistenceRefBuilder.getJndiName((String)ref.getPersistenceContextRefName().trim()), ref);
            }
        }
        return map;
    }
}

