/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.geronimo.connector.outbound.ConnectionFactorySource;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.classloader.JarFileClassLoader;
import org.apache.geronimo.persistence.CMPEntityManagerExtended;
import org.apache.geronimo.persistence.CMPEntityManagerTxScoped;
import org.apache.geronimo.persistence.TransformerWrapper;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transformer.TransformerAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitGBean
implements GBeanLifecycle {
    private final PersistenceUnitInfoImpl persistenceUnitInfo;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionManagerImpl transactionManager;
    public static final GBeanInfo GBEAN_INFO;

    public PersistenceUnitGBean() {
        this.persistenceUnitInfo = null;
        this.entityManagerFactory = null;
        this.transactionManager = null;
    }

    public PersistenceUnitGBean(String persistenceUnitName, String persistenceProviderClassName, String persistenceUnitTransactionTypeString, ConnectionFactorySource jtaDataSourceWrapper, ConnectionFactorySource nonJtaDataSourceWrapper, List mappingFileNamesUntyped, List jarFileUrlsUntyped, URL persistenceUnitRootUrl, List managedClassNamesUntyped, boolean excludeUnlistedClassesValue, Properties properties, TransactionManagerImpl transactionManager, ClassLoader classLoader) {
        ArrayList<String> mappingFileNames = mappingFileNamesUntyped == null ? new ArrayList<String>() : new ArrayList(mappingFileNamesUntyped);
        ArrayList<URL> jarFileUrls = jarFileUrlsUntyped == null ? new ArrayList<URL>() : new ArrayList(jarFileUrlsUntyped);
        ArrayList<String> managedClassNames = managedClassNamesUntyped == null ? new ArrayList<String>() : new ArrayList(managedClassNamesUntyped);
        PersistenceUnitTransactionType persistenceUnitTransactionType = persistenceUnitTransactionTypeString == null ? PersistenceUnitTransactionType.JTA : PersistenceUnitTransactionType.valueOf((String)persistenceUnitTransactionTypeString);
        this.persistenceUnitInfo = new PersistenceUnitInfoImpl(persistenceUnitName, persistenceProviderClassName, persistenceUnitTransactionType, jtaDataSourceWrapper == null ? null : (DataSource)jtaDataSourceWrapper.$getResource(), nonJtaDataSourceWrapper == null ? null : (DataSource)nonJtaDataSourceWrapper.$getResource(), mappingFileNames, jarFileUrls, persistenceUnitRootUrl, managedClassNames, excludeUnlistedClassesValue, properties, classLoader);
        try {
            Class<?> clazz = classLoader.loadClass(persistenceProviderClassName);
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            this.entityManagerFactory = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.persistenceUnitInfo, (Map)properties);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Could not locate PersistenceProvider class: " + persistenceProviderClassName + " in classloader " + classLoader, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Could not create PersistenceProvider instance: " + persistenceProviderClassName + " loaded from classloader " + classLoader, (Throwable)e);
        }
        this.transactionManager = transactionManager;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManager getEntityManager(boolean transactionScoped, Map properties) {
        if (transactionScoped) {
            return new CMPEntityManagerTxScoped(this.transactionManager, this.getPersistenceUnitName(), this.entityManagerFactory, properties);
        }
        return new CMPEntityManagerExtended(this.transactionManager, this.getPersistenceUnitName(), this.entityManagerFactory, properties);
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceUnitInfo.getPersistenceProviderClassName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.persistenceUnitInfo.getTransactionType();
    }

    public DataSource getJtaDataSource() {
        return this.persistenceUnitInfo.getJtaDataSource();
    }

    public DataSource getNonJtaDataSource() {
        return this.persistenceUnitInfo.getNonJtaDataSource();
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnitInfo.getMappingFileNames();
    }

    public List<URL> getJarFileUrls() {
        return this.persistenceUnitInfo.getJarFileUrls();
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitInfo.getPersistenceUnitRootUrl();
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnitInfo.getManagedClassNames();
    }

    public boolean excludeUnlistedClasses() {
        return this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    public Properties getProperties() {
        return this.persistenceUnitInfo.getProperties();
    }

    public ClassLoader getClassLoader() {
        return this.persistenceUnitInfo.getClassLoader();
    }

    public void addTransformer(ClassTransformer classTransformer) {
        this.persistenceUnitInfo.addTransformer(classTransformer);
    }

    public ClassLoader getNewTempClassLoader() {
        return this.persistenceUnitInfo.getNewTempClassLoader();
    }

    public void doStart() throws Exception {
    }

    public void doStop() throws Exception {
        this.entityManagerFactory.close();
    }

    public void doFail() {
        this.entityManagerFactory.close();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(PersistenceUnitGBean.class);
        infoBuilder.setPriority(1);
        infoBuilder.addAttribute("persistenceUnitName", String.class, true, true);
        infoBuilder.addAttribute("persistenceProviderClassName", String.class, true, true);
        infoBuilder.addAttribute("persistenceUnitTransactionType", String.class, true, true);
        infoBuilder.addAttribute("mappingFileNames", List.class, true, true);
        infoBuilder.addAttribute("jarFileUrls", List.class, true, true);
        infoBuilder.addAttribute("persistenceUnitRootUrl", URL.class, true, true);
        infoBuilder.addAttribute("managedClassNames", List.class, true, true);
        infoBuilder.addAttribute("excludeUnlistedClasses", Boolean.TYPE, true, true);
        infoBuilder.addAttribute("properties", Properties.class, true, true);
        infoBuilder.addReference("TransactionManager", TransactionManagerImpl.class, "TransactionManager");
        infoBuilder.addReference("JtaDataSourceWrapper", ConnectionFactorySource.class, "JCAManagedConnectionFactory");
        infoBuilder.addReference("NonJtaDataSourceWrapper", ConnectionFactorySource.class, "JCAManagedConnectionFactory");
        infoBuilder.addOperation("getEntityManagerFactory");
        infoBuilder.addOperation("getEntityManager", new Class[]{Boolean.TYPE, Map.class});
        infoBuilder.setConstructor(new String[]{"persistenceUnitName", "persistenceProviderClassName", "persistenceUnitTransactionType", "JtaDataSourceWrapper", "NonJtaDataSourceWrapper", "mappingFileNames", "jarFileUrls", "persistenceUnitRootUrl", "managedClassNames", "excludeUnlistedClasses", "properties", "TransactionManager", "classLoader"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;
        private final String persistenceProviderClassName;
        private final PersistenceUnitTransactionType persistenceUnitTransactionType;
        private final DataSource jtaDataSource;
        private final DataSource nonJtaDataSource;
        private final List<String> mappingFileNames;
        private final List<URL> jarFileUrls;
        private final URL persistenceUnitRootUrl;
        private final List<String> managedClassNames;
        private final boolean excludeUnlistedClassesValue;
        private final Properties properties;
        private final ClassLoader classLoader;

        public PersistenceUnitInfoImpl(String persistenceUnitName, String persistenceProviderClassName, PersistenceUnitTransactionType persistenceUnitTransactionType, DataSource jtaDataSource, DataSource nonJtaDataSource, List<String> mappingFileNames, List<URL> jarFileUrls, URL persistenceUnitRootUrl, List<String> managedClassNames, boolean excludeUnlistedClassesValue, Properties properties, ClassLoader classLoader) {
            this.persistenceUnitName = persistenceUnitName;
            this.persistenceProviderClassName = persistenceProviderClassName;
            this.persistenceUnitTransactionType = persistenceUnitTransactionType;
            this.jtaDataSource = jtaDataSource;
            this.nonJtaDataSource = nonJtaDataSource;
            this.mappingFileNames = mappingFileNames;
            this.jarFileUrls = jarFileUrls;
            this.persistenceUnitRootUrl = persistenceUnitRootUrl;
            this.managedClassNames = managedClassNames;
            this.excludeUnlistedClassesValue = excludeUnlistedClassesValue;
            this.properties = properties;
            this.classLoader = classLoader;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return this.persistenceProviderClassName;
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.persistenceUnitTransactionType;
        }

        public DataSource getJtaDataSource() {
            return this.jtaDataSource;
        }

        public DataSource getNonJtaDataSource() {
            return this.nonJtaDataSource;
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return this.jarFileUrls;
        }

        public URL getPersistenceUnitRootUrl() {
            return this.persistenceUnitRootUrl;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return this.excludeUnlistedClassesValue;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void addTransformer(ClassTransformer classTransformer) {
            TransformerAgent.addTransformer((ClassFileTransformer)new TransformerWrapper(classTransformer, this.classLoader));
        }

        public ClassLoader getNewTempClassLoader() {
            return JarFileClassLoader.copy((ClassLoader)this.classLoader);
        }
    }
}

