/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.persistence;

import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.apache.geronimo.persistence.EntityManagerExtendedRegistry;
import org.apache.geronimo.persistence.EntityManagerWrapper;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalCMPEntityManagerExtended
implements EntityManager,
EntityManagerWrapper {
    private final EntityManager entityManager;
    private final String persistenceUnit;
    private final TransactionManagerImpl transactionManager;
    private final AtomicInteger count = new AtomicInteger();

    public InternalCMPEntityManagerExtended(EntityManager entityManager, String persistenceUnit, TransactionManagerImpl transactionManager) {
        this.entityManager = entityManager;
        this.persistenceUnit = persistenceUnit;
        this.transactionManager = transactionManager;
        if (transactionManager.getTransaction() != null) {
            this.joinTransaction();
        }
    }

    void registerBean() {
        this.count.getAndIncrement();
    }

    void beanRemoved() {
        if (this.count.decrementAndGet() == 0) {
            this.entityManager.close();
            EntityManagerExtendedRegistry.clearEntityManager(this.persistenceUnit);
        }
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void persist(Object o) {
        this.entityManager.persist(o);
    }

    public <T> T merge(T t) {
        return (T)this.entityManager.merge(t);
    }

    public void remove(Object o) {
        this.entityManager.remove(o);
    }

    public <T> T find(Class<T> aClass, Object o) {
        return (T)this.entityManager.find(aClass, o);
    }

    public <T> T getReference(Class<T> aClass, Object o) {
        return (T)this.entityManager.getReference(aClass, o);
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.entityManager.setFlushMode(flushModeType);
    }

    public FlushModeType getFlushMode() {
        return this.entityManager.getFlushMode();
    }

    public void lock(Object o, LockModeType lockModeType) {
        this.entityManager.lock(o, lockModeType);
    }

    public void refresh(Object o) {
        this.entityManager.refresh(o);
    }

    public void clear() {
        this.entityManager.clear();
    }

    public boolean contains(Object o) {
        return this.entityManager.contains(o);
    }

    public Query createQuery(String s) {
        return this.entityManager.createQuery(s);
    }

    public Query createNamedQuery(String s) {
        return this.entityManager.createNamedQuery(s);
    }

    public Query createNativeQuery(String s) {
        return this.entityManager.createNativeQuery(s);
    }

    public Query createNativeQuery(String s, Class aClass) {
        return this.entityManager.createNativeQuery(s, aClass);
    }

    public Query createNativeQuery(String s, String s1) {
        return this.entityManager.createNativeQuery(s, s1);
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("You cannot call getTransaction on a container managed EntityManager");
    }

    public void joinTransaction() {
        TransactionImpl transaction = (TransactionImpl)this.transactionManager.getTransaction();
        transaction.setEntityManager(this.persistenceUnit, (Object)this);
        this.entityManager.joinTransaction();
    }

    public Object getDelegate() {
        return this.entityManager.getDelegate();
    }
}

