/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBObject;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.openejb.DeepBindableContext;
import org.apache.geronimo.openejb.EjbDeploymentIdAccessor;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.Container;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.xbean.naming.context.ImmutableFederatedContext;
import org.osgi.framework.Bundle;

public class EjbDeployment
implements EJB,
EjbDeploymentIdAccessor {
    private final String objectName;
    protected final String deploymentId;
    private final String ejbName;
    private final String homeInterfaceName;
    private final String remoteInterfaceName;
    private final String localHomeInterfaceName;
    private final String localInterfaceName;
    private final String serviceEndpointInterfaceName;
    private final String beanClassName;
    private final ClassLoader classLoader;
    private final Bundle bundle;
    private final boolean securityEnabled;
    private final Subject defaultSubject;
    private final Subject runAs;
    private final Context componentContext;
    private final Context moduleContext;
    private final Context applicationContext;
    private final Context globalContext;
    private final Set<String> unshareableResources;
    private final Set<String> applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    protected final OpenEjbSystem openEjbSystem;
    protected AtomicReference<BeanContext> deploymentInfo = new AtomicReference();

    public EjbDeployment(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamAttribute(name="deploymentId") String deploymentId, @ParamAttribute(name="ejbName") String ejbName, @ParamAttribute(name="homeInterfaceName") String homeInterfaceName, @ParamAttribute(name="remoteInterfaceName") String remoteInterfaceName, @ParamAttribute(name="localHomeInterfaceName") String localHomeInterfaceName, @ParamAttribute(name="localInterfaceName") String localInterfaceName, @ParamAttribute(name="serviceEndpointInterfaceName") String serviceEndpointInterfaceName, @ParamAttribute(name="beanClassName") String beanClassName, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="securityEnabled") boolean securityEnabled, @ParamAttribute(name="defaultRole") String defaultRole, @ParamAttribute(name="runAsRole") String runAsRole, @ParamReference(name="RunAsSource", namingType="JACCManager") RunAsSource runAsSource, @ParamReference(name="ApplicationJndi", namingType="GBEAN") ApplicationJndi applicationJndi, @ParamAttribute(name="moduleContextMap") Map<String, Object> moduleJndi, @ParamAttribute(name="componentContextMap") Map<String, Object> compContext, @ParamAttribute(name="unshareableResources") Set<String> unshareableResources, @ParamAttribute(name="applicationManagedSecurityResources") Set<String> applicationManagedSecurityResources, @ParamReference(name="TrackedConnectionAssociator") TrackedConnectionAssociator trackedConnectionAssociator, @ParamReference(name="TransactionManager", namingType="JTAResource") GeronimoTransactionManager transactionManager, @ParamAttribute(name="beanManagedTransactions") boolean beanManagedTransactions, @ParamReference(name="OpenEjbSystem") OpenEjbSystem openEjbSystem, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) throws LoginException, NamingException {
        this.objectName = objectName;
        this.deploymentId = deploymentId;
        this.ejbName = ejbName;
        this.homeInterfaceName = homeInterfaceName;
        this.remoteInterfaceName = remoteInterfaceName;
        this.localHomeInterfaceName = localHomeInterfaceName;
        this.localInterfaceName = localInterfaceName;
        this.serviceEndpointInterfaceName = serviceEndpointInterfaceName;
        this.beanClassName = beanClassName;
        this.classLoader = classLoader;
        this.bundle = bundle;
        this.securityEnabled = securityEnabled;
        if (runAsSource == null) {
            runAsSource = RunAsSource.NULL;
        }
        this.defaultSubject = defaultRole == null ? runAsSource.getDefaultSubject() : runAsSource.getSubjectForRole(defaultRole);
        this.runAs = runAsSource.getSubjectForRole(runAsRole);
        this.componentContext = EnterpriseNamingContext.livenReferences(compContext, (UserTransaction)(beanManagedTransactions ? transactionManager : null), (Kernel)kernel, (ClassLoader)classLoader, (Bundle)bundle, (String)"comp/");
        this.moduleContext = EnterpriseNamingContext.livenReferences(moduleJndi, null, (Kernel)kernel, (ClassLoader)classLoader, (Bundle)bundle, (String)"module/");
        this.applicationContext = applicationJndi.getApplicationContext();
        this.globalContext = applicationJndi.getGlobalContext();
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.openEjbSystem = openEjbSystem;
    }

    public BeanContext getDeploymentInfo() {
        return this.deploymentInfo.get();
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public String getLocalHomeInterfaceName() {
        return this.localHomeInterfaceName;
    }

    public String getLocalInterfaceName() {
        return this.localInterfaceName;
    }

    public String getServiceEndpointInterfaceName() {
        return this.serviceEndpointInterfaceName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public Subject getDefaultSubject() {
        return this.defaultSubject;
    }

    public Subject getRunAs() {
        return this.runAs;
    }

    public Set<String> getUnshareableResources() {
        return this.unshareableResources;
    }

    public Set<String> getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public EJBHome getEJBHome() {
        return this.getDeploymentInfo().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.getDeploymentInfo().getEJBLocalHome();
    }

    public Object getBusinessLocalHome() {
        return this.getDeploymentInfo().getBusinessLocalHome();
    }

    public Object getBusinessRemoteHome() {
        return this.getDeploymentInfo().getBusinessRemoteHome();
    }

    public EJBObject getEjbObject(Object primaryKey) {
        return (EJBObject)EjbObjectProxyHandler.createProxy((BeanContext)this.getDeploymentInfo(), (Object)primaryKey, (InterfaceType)InterfaceType.EJB_HOME, (Class)this.getHomeInterface());
    }

    public Class getHomeInterface() {
        return this.getDeploymentInfo().getHomeInterface();
    }

    public Class getRemoteInterface() {
        return this.getDeploymentInfo().getRemoteInterface();
    }

    public Class getLocalHomeInterface() {
        return this.getDeploymentInfo().getLocalHomeInterface();
    }

    public Class getLocalInterface() {
        return this.getDeploymentInfo().getLocalInterface();
    }

    public Class getBeanClass() {
        return this.getDeploymentInfo().getBeanClass();
    }

    public Class getBusinessLocalInterface() {
        return this.getDeploymentInfo().getBusinessLocalInterface();
    }

    public Class getBusinessRemoteInterface() {
        return this.getDeploymentInfo().getBusinessRemoteInterface();
    }

    public Class getMdbInterface() {
        return this.getDeploymentInfo().getMdbInterface();
    }

    public Class getServiceEndpointInterface() {
        return this.getDeploymentInfo().getServiceEndpointInterface();
    }

    public BeanType getComponentType() {
        return this.getDeploymentInfo().getComponentType();
    }

    public Container getContainer() {
        return this.getDeploymentInfo().getContainer();
    }

    public boolean isBeanManagedTransaction() {
        return this.getDeploymentInfo().isBeanManagedTransaction();
    }

    public TransactionType getTransactionType(Method method) {
        return this.getDeploymentInfo().getTransactionType(method);
    }

    public TransactionType getTransactionType(Method method, InterfaceType interfaceType) {
        return this.getDeploymentInfo().getTransactionType(method, interfaceType);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    protected EjbDeployment initialize(BeanContext deploymentInfo) {
        try {
            ImmutableFederatedContext federatedContext = (ImmutableFederatedContext)((DeepBindableContext.ContextWrapper)deploymentInfo.getJndiEnc()).getRootContext();
            federatedContext.federateContext(this.componentContext);
            federatedContext.federateContext(this.moduleContext);
            federatedContext.federateContext(this.applicationContext);
            federatedContext.federateContext(this.globalContext);
            deploymentInfo.set(EjbDeployment.class, (Object)this);
            this.deploymentInfo.set(deploymentInfo);
            return this;
        }
        catch (NamingException e) {
            throw new IllegalStateException("Unable to complete EjbDeployment initialization", e);
        }
    }

    protected void destroy() {
        BeanContext info = this.deploymentInfo.getAndSet(null);
        if (info != null) {
            info.set(EjbDeployment.class, null);
        }
    }
}

