/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.cdi;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.openejb.cdi.GeronimoSingletonService;
import org.osgi.framework.Bundle;

@GBean
public class SingletonServiceInitializerGBean {
    public SingletonServiceInitializerGBean(@ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle) {
        GeronimoSingletonService.init(bundle);
        ProxyFactory.classLoaderProvider = new GeronimoClassLoaderProvider();
    }

    private static class GeronimoClassLoaderProvider
    implements ProxyFactory.ClassLoaderProvider {
        private final ConcurrentMap<Bundle, ClassLoader> proxyClassLoaders = new ConcurrentHashMap<Bundle, ClassLoader>();

        private GeronimoClassLoaderProvider() {
        }

        public ClassLoader get(ProxyFactory proxyFactory) {
            Collection<ClassLoader> baseCl = this.getBaseCl(proxyFactory);
            if (baseCl.size() == 1) {
                return baseCl.iterator().next();
            }
            MultiParentClassLoader proxyCl = new MultiParentClassLoader(baseCl);
            return proxyCl;
        }

        private Collection<ClassLoader> getBaseCl(ProxyFactory proxyFactory) {
            HashSet<Class> classes = new HashSet<Class>();
            classes.add(ProxyObject.class);
            Class superClass = proxyFactory.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                classes.add(superClass);
            }
            for (Class clazz : proxyFactory.getInterfaces()) {
                classes.add(clazz);
            }
            HashMap<Class, ClassLoader> classLoaderMap = new HashMap<Class, ClassLoader>(3);
            for (Class clazz : classes) {
                ClassLoader newCl = clazz.getClassLoader();
                if (newCl == null) continue;
                boolean loadable = false;
                for (Map.Entry entry : classLoaderMap.entrySet()) {
                    try {
                        ((ClassLoader)entry.getValue()).loadClass(clazz.getName());
                        loadable = true;
                        break;
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                if (loadable) continue;
                Iterator it = classLoaderMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry;
                    entry = it.next();
                    try {
                        newCl.loadClass(((Class)entry.getKey()).getName());
                        it.remove();
                    }
                    catch (ClassNotFoundException e) {}
                }
                classLoaderMap.put(clazz, newCl);
            }
            return classLoaderMap.values();
        }

        private static class MultiParentClassLoader
        extends ClassLoader {
            private final Collection<ClassLoader> classLoaders;

            public MultiParentClassLoader(Collection<ClassLoader> classLoaders) {
                this.classLoaders = classLoaders;
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                for (ClassLoader cl : this.classLoaders) {
                    try {
                        return cl.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                    }
                }
                return super.loadClass(name);
            }

            @Override
            public URL getResource(String name) {
                for (ClassLoader cl : this.classLoaders) {
                    URL url = cl.getResource(name);
                    if (url == null) continue;
                    return url;
                }
                return null;
            }
        }
    }
}

