/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.geronimo.j2ee.jndi.ApplicationJndi;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.EJB;
import org.apache.geronimo.management.EJBModule;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbModuleImpl
implements EJBModule {
    private static final Logger log = LoggerFactory.getLogger(EjbModuleImpl.class);
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ApplicationJndi applicationJndi;
    private final Context moduleContext;
    private final String deploymentDescriptor;
    private final String objectName;
    private final Collection<? extends EJB> ejbs;
    private final ClassLoader classLoader;
    private final OpenEjbSystem openEjbSystem;
    private final EjbJarInfo ejbJarInfo;

    public EjbModuleImpl(String objectName, J2EEServer server, J2EEApplication application, ApplicationJndi applicationJndi, Map<String, Object> moduleJndi, String deploymentDescriptor, Collection<? extends EJB> ejbs, ClassLoader classLoader, Kernel kernel, OpenEjbSystem openEjbSystem, EjbJarInfo ejbJarInfo) throws NamingException {
        this.objectName = objectName;
        ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.server = server;
        this.application = application;
        this.applicationJndi = applicationJndi;
        this.moduleContext = EnterpriseNamingContext.livenReferences(moduleJndi, null, (Kernel)kernel, (ClassLoader)classLoader, (String)"module/");
        this.deploymentDescriptor = deploymentDescriptor;
        this.ejbs = ejbs;
        this.classLoader = classLoader;
        this.openEjbSystem = openEjbSystem;
        this.ejbJarInfo = ejbJarInfo;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getEjbs() {
        ArrayList<? extends EJB> copy;
        if (this.ejbs == null) {
            return new String[0];
        }
        Collection<? extends EJB> collection = this.ejbs;
        synchronized (collection) {
            copy = new ArrayList<EJB>(this.ejbs);
        }
        String[] result = new String[copy.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = copy.get(i).getObjectName();
        }
        return result;
    }

    public ApplicationJndi getApplicationJndi() {
        return this.applicationJndi;
    }

    public Context getModuleContext() {
        return this.moduleContext;
    }

    protected void start() throws Exception {
        this.openEjbSystem.createEjbJar(this.ejbJarInfo, this.classLoader);
    }

    protected void stop() {
        try {
            this.openEjbSystem.removeEjbJar(this.ejbJarInfo, this.classLoader);
        }
        catch (NoSuchApplicationException e) {
            log.error("Module does not exist.", (Throwable)e);
        }
        catch (UndeployException e) {
            List causes = e.getCauses();
            log.error(e.getMessage() + ": Encountered " + causes.size() + " failures.");
            for (Throwable throwable : causes) {
                log.info(throwable.toString(), throwable);
            }
        }
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"EJBModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("EJBModule object name j2eeType property must be 'EJBModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("EJBModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("EJBModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("EJBModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("EJBModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }
}

