/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.openejb.EjbDeployment;
import org.apache.geronimo.openejb.EjbModuleImpl;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;

public class EjbDeploymentGBean
extends EjbDeployment
implements GBeanLifecycle {
    public static final GBeanInfo GBEAN_INFO;

    public EjbDeploymentGBean(String objectName, String deploymentId, String ejbName, String homeInterfaceName, String remoteInterfaceName, String localHomeInterfaceName, String localInterfaceName, String serviceEndpointInterfaceName, String beanClassName, ClassLoader classLoader, boolean securityEnabled, String defaultRole, String runAsRole, RunAsSource runAsSource, Map<String, Object> componentContext, Set<String> unshareableResources, Set<String> applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator, GeronimoTransactionManager transactionManager, OpenEjbSystem openEjbSystem, EjbModuleImpl ejbModule, Kernel kernel) throws Exception {
        super(objectName, deploymentId, ejbName, homeInterfaceName, remoteInterfaceName, localHomeInterfaceName, localInterfaceName, serviceEndpointInterfaceName, beanClassName, classLoader, securityEnabled, defaultRole, runAsRole, runAsSource, EjbDeploymentGBean.buildJndiContext(componentContext, ejbModule, transactionManager, kernel, classLoader), unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator, openEjbSystem);
    }

    private static Context buildJndiContext(Map<String, Object> componentContext, EjbModuleImpl ejbModule, GeronimoTransactionManager transactionManager, Kernel kernel, ClassLoader classLoader) throws NamingException {
        Context compContext = EnterpriseNamingContext.livenReferences(componentContext, (UserTransaction)transactionManager, (Kernel)kernel, (ClassLoader)classLoader, (String)"comp/");
        LinkedHashSet<Context> contexts = new LinkedHashSet<Context>(4);
        contexts.add(compContext);
        contexts.add(ejbModule.getModuleContext());
        contexts.add(ejbModule.getApplicationJndi().getApplicationContext());
        contexts.add((Context)ejbModule.getApplicationJndi().getGlobalContext());
        return EnterpriseNamingContext.createEnterpriseNamingContext(contexts);
    }

    public void doStart() throws Exception {
        this.start();
    }

    public void doStop() throws Exception {
        this.stop();
    }

    public void doFail() {
        this.stop();
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(EjbDeploymentGBean.class, EjbDeploymentGBean.class, (String)"StatelessSessionBean");
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("deploymentId", String.class, true);
        infoFactory.addAttribute("ejbName", String.class, true);
        infoFactory.addAttribute("homeInterfaceName", String.class, true);
        infoFactory.addAttribute("remoteInterfaceName", String.class, true);
        infoFactory.addAttribute("localHomeInterfaceName", String.class, true);
        infoFactory.addAttribute("localInterfaceName", String.class, true);
        infoFactory.addAttribute("serviceEndpointInterfaceName", String.class, true);
        infoFactory.addAttribute("beanClassName", String.class, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addAttribute("securityEnabled", Boolean.TYPE, true);
        infoFactory.addAttribute("defaultRole", String.class, true);
        infoFactory.addAttribute("runAsRole", String.class, true);
        infoFactory.addReference("RunAsSource", RunAsSource.class, "JACCManager");
        infoFactory.addAttribute("componentContextMap", Map.class, true);
        infoFactory.addAttribute("unshareableResources", Set.class, true);
        infoFactory.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoFactory.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class);
        infoFactory.addReference("TransactionManager", GeronimoTransactionManager.class);
        infoFactory.addReference("OpenEjbSystem", OpenEjbSystem.class);
        infoFactory.addReference("EjbModule", EjbModuleImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.setConstructor(new String[]{"objectName", "deploymentId", "ejbName", "homeInterfaceName", "remoteInterfaceName", "localHomeInterfaceName", "localInterfaceName", "serviceEndpointInterfaceName", "beanClassName", "classLoader", "securityEnabled", "defaultRole", "runAsRole", "RunAsSource", "componentContextMap", "unshareableResources", "applicationManagedSecurityResources", "TrackedConnectionAssociator", "TransactionManager", "OpenEjbSystem", "EjbModule", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

