/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.JndiFactory;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.WritableContext;

@GBean
public class DeepBindableContext
extends WritableContext {
    public DeepBindableContext(@ParamAttribute(name="nameInNamespace") String nameInNamespace, @ParamAttribute(name="cacheReferences") boolean cacheReferences, @ParamAttribute(name="supportReferenceable") boolean supportReferenceable, @ParamAttribute(name="checkDereferenceDifferent") boolean checkDereferenceDifferent, @ParamAttribute(name="assumeDereferenceBound") boolean assumeDereferenceBound) throws NamingException {
        super(nameInNamespace, Collections.emptyMap(), ContextAccess.MODIFIABLE, cacheReferences, supportReferenceable, checkDereferenceDifferent, assumeDereferenceBound);
    }

    void addDeepBinding(String name, Object value) throws NamingException {
        this.addDeepBinding(new CompositeName(name), value, false, true);
    }

    void removeDeepBinding(Name name) throws NamingException {
        this.removeDeepBinding(name, true, false);
    }

    public JndiFactory newJndiFactory() throws NamingException {
        return new XBeanJndiFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ContextWrapper
    implements Context {
        private final Context rootContext;
        private final String shortPrefix;
        private final String longPrefix;

        ContextWrapper(Context rootContext) throws NamingException {
            this.rootContext = rootContext;
            this.shortPrefix = DeepBindableContext.this.getNameInNamespace();
            this.longPrefix = "java:" + this.shortPrefix;
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.rootContext.lookup(name);
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.rootContext.lookup(name);
        }

        @Override
        public void bind(Name name, Object value) throws NamingException {
            this.bind(name.toString(), value);
        }

        @Override
        public void bind(String name, Object value) throws NamingException {
            if (name.startsWith(this.longPrefix + "/")) {
                name = name.substring(this.longPrefix.length() + 1);
            } else if (name.startsWith(this.shortPrefix + "/")) {
                name = name.substring(this.shortPrefix.length() + 1);
            }
            DeepBindableContext.this.addDeepBinding(name, value);
        }

        @Override
        public void rebind(Name name, Object o) throws NamingException {
            this.rootContext.rebind(name, o);
        }

        @Override
        public void rebind(String s, Object o) throws NamingException {
            this.rootContext.rebind(s, o);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            if (name.get(0).equals(this.shortPrefix) || name.get(0).equals(this.longPrefix)) {
                name = (Name)name.clone();
                name.remove(0);
            }
            DeepBindableContext.this.removeDeepBinding(name);
        }

        @Override
        public void unbind(String name) throws NamingException {
            this.unbind(this.getNameParser(name).parse(name));
        }

        @Override
        public void rename(Name name, Name name1) throws NamingException {
            this.rootContext.rename(name, name1);
        }

        @Override
        public void rename(String s, String s1) throws NamingException {
            this.rootContext.rename(s, s1);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return this.rootContext.list(name);
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
            return this.rootContext.list(s);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return this.rootContext.listBindings(name);
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
            return this.rootContext.listBindings(s);
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            this.rootContext.destroySubcontext(name);
        }

        @Override
        public void destroySubcontext(String s) throws NamingException {
            this.rootContext.destroySubcontext(s);
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return this.rootContext.createSubcontext(name);
        }

        @Override
        public Context createSubcontext(String s) throws NamingException {
            return this.rootContext.createSubcontext(s);
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return this.rootContext.lookupLink(name);
        }

        @Override
        public Object lookupLink(String s) throws NamingException {
            return this.rootContext.lookupLink(s);
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return this.rootContext.getNameParser(name);
        }

        @Override
        public NameParser getNameParser(String s) throws NamingException {
            return this.rootContext.getNameParser(s);
        }

        @Override
        public Name composeName(Name name, Name name1) throws NamingException {
            return this.rootContext.composeName(name, name1);
        }

        @Override
        public String composeName(String s, String s1) throws NamingException {
            return this.rootContext.composeName(s, s1);
        }

        @Override
        public Object addToEnvironment(String s, Object o) throws NamingException {
            return this.rootContext.addToEnvironment(s, o);
        }

        @Override
        public Object removeFromEnvironment(String s) throws NamingException {
            return this.rootContext.removeFromEnvironment(s);
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return this.rootContext.getEnvironment();
        }

        @Override
        public void close() throws NamingException {
            this.rootContext.close();
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return this.rootContext.getNameInNamespace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XBeanJndiFactory
    implements JndiFactory {
        private final Context rootContext;

        XBeanJndiFactory() throws NamingException {
            this.rootContext = new ContextWrapper((Context)new InitialContext().lookup(""));
        }

        public Context createComponentContext(Map<String, Object> bindings) throws SystemException {
            boolean hasEnv = false;
            for (String name : bindings.keySet()) {
                if (!name.startsWith("java:comp/env")) continue;
                hasEnv = true;
                break;
            }
            if (!hasEnv) {
                bindings.put("java:comp/env/dummy", "dummy");
            }
            WritableContext context = null;
            try {
                context = new WritableContext("", bindings);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
            return context;
        }

        public Context createRootContext() {
            return this.rootContext;
        }
    }
}

