/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.openejb.ServerIdentityToken;
import org.apache.geronimo.security.SubjectId;
import org.apache.openejb.client.ClientSecurity;
import org.apache.openejb.client.ServerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenejbRemoteLoginModule
implements LoginModule {
    private static Log log = LogFactory.getLog(OpenejbRemoteLoginModule.class);
    private static final String SECURITY_REALM_KEY = "RemoteSecurityRealm";
    private static final String SECURITY_REALM_KEY_LONG = OpenejbRemoteLoginModule.class.getName() + "." + "RemoteSecurityRealm";
    private static final String SERVER_URI_KEY = "ServerURI";
    private static final String SERVER_URI_KEY_LONG = OpenejbRemoteLoginModule.class.getName() + "." + "ServerURI";
    public static final List<String> supportedOptions = Collections.unmodifiableList(Arrays.asList("RemoteSecurityRealm", "ServerURI", SECURITY_REALM_KEY_LONG, SERVER_URI_KEY_LONG));
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String securityRealm;
    private URI serverURI;
    private SubjectId identity;
    private boolean loginSucceeded;
    private ServerIdentityToken sit;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String serverURIstring;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        for (String option : options.keySet()) {
            if (supportedOptions.contains(option)) continue;
            log.warn((Object)("Ignoring option: " + option + ". Not supported."));
        }
        this.securityRealm = (String)options.get(SECURITY_REALM_KEY);
        if (this.securityRealm == null) {
            this.securityRealm = (String)options.get(SECURITY_REALM_KEY_LONG);
        }
        if ((serverURIstring = (String)options.get(SERVER_URI_KEY)) == null) {
            serverURIstring = (String)options.get(SERVER_URI_KEY_LONG);
        }
        this.serverURI = URI.create(serverURIstring);
    }

    @Override
    public boolean login() throws LoginException {
        this.loginSucceeded = false;
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("passsword", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw (LoginException)new LoginException("Could not execute callbacks").initCause(e);
        }
        catch (UnsupportedCallbackException e) {
            throw (LoginException)new LoginException("Could not execute callbacks").initCause(e);
        }
        String userName = ((NameCallback)callbacks[0]).getName();
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        this.identity = (SubjectId)ClientSecurity.directAuthentication((String)this.securityRealm, (String)userName, (String)password, (ServerMetaData)new ServerMetaData(new URI[]{this.serverURI}));
        this.loginSucceeded = true;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.loginSucceeded && this.identity != null) {
            this.sit = new ServerIdentityToken(this.serverURI, this.identity);
            this.subject.getPrivateCredentials().add(this.sit);
        }
        this.identity = null;
        return this.loginSucceeded;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.loginSucceeded) {
            this.identity = null;
            this.sit = null;
        }
        return this.loginSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean logout() throws LoginException {
        block9: {
            this.loginSucceeded = false;
            this.identity = null;
            if (this.sit != null) {
                if (!this.subject.isReadOnly()) {
                    this.subject.getPrivateCredentials().remove(this.sit);
                } else {
                    try {
                        if (this.sit instanceof Destroyable) {
                            try {
                                ((Destroyable)((Object)this.sit)).destroy();
                                break block9;
                            }
                            catch (Exception e) {
                                throw new LoginException();
                            }
                        }
                        throw new LoginException();
                    }
                    finally {
                        this.sit = null;
                    }
                }
            }
        }
        this.sit = null;
        return true;
    }
}

