/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb;

import java.util.Properties;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.openejb.OpenEjbSystem;
import org.apache.openejb.assembler.classic.BmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.CmpEntityContainerInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.StatefulSessionContainerInfo;
import org.apache.openejb.assembler.classic.StatelessSessionContainerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbContainer
implements GBeanLifecycle {
    private OpenEjbSystem openEjbSystem;
    private String id;
    private Properties properties;
    private String provider;
    private String type;
    private Class<? extends ContainerInfo> infoType;
    public static final GBeanInfo GBEAN_INFO;

    public OpenEjbSystem getOpenEjbSystem() {
        return this.openEjbSystem;
    }

    public void setOpenEjbSystem(OpenEjbSystem openEjbSystem) {
        this.openEjbSystem = openEjbSystem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private Class<? extends ContainerInfo> getInfoType(String type) {
        if ("STATELESS".equalsIgnoreCase(type)) {
            return StatelessSessionContainerInfo.class;
        }
        if ("STATEFUL".equalsIgnoreCase(type)) {
            return StatefulSessionContainerInfo.class;
        }
        if ("BMP_ENTITY".equalsIgnoreCase(type)) {
            return BmpEntityContainerInfo.class;
        }
        if ("CMP_ENTITY".equalsIgnoreCase(type)) {
            return CmpEntityContainerInfo.class;
        }
        if ("CMP2_ENTITY".equalsIgnoreCase(type)) {
            return CmpEntityContainerInfo.class;
        }
        if ("MESSAGE".equalsIgnoreCase(type)) {
            return MdbContainerInfo.class;
        }
        return ContainerInfo.class;
    }

    public Class<? extends ContainerInfo> getInfoType() {
        return this.infoType == null ? this.getInfoType(this.type) : this.infoType;
    }

    public void setInfoType(Class<? extends ContainerInfo> infoType) {
        this.infoType = infoType;
    }

    public void doStart() throws Exception {
        this.openEjbSystem.createContainer(this.getInfoType(), this.id, this.properties, this.provider);
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EjbContainer.class);
        infoBuilder.addReference("OpenEjbSystem", OpenEjbSystem.class);
        infoBuilder.addAttribute("id", String.class, true);
        infoBuilder.addAttribute("properties", Properties.class, true);
        infoBuilder.addAttribute("provider", String.class, true);
        infoBuilder.addAttribute("type", String.class, true);
        infoBuilder.addAttribute("infoType", Class.class, true);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

