/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.ReferenceType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.EJBAnnotationHelper;
import org.apache.geronimo.j2ee.jndi.JndiKey;
import org.apache.geronimo.j2ee.jndi.JndiScope;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.openejb.ClientEjbReference;
import org.apache.geronimo.openejb.deployment.EjbModuleBuilder;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbLocalRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefDocument;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerPatternType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.config.JndiEncInfoBuilder;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.jee.EjbLocalRef;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetSpecification;
import org.apache.xmlbeans.XmlObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbRefBuilder
extends AbstractNamingBuilder {
    private static final Logger log = LoggerFactory.getLogger(EjbRefBuilder.class);
    private static final boolean EJB_CLIENT_SUPPORT;
    private final QNameSet ejbRefQNameSet;
    private final QNameSet ejbLocalRefQNameSet;
    private final URI uri;
    public static final GBeanInfo GBEAN_INFO;

    public EjbRefBuilder(Environment defaultEnvironment, String[] eeNamespaces, String host, int port) throws URISyntaxException {
        super(defaultEnvironment);
        this.uri = host != null ? new URI("ejbd", null, host, port, null, null, null) : null;
        this.ejbRefQNameSet = EjbRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"ejb-ref");
        this.ejbLocalRefQNameSet = EjbRefBuilder.buildQNameSet((String[])eeNamespaces, (String)"ejb-local-ref");
        this.ejbRefQNameSet.union((QNameSetSpecification)this.ejbLocalRefQNameSet);
    }

    public QNameSet getSpecQNameSet() {
        return this.ejbRefQNameSet;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    protected boolean willMergeEnvironment(JndiConsumer specDD, XmlObject plan) throws DeploymentException {
        return !specDD.getEjbRef().isEmpty() || !specDD.getEjbLocalRef().isEmpty();
    }

    public void buildNaming(JndiConsumer specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        if (!EJB_CLIENT_SUPPORT) {
            return;
        }
        Map<String, GerEjbRefType> refMap = this.mapEjbRefs(plan);
        Map<String, GerEjbLocalRefType> localRefMap = this.mapEjbLocalRefs(plan);
        if (module != null && module.getClassFinder() != null) {
            this.processAnnotations(specDD, module);
        }
        this.addRefs(specDD, refMap, localRefMap, sharedContext);
        HashMap<String, Set<InjectionTarget>> injectionsMap = new HashMap<String, Set<InjectionTarget>>();
        for (Map.Entry entry : specDD.getEjbRefMap().entrySet()) {
            injectionsMap.put((String)entry.getKey(), ((EjbRef)entry.getValue()).getInjectionTarget());
        }
        for (Map.Entry entry : specDD.getEjbLocalRefMap().entrySet()) {
            Set injectionTargets = (Set)injectionsMap.get(entry.getKey());
            if (injectionTargets != null) {
                injectionTargets.addAll(((EjbLocalRef)entry.getValue()).getInjectionTarget());
                continue;
            }
            injectionsMap.put((String)entry.getKey(), ((EjbLocalRef)entry.getValue()).getInjectionTarget());
        }
        Map map = null;
        HashSet<String> ejbLocalRefNames = new HashSet<String>();
        try {
            EjbModuleBuilder.EarData earData = (EjbModuleBuilder.EarData)EjbModuleBuilder.EarData.KEY.get(module.getRootEarContext().getGeneralData());
            AppInfo appInfo = earData != null ? earData.getAppInfo() : new AppInfo();
            JndiEncInfoBuilder jndiEncInfoBuilder = new JndiEncInfoBuilder(appInfo);
            JndiEncInfo moduleJndi = new JndiEncInfo();
            JndiEncInfo compJndi = new JndiEncInfo();
            String moduleId = module.getName();
            jndiEncInfoBuilder.build(specDD, "GeronimoEnc", moduleId, module.getModuleURI(), moduleJndi, compJndi);
            appInfo.globalJndiEnc.persistenceContextRefs.clear();
            appInfo.globalJndiEnc.persistenceUnitRefs.clear();
            appInfo.appJndiEnc.persistenceContextRefs.clear();
            appInfo.appJndiEnc.persistenceUnitRefs.clear();
            JndiEncInfo ejbEncInfo = new JndiEncInfo();
            ejbEncInfo.ejbReferences.addAll(appInfo.globalJndiEnc.ejbReferences);
            ejbEncInfo.ejbReferences.addAll(appInfo.appJndiEnc.ejbReferences);
            ejbEncInfo.ejbReferences.addAll(moduleJndi.ejbReferences);
            ejbEncInfo.ejbReferences.addAll(compJndi.ejbReferences);
            ejbEncInfo.ejbLocalReferences.addAll(appInfo.globalJndiEnc.ejbLocalReferences);
            ejbEncInfo.ejbLocalReferences.addAll(appInfo.appJndiEnc.ejbLocalReferences);
            ejbEncInfo.ejbLocalReferences.addAll(moduleJndi.ejbLocalReferences);
            ejbEncInfo.ejbLocalReferences.addAll(compJndi.ejbLocalReferences);
            JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(ejbEncInfo, null, moduleId, module.getModuleURI(), moduleId, ((Object)((Object)this)).getClass().getClassLoader());
            map = jndiEncBuilder.buildMap();
            for (EjbLocalReferenceInfo ejbLocalReferenceInfo : ejbEncInfo.ejbLocalReferences) {
                ejbLocalRefNames.add(ejbLocalReferenceInfo.referenceName);
            }
        }
        catch (OpenEJBException e) {
            throw new DeploymentException((Throwable)e);
        }
        Map moduleJndiContext = module.getJndiContext();
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (!name.startsWith("global/") && !name.startsWith("app/") && !name.startsWith("module/") && !name.startsWith("comp/")) continue;
            ReferenceType referenceType = ejbLocalRefNames.contains(name) ? ReferenceType.EJB_LOCAL : ReferenceType.EJB;
            String fullName = "java:" + name;
            Set injections = (Set)injectionsMap.get(fullName);
            if (injections == null) {
                injections = Collections.emptySet();
            }
            if (this.lookupJndiContextMap(module, fullName) != null) {
                this.addInjections(name, referenceType, injections, (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext));
                continue;
            }
            if (this.uri != null) {
                value = this.createClientRef(value);
                this.handleJndiUrlReference(value, referenceType, moduleJndiContext, injectionsMap, sharedContext);
            }
            if (!(value instanceof Serializable)) continue;
            if (injections.size() == 0 && log.isDebugEnabled()) {
                log.debug("No entry in deployment descriptor for name:\n " + fullName + "\n Known names:\n " + injectionsMap.keySet());
            }
            this.put(fullName, value, referenceType, module.getJndiContext(), injections, sharedContext);
        }
        if (this.uri != null) {
            HashMap appclientAppContext = new HashMap();
            Map sharedAppScopeContext = module.getJndiScope((JndiKey)JndiScope.app);
            for (Map.Entry entry : sharedAppScopeContext.entrySet()) {
                appclientAppContext.put(entry.getKey(), this.createClientRef(entry.getValue()));
            }
            module.getJndiContext().put(JndiScope.app, appclientAppContext);
        }
    }

    private void handleJndiUrlReference(Object value, ReferenceType ReferenceType2, Map<JndiKey, Map<String, Object>> moduleJndiContext, Map<String, Set<InjectionTarget>> injectionsMap, Map<EARContext.Key, Object> sharedContext) {
        if (!(value instanceof JndiUrlReference)) {
            return;
        }
        String name = ((JndiUrlReference)value).getJndiName();
        if (name.startsWith("java:")) {
            name = name.charAt(5) == '/' ? name.substring("java:/".length()) : name.substring("java:".length());
        }
        Object valueToConvert = null;
        if (!moduleJndiContext.get(JndiScope.app).containsKey(name)) {
            return;
        }
        valueToConvert = moduleJndiContext.get(JndiScope.app).get(name);
        valueToConvert = this.createClientRef(valueToConvert);
        name = "java:" + name;
        Set<Object> injections = injectionsMap.get(name);
        if (injections == null) {
            injections = Collections.emptySet();
        }
        this.put(name, valueToConvert, ReferenceType2, moduleJndiContext, injections, sharedContext);
    }

    private Object createClientRef(Object value) {
        if (value instanceof IntraVmJndiReference) {
            IntraVmJndiReference intraVmJndiReference = (IntraVmJndiReference)value;
            String deploymentId = intraVmJndiReference.getJndiName();
            if (deploymentId.startsWith("java:openejb/local/")) {
                deploymentId = deploymentId.substring("java:openejb/local/".length());
            }
            if (deploymentId.startsWith("java:openejb/remote/")) {
                deploymentId = deploymentId.substring("java:openejb/remote/".length());
            }
            if (deploymentId.startsWith("java:openejb/Deployment/")) {
                deploymentId = deploymentId.substring("java:openejb/Deployment/".length());
            }
            ClientEjbReference clientRef = new ClientEjbReference(this.uri.toString(), deploymentId);
            return clientRef;
        }
        return value;
    }

    private void addRefs(JndiConsumer jndiConsumer, Map<String, GerEjbRefType> refMap, Map<String, GerEjbLocalRefType> localRefMap, Map<EARContext.Key, Object> sharedContext) {
        String deploymentId;
        String ejbName;
        String module;
        GerPatternType pattern;
        String refName;
        for (EjbRef spec_ejbRef : jndiConsumer.getEjbRef()) {
            refName = spec_ejbRef.getEjbRefName();
            GerEjbRefType ejbRefType = refMap.get(refName);
            if (ejbRefType == null || ejbRefType.getNsCorbaloc() != null) continue;
            if (ejbRefType.getPattern() != null) {
                pattern = ejbRefType.getPattern();
                module = pattern.getModule();
                if (module == null) {
                    module = pattern.getArtifactId();
                }
                ejbName = pattern.getName();
                deploymentId = module.trim() + "/" + ejbName;
                spec_ejbRef.setMappedName(deploymentId.trim());
            }
            if (ejbRefType.getEjbLink() == null) continue;
            spec_ejbRef.setEjbLink(EjbRefBuilder.getStringValue((String)ejbRefType.getEjbLink()));
        }
        for (EjbLocalRef localRefFromSpecDD : jndiConsumer.getEjbLocalRef()) {
            refName = localRefFromSpecDD.getEjbRefName();
            GerEjbLocalRefType ejbLocalRefType = localRefMap.get(refName);
            if (ejbLocalRefType == null) continue;
            if (ejbLocalRefType.getPattern() != null) {
                pattern = ejbLocalRefType.getPattern();
                module = pattern.getModule();
                if (module == null) {
                    module = pattern.getArtifactId();
                }
                ejbName = pattern.getName();
                deploymentId = module.trim() + "/" + ejbName;
                localRefFromSpecDD.setMappedName(deploymentId.trim());
            }
            if (ejbLocalRefType.getEjbLink() == null) continue;
            localRefFromSpecDD.setEjbLink(EjbRefBuilder.getStringValue((String)ejbLocalRefType.getEjbLink()));
        }
    }

    private Map<String, GerEjbRefType> mapEjbRefs(XmlObject plan) {
        HashMap<String, GerEjbRefType> refMap = new HashMap<String, GerEjbRefType>();
        if (plan == null) {
            return refMap;
        }
        QNameSet qnameSet = QNameSet.singleton((QName)GerEjbRefDocument.type.getDocumentElementName());
        XmlObject[] xmlObjects = plan.selectChildren(qnameSet);
        if (xmlObjects != null) {
            for (XmlObject xmlObject : xmlObjects) {
                GerEjbRefType ref = (GerEjbRefType)xmlObject.copy().changeType(GerEjbRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    private Map<String, GerEjbLocalRefType> mapEjbLocalRefs(XmlObject plan) {
        HashMap<String, GerEjbLocalRefType> refMap = new HashMap<String, GerEjbLocalRefType>();
        if (plan == null) {
            return refMap;
        }
        QNameSet qnameSet = QNameSet.singleton((QName)GerEjbLocalRefDocument.type.getDocumentElementName());
        XmlObject[] xmlObjects = plan.selectChildren(qnameSet);
        if (xmlObjects != null) {
            for (XmlObject xmlObject : xmlObjects) {
                GerEjbLocalRefType ref = (GerEjbLocalRefType)xmlObject.copy().changeType(GerEjbLocalRefType.type);
                refMap.put(ref.getRefName().trim(), ref);
            }
        }
        return refMap;
    }

    public static <E> List<E> asList(E[] array) {
        if (array == null) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array));
    }

    private void processAnnotations(JndiConsumer ejb, Module module) {
        if (EJBAnnotationHelper.annotationsPresent((AbstractFinder)module.getClassFinder())) {
            try {
                EJBAnnotationHelper.processAnnotations((JndiConsumer)ejb, (AbstractFinder)module.getClassFinder());
            }
            catch (Exception e) {
                log.warn("Unable to process @EJB annotations for module" + module.getName(), (Throwable)e);
            }
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        String ejbClientSupported = System.getProperty("org.apache.geronimo.ejb.client.support");
        if (ejbClientSupported == null) {
            ejbClientSupported = System.getProperty("org.apache.geronimo.ejb.support");
        }
        EJB_CLIENT_SUPPORT = ejbClientSupported == null ? true : Boolean.valueOf(ejbClientSupported);
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(EjbRefBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("eeNamespaces", String[].class, true, true);
        infoBuilder.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoBuilder.addAttribute("host", String.class, true);
        infoBuilder.addAttribute("port", Integer.TYPE, true);
        infoBuilder.setConstructor(new String[]{"defaultEnvironment", "eeNamespaces", "host", "port"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

