/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.SessionBean;

public class SecurityBuilder {
    public void addComponentPermissions(String defaultRole, Collection<Permission> notAssigned, AssemblyDescriptor assemblyDescriptor, String ejbName, List<SecurityRoleRef> securityRoleRefs, ComponentPermissions componentPermissions) throws DeploymentException {
        PermissionCollection permissions;
        PermissionCollection uncheckedPermissions = componentPermissions.getUncheckedPermissions();
        PermissionCollection excludedPermissions = componentPermissions.getExcludedPermissions();
        Map rolePermissions = componentPermissions.getRolePermissions();
        HashSet<Permission> allExcludedPermissions = new HashSet<Permission>();
        if (assemblyDescriptor != null) {
            ExcludeList excludeList = assemblyDescriptor.getExcludeList();
            if (excludeList != null) {
                for (Method method : excludeList.getMethod()) {
                    String[] methodParams;
                    String methodIntf;
                    if (!ejbName.equals(method.getEjbName())) continue;
                    String methodName = method.getMethodName();
                    String string = methodIntf = method.getMethodIntf() == null ? null : method.getMethodIntf().toString();
                    if (method.getMethodParams() != null) {
                        List paramList = method.getMethodParams().getMethodParam();
                        methodParams = paramList.toArray(new String[paramList.size()]);
                    } else {
                        methodParams = null;
                    }
                    EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodIntf, methodParams);
                    excludedPermissions.add((Permission)permission);
                    allExcludedPermissions.addAll(this.intersectPermissions(notAssigned, (Permission)permission, false));
                }
            }
            for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermission()) {
                List roleNames = methodPermission.getRoleName();
                boolean unchecked = methodPermission.getUnchecked();
                for (Method method : methodPermission.getMethod()) {
                    String[] methodParams;
                    String methodIntf;
                    if (!ejbName.equals(method.getEjbName())) continue;
                    String methodName = method.getMethodName();
                    if ("*".equals(methodName)) {
                        methodName = null;
                    }
                    String string = methodIntf = method.getMethodIntf() == null ? null : method.getMethodIntf().toString();
                    if (method.getMethodParams() != null) {
                        List paramList = method.getMethodParams().getMethodParam();
                        methodParams = paramList.toArray(new String[paramList.size()]);
                    } else {
                        methodParams = null;
                    }
                    EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodIntf, methodParams);
                    Collection<Permission> culled = this.intersectPermissions(notAssigned, (Permission)permission, true);
                    int size = culled.size();
                    culled.removeAll(allExcludedPermissions);
                    if (size == culled.size()) {
                        culled = Collections.singletonList(permission);
                    }
                    if (unchecked) {
                        for (Permission p : culled) {
                            uncheckedPermissions.add(p);
                        }
                        continue;
                    }
                    if (culled.size() <= 0) continue;
                    for (String roleName : roleNames) {
                        Permissions permissions2 = (Permissions)rolePermissions.get(roleName);
                        if (permissions2 == null) {
                            permissions2 = new Permissions();
                            rolePermissions.put(roleName, permissions2);
                        }
                        for (Permission p : culled) {
                            permissions2.add(p);
                        }
                    }
                }
            }
            for (SecurityRoleRef securityRoleRef : securityRoleRefs) {
                String roleLink = securityRoleRef.getRoleLink() == null ? securityRoleRef.getRoleName() : securityRoleRef.getRoleLink();
                PermissionCollection roleLinks = (PermissionCollection)rolePermissions.get(roleLink);
                if (roleLinks == null) {
                    roleLinks = new Permissions();
                    rolePermissions.put(roleLink, roleLinks);
                }
                roleLinks.add((Permission)new EJBRoleRefPermission(ejbName, securityRoleRef.getRoleName()));
            }
        }
        if (defaultRole == null) {
            permissions = uncheckedPermissions;
        } else {
            permissions = (PermissionCollection)rolePermissions.get(defaultRole);
            if (permissions == null) {
                permissions = new Permissions();
                rolePermissions.put(defaultRole, permissions);
            }
        }
        notAssigned.removeAll(allExcludedPermissions);
        for (Permission p : notAssigned) {
            permissions.add(p);
        }
    }

    public void addToPermissions(Collection<Permission> permissions, String ejbName, String methodInterface, String interfaceClass, ClassLoader classLoader) throws DeploymentException {
        if (interfaceClass == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(interfaceClass, false, classLoader);
            for (java.lang.reflect.Method method : clazz.getMethods()) {
                permissions.add((Permission)new EJBMethodPermission(ejbName, methodInterface, method));
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private Collection<Permission> intersectPermissions(Collection<Permission> toBeChecked, Permission permission, boolean remove) {
        ArrayList<Permission> result = new ArrayList<Permission>();
        Iterator<Permission> it = toBeChecked.iterator();
        while (it.hasNext()) {
            Permission test = it.next();
            if (!permission.implies(test)) continue;
            if (remove) {
                it.remove();
            }
            result.add(test);
        }
        return result;
    }

    public void addEjbTimeout(EnterpriseBean remoteBean, EjbModule ejbModule, Collection<Permission> permissions) throws DeploymentException {
        NamedMethod timeout = null;
        if (remoteBean instanceof SessionBean) {
            timeout = ((SessionBean)remoteBean).getTimeoutMethod();
        } else if (remoteBean instanceof MessageDrivenBean) {
            timeout = ((MessageDrivenBean)remoteBean).getTimeoutMethod();
        }
        if (timeout != null) {
            permissions.add((Permission)new EJBMethodPermission(remoteBean.getEjbName(), timeout.getMethodName(), null, new String[]{Timer.class.getName()}));
        } else {
            try {
                Class<?> ejbClass = ejbModule.getClassLoader().loadClass(remoteBean.getEjbClass());
                if (TimedObject.class.isAssignableFrom(ejbClass)) {
                    permissions.add((Permission)new EJBMethodPermission(remoteBean.getEjbName(), "ejbTimeout", null, new String[]{Timer.class.getName()}));
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not figure out timer method", (Throwable)e);
            }
        }
    }
}

