/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.openejb.deployment;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.openejb.deployment.EjbModule;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ExcludeList;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.Method;
import org.apache.openejb.jee.MethodPermission;
import org.apache.openejb.jee.NamedMethod;
import org.apache.openejb.jee.RemoteBean;
import org.apache.openejb.jee.SecurityRoleRef;
import org.apache.openejb.jee.SessionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityBuilder {
    public void addComponentPermissions(String defaultRole, PermissionCollection notAssigned, AssemblyDescriptor assemblyDescriptor, String ejbName, List<SecurityRoleRef> securityRoleRefs, ComponentPermissions componentPermissions) throws DeploymentException {
        PermissionCollection permissions;
        PermissionCollection uncheckedPermissions = componentPermissions.getUncheckedPermissions();
        PermissionCollection excludedPermissions = componentPermissions.getExcludedPermissions();
        Map rolePermissions = componentPermissions.getRolePermissions();
        if (assemblyDescriptor != null) {
            for (MethodPermission methodPermission : assemblyDescriptor.getMethodPermission()) {
                List roleNames = methodPermission.getRoleName();
                boolean unchecked = methodPermission.getUnchecked();
                for (Method method : methodPermission.getMethod()) {
                    String[] methodParams;
                    String methodIntf;
                    if (!ejbName.equals(method.getEjbName())) continue;
                    String methodName = method.getMethodName();
                    if ("*".equals(methodName)) {
                        methodName = null;
                    }
                    String string = methodIntf = method.getMethodIntf() == null ? null : method.getMethodIntf().toString();
                    if (method.getMethodParams() != null) {
                        List paramList = method.getMethodParams().getMethodParam();
                        methodParams = paramList.toArray(new String[paramList.size()]);
                    } else {
                        methodParams = null;
                    }
                    EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodIntf, methodParams);
                    notAssigned = this.cullPermissions(notAssigned, (Permission)permission);
                    if (unchecked) {
                        uncheckedPermissions.add((Permission)permission);
                        continue;
                    }
                    for (String roleName : roleNames) {
                        Permissions permissions2 = (Permissions)rolePermissions.get(roleName);
                        if (permissions2 == null) {
                            permissions2 = new Permissions();
                            rolePermissions.put(roleName, permissions2);
                        }
                        permissions2.add((Permission)permission);
                    }
                }
            }
            ExcludeList excludeList = assemblyDescriptor.getExcludeList();
            if (excludeList != null) {
                for (Method method : excludeList.getMethod()) {
                    String[] methodParams;
                    String methodIntf;
                    if (!ejbName.equals(method.getEjbName())) continue;
                    String methodName = method.getMethodName();
                    String string = methodIntf = method.getMethodIntf() == null ? null : method.getMethodIntf().toString();
                    if (method.getMethodParams() != null) {
                        List paramList = method.getMethodParams().getMethodParam();
                        methodParams = paramList.toArray(new String[paramList.size()]);
                    } else {
                        methodParams = null;
                    }
                    EJBMethodPermission permission = new EJBMethodPermission(ejbName, methodName, methodIntf, methodParams);
                    excludedPermissions.add((Permission)permission);
                    notAssigned = this.cullPermissions(notAssigned, (Permission)permission);
                }
            }
            for (SecurityRoleRef securityRoleRef : securityRoleRefs) {
                String roleLink = securityRoleRef.getRoleLink() == null ? securityRoleRef.getRoleName() : securityRoleRef.getRoleLink();
                PermissionCollection roleLinks = (PermissionCollection)rolePermissions.get(roleLink);
                if (roleLinks == null) {
                    roleLinks = new Permissions();
                    rolePermissions.put(roleLink, roleLinks);
                }
                roleLinks.add((Permission)new EJBRoleRefPermission(ejbName, securityRoleRef.getRoleName()));
            }
        }
        if (defaultRole == null) {
            permissions = uncheckedPermissions;
        } else {
            permissions = (PermissionCollection)rolePermissions.get(defaultRole);
            if (permissions == null) {
                permissions = new Permissions();
                rolePermissions.put(defaultRole, permissions);
            }
        }
        Enumeration<Permission> e = notAssigned.elements();
        while (e.hasMoreElements()) {
            Permission p = e.nextElement();
            permissions.add(p);
        }
    }

    public void addToPermissions(PermissionCollection permissions, String ejbName, String methodInterface, String interfaceClass, ClassLoader classLoader) throws DeploymentException {
        if (interfaceClass == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(interfaceClass, false, classLoader);
            for (java.lang.reflect.Method method : clazz.getMethods()) {
                permissions.add((Permission)new EJBMethodPermission(ejbName, methodInterface, method));
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private Permissions cullPermissions(PermissionCollection toBeChecked, Permission permission) {
        Permissions result = new Permissions();
        Enumeration<Permission> e = toBeChecked.elements();
        while (e.hasMoreElements()) {
            Permission test = e.nextElement();
            if (permission.implies(test)) continue;
            result.add(test);
        }
        return result;
    }

    public void addEjbTimeout(RemoteBean remoteBean, EjbModule ejbModule, PermissionCollection permissions) throws DeploymentException {
        NamedMethod timeout = null;
        if (remoteBean instanceof SessionBean) {
            timeout = ((SessionBean)remoteBean).getTimeoutMethod();
        } else if (remoteBean instanceof MessageDrivenBean) {
            timeout = ((MessageDrivenBean)remoteBean).getTimeoutMethod();
        }
        if (timeout != null) {
            permissions.add((Permission)new EJBMethodPermission(remoteBean.getEjbName(), timeout.getMethodName(), null, new String[]{Timer.class.getName()}));
        } else {
            try {
                Class<?> ejbClass = ejbModule.getClassLoader().loadClass(remoteBean.getEjbClass());
                if (TimedObject.class.isAssignableFrom(ejbClass)) {
                    permissions.add((Permission)new EJBMethodPermission(remoteBean.getEjbName(), "ejbTimeout", null, new String[]{Timer.class.getName()}));
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not figure out timer method", (Throwable)e);
            }
        }
    }
}

