/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.reference;

import java.util.Map;
import javax.naming.NameNotFoundException;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.naming.reference.ConfigurationAwareReference;

public class PersistenceContextReference
extends ConfigurationAwareReference {
    private boolean transactionScoped;
    private Map properties;

    public PersistenceContextReference(Artifact configId, AbstractNameQuery abstractNameQuery, boolean transactionScoped, Map properties) {
        super(configId, abstractNameQuery);
        this.transactionScoped = transactionScoped;
        this.properties = properties;
    }

    public String getClassName() {
        return "javax.persistence.EntityManager";
    }

    public Object getContent() throws NameNotFoundException {
        Object entityManager;
        AbstractName target;
        Kernel kernel = this.getKernel();
        try {
            target = this.resolveTargetName();
        }
        catch (GBeanNotFoundException e) {
            throw (NameNotFoundException)new NameNotFoundException("Could not resolve name query: " + this.abstractNameQueries).initCause(e);
        }
        try {
            entityManager = kernel.invoke(target, "getEntityManager", new Object[]{this.transactionScoped, this.properties}, new String[]{Boolean.TYPE.getName(), Map.class.getName()});
        }
        catch (Exception e) {
            throw (IllegalStateException)new IllegalStateException("Could not get entityManager").initCause(e);
        }
        if (entityManager == null) {
            throw new IllegalStateException("entity manager not returned. Target " + target + " not started");
        }
        return entityManager;
    }
}

