/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.LifecycleMethod;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.Lifecycle;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

@GBean(j2eeType="ModuleBuilder")
public class LifecycleMethodBuilder
extends AbstractNamingBuilder {
    public void buildNaming(JndiConsumer specDD, XmlObject plan, Module module, Map<EARContext.Key, Object> sharedContext) throws DeploymentException {
        Object preDestroys;
        Object postConstructs;
        if (!(specDD instanceof Lifecycle)) {
            return;
        }
        Lifecycle lifecycle = (Lifecycle)specDD;
        AbstractFinder classFinder = module.getClassFinder();
        String componentType = null;
        if (specDD instanceof EnterpriseBean) {
            componentType = ((EnterpriseBean)specDD).getEjbClass();
        } else if (specDD instanceof Interceptor) {
            componentType = ((Interceptor)specDD).getInterceptorClass();
        } else if (specDD instanceof ApplicationClient) {
            componentType = ((ApplicationClient)specDD).getMainClass();
        }
        Map<String, LifecycleCallback> postConstructMap = this.mapLifecycleCallbacks(lifecycle.getPostConstruct(), componentType);
        Map<String, LifecycleCallback> preDestroyMap = this.mapLifecycleCallbacks(lifecycle.getPreDestroy(), componentType);
        if (module.getClassFinder() != null) {
            postConstructs = classFinder.findAnnotatedMethods(PostConstruct.class);
            Iterator i$ = postConstructs.iterator();
            while (i$.hasNext()) {
                Method m = (Method)i$.next();
                String methodName = m.getName();
                String className = m.getDeclaringClass().getName();
                if (postConstructMap.containsKey(className)) continue;
                LifecycleCallback callback = new LifecycleCallback();
                callback.setLifecycleCallbackClass(className);
                callback.setLifecycleCallbackMethod(methodName);
                lifecycle.getPostConstruct().add(callback);
                postConstructMap.put(className, callback);
            }
            preDestroys = classFinder.findAnnotatedMethods(PreDestroy.class);
            Iterator i$2 = preDestroys.iterator();
            while (i$2.hasNext()) {
                Method m = (Method)i$2.next();
                String methodName = m.getName();
                String className = m.getDeclaringClass().getName();
                if (preDestroyMap.containsKey(className)) continue;
                LifecycleCallback callback = new LifecycleCallback();
                callback.setLifecycleCallbackClass(className);
                callback.setLifecycleCallbackMethod(methodName);
                preDestroyMap.put(className, callback);
                lifecycle.getPreDestroy().add(callback);
            }
        }
        postConstructs = this.map(postConstructMap);
        preDestroys = this.map(preDestroyMap);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(sharedContext);
        holder.addPostConstructs((Map)postConstructs);
        holder.addPreDestroys((Map)preDestroys);
    }

    private Map<String, LifecycleMethod> map(Map<String, LifecycleCallback> LifecycleCallbacks) {
        if (LifecycleCallbacks.isEmpty()) {
            return null;
        }
        HashMap<String, LifecycleMethod> map = new HashMap<String, LifecycleMethod>();
        for (Map.Entry<String, LifecycleCallback> entry : LifecycleCallbacks.entrySet()) {
            String className = entry.getKey();
            LifecycleCallback callback = entry.getValue();
            LifecycleMethod method = new LifecycleMethod(className, callback.getLifecycleCallbackMethod().trim());
            map.put(className, method);
        }
        return map;
    }

    private Map<String, LifecycleCallback> mapLifecycleCallbacks(Collection<LifecycleCallback> callbackArray, String componentType) throws DeploymentException {
        HashMap<String, LifecycleCallback> map = new HashMap<String, LifecycleCallback>();
        for (LifecycleCallback callback : callbackArray) {
            String className;
            if (callback.getLifecycleCallbackClass() != null) {
                className = callback.getLifecycleCallbackClass().trim();
            } else {
                if (componentType == null) {
                    throw new DeploymentException("No component type available and none in  lifecycle callback");
                }
                className = componentType;
            }
            map.put(className, callback);
        }
        return map;
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }
}

