/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.naming.deployment;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.annotation.LifecycleMethod;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.annotation.AnnotatedApp;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.naming.deployment.AbstractNamingBuilder;
import org.apache.geronimo.xbeans.javaee.FullyQualifiedClassType;
import org.apache.geronimo.xbeans.javaee.JavaIdentifierType;
import org.apache.geronimo.xbeans.javaee.LifecycleCallbackType;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleMethodBuilder
extends AbstractNamingBuilder {
    public static final GBeanInfo GBEAN_INFO;

    public void buildNaming(XmlObject specDD, XmlObject plan, Module module, Map componentContext) throws DeploymentException {
        Object preDestroys;
        Object postConstructs;
        if (module.getType() == ConfigurationModuleType.EJB) {
            return;
        }
        ClassFinder classFinder = module.getClassFinder();
        AnnotatedApp annotatedApp = module.getAnnotatedApp();
        if (annotatedApp == null) {
            throw new NullPointerException("No AnnotatedApp supplied");
        }
        Map<String, LifecycleCallbackType> postConstructMap = this.mapLifecycleCallbacks(annotatedApp.getPostConstructArray(), annotatedApp.getComponentType());
        Map<String, LifecycleCallbackType> preDestroyMap = this.mapLifecycleCallbacks(annotatedApp.getPreDestroyArray(), annotatedApp.getComponentType());
        if (module.getClassFinder() != null) {
            postConstructs = classFinder.findAnnotatedMethods(PostConstruct.class);
            Iterator i$ = postConstructs.iterator();
            while (i$.hasNext()) {
                Method m = (Method)i$.next();
                String methodName = m.getName();
                String className = m.getDeclaringClass().getName();
                if (postConstructMap.containsKey(className)) continue;
                LifecycleCallbackType callback = annotatedApp.addPostConstruct();
                FullyQualifiedClassType classType = callback.addNewLifecycleCallbackClass();
                classType.setStringValue(className);
                JavaIdentifierType method = callback.addNewLifecycleCallbackMethod();
                method.setStringValue(methodName);
                postConstructMap.put(className, callback);
            }
            preDestroys = classFinder.findAnnotatedMethods(PreDestroy.class);
            Iterator i$2 = preDestroys.iterator();
            while (i$2.hasNext()) {
                Method m = (Method)i$2.next();
                String methodName = m.getName();
                String className = m.getDeclaringClass().getName();
                if (preDestroyMap.containsKey(className)) continue;
                LifecycleCallbackType callback = annotatedApp.addPreDestroy();
                FullyQualifiedClassType classType = callback.addNewLifecycleCallbackClass();
                classType.setStringValue(className);
                JavaIdentifierType method = callback.addNewLifecycleCallbackMethod();
                method.setStringValue(methodName);
                preDestroyMap.put(className, callback);
            }
        }
        postConstructs = this.map(postConstructMap);
        preDestroys = this.map(preDestroyMap);
        Holder holder = (Holder)NamingBuilder.INJECTION_KEY.get(componentContext);
        holder.addPostConstructs((Map)postConstructs);
        holder.addPreDestroys((Map)preDestroys);
    }

    private Map<String, LifecycleMethod> map(Map<String, LifecycleCallbackType> lifecycleCallbackTypes) {
        if (lifecycleCallbackTypes.isEmpty()) {
            return null;
        }
        HashMap<String, LifecycleMethod> map = new HashMap<String, LifecycleMethod>();
        for (Map.Entry<String, LifecycleCallbackType> entry : lifecycleCallbackTypes.entrySet()) {
            String className = entry.getKey();
            LifecycleCallbackType callback = entry.getValue();
            LifecycleMethod method = new LifecycleMethod(className, callback.getLifecycleCallbackMethod().getStringValue().trim());
            map.put(className, method);
        }
        return map;
    }

    private Map<String, LifecycleCallbackType> mapLifecycleCallbacks(LifecycleCallbackType[] callbackArray, String componentType) throws DeploymentException {
        HashMap<String, LifecycleCallbackType> map = new HashMap<String, LifecycleCallbackType>();
        for (LifecycleCallbackType callback : callbackArray) {
            String className;
            if (callback.isSetLifecycleCallbackClass()) {
                className = callback.getLifecycleCallbackClass().getStringValue().trim();
            } else {
                if (componentType == null) {
                    throw new DeploymentException("No component type available and none in  lifecycle callback");
                }
                className = componentType;
            }
            map.put(className, callback);
        }
        return map;
    }

    public QNameSet getSpecQNameSet() {
        return QNameSet.EMPTY;
    }

    public QNameSet getPlanQNameSet() {
        return QNameSet.EMPTY;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(LifecycleMethodBuilder.class, (String)"ModuleBuilder");
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

