/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.config.resource.osgi;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.kernel.util.IOUtils;
import org.apache.geronimo.myfaces.FacesConfigDigester;
import org.apache.geronimo.myfaces.config.resource.osgi.Activator;
import org.apache.geronimo.myfaces.config.resource.osgi.api.ConfigRegistry;
import org.apache.geronimo.system.configuration.DependencyManager;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfigRegistryImpl
implements ConfigRegistry {
    private final Activator activator;
    private Map<Long, List<FacesConfig>> bundleIdFacesConfigsMap = new ConcurrentHashMap<Long, List<FacesConfig>>();
    private Map<Long, List<URL>> bundleIdFacesConfigURLsMap = new ConcurrentHashMap<Long, List<URL>>();
    private Map<Long, List<URL>> bundleIdFaceletsConfigResourcesMap = new ConcurrentHashMap<Long, List<URL>>();
    private FacesConfigDigester facesConfigDigester = new FacesConfigDigester();

    public ConfigRegistryImpl(Activator activator) {
        this.activator = activator;
    }

    public boolean addBundle(Bundle bundle) {
        boolean facesConfigsFound = this.findFacesConfigs(bundle);
        boolean faceletsConfigResourcesFound = this.findFaceletsConfigResources(bundle);
        return facesConfigsFound || faceletsConfigResourcesFound;
    }

    protected boolean findFaceletsConfigResources(Bundle bundle) {
        Enumeration metaInfEn = bundle.findEntries("META-INF/", "*.taglib.xml", false);
        if (metaInfEn == null) {
            return false;
        }
        ArrayList faceletsConfigResources = new ArrayList();
        while (metaInfEn.hasMoreElements()) {
            faceletsConfigResources.add(metaInfEn.nextElement());
        }
        this.bundleIdFaceletsConfigResourcesMap.put(bundle.getBundleId(), faceletsConfigResources);
        return true;
    }

    protected boolean findFacesConfigs(Bundle bundle) {
        Enumeration metaInfEn;
        this.log(4, "examining bundle for META-INF/faces-config.xml " + bundle.getSymbolicName());
        boolean facesConfigsFound = false;
        URL url = bundle.getEntry("META-INF/faces-config.xml");
        ArrayList<FacesConfig> facesConfigs = null;
        ArrayList<URL> facesConfigURLs = null;
        if (url != null) {
            facesConfigs = new ArrayList<FacesConfig>();
            facesConfigURLs = new ArrayList<URL>();
            facesConfigs.add(this.parseFacesConfig(bundle, url));
            facesConfigURLs.add(url);
        }
        if ((metaInfEn = bundle.findEntries("META-INF/", "*.faces-config.xml", false)) != null) {
            if (facesConfigs == null) {
                facesConfigs = new ArrayList();
            }
            if (facesConfigURLs == null) {
                facesConfigURLs = new ArrayList();
            }
            while (metaInfEn.hasMoreElements()) {
                URL currURL = (URL)metaInfEn.nextElement();
                facesConfigURLs.add(currURL);
                facesConfigs.add(this.parseFacesConfig(bundle, currURL));
            }
        }
        if (facesConfigs != null) {
            this.bundleIdFacesConfigsMap.put(bundle.getBundleId(), facesConfigs);
            facesConfigsFound = true;
        }
        if (facesConfigURLs != null) {
            this.bundleIdFacesConfigURLsMap.put(bundle.getBundleId(), facesConfigURLs);
            facesConfigsFound = true;
        }
        return facesConfigsFound;
    }

    public void removeBundle(Bundle bundle, Object object) {
        Long removeBundleId = bundle.getBundleId();
        this.bundleIdFacesConfigsMap.remove(removeBundleId);
        this.bundleIdFacesConfigURLsMap.remove(removeBundleId);
        this.bundleIdFaceletsConfigResourcesMap.remove(removeBundleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Bundle> getDependentBundles(Long bundleId) {
        Bundle bundle;
        String contextPath;
        BundleContext bundleContext = this.activator.getBundleContext();
        HashSet<Bundle> dependentBundles = new HashSet<Bundle>();
        ServiceReference serviceReference = bundleContext.getServiceReference(DependencyManager.class.getName());
        if (serviceReference != null) {
            DependencyManager dependencyManager = (DependencyManager)bundleContext.getService(serviceReference);
            try {
                dependentBundles.addAll(dependencyManager.getFullDependentBundles(bundleId));
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        if ((contextPath = (String)(bundle = bundleContext.getBundle(bundleId.longValue())).getHeaders().get("Web-ContextPath")) != null) {
            LinkedHashSet wiredBundles = BundleUtils.getWiredBundles((Bundle)bundle);
            dependentBundles.addAll(wiredBundles);
        }
        return dependentBundles;
    }

    @Override
    public List<FacesConfig> getDependentFacesConfigs(Long bundleId) {
        Set<Bundle> dependentBundles = this.getDependentBundles(bundleId);
        ArrayList<FacesConfig> dependentFacesConfigs = new ArrayList<FacesConfig>();
        for (Bundle dependentBundle : dependentBundles) {
            List<FacesConfig> facesConfigs = this.bundleIdFacesConfigsMap.get(dependentBundle.getBundleId());
            if (facesConfigs == null) continue;
            dependentFacesConfigs.addAll(facesConfigs);
        }
        return dependentFacesConfigs;
    }

    @Override
    public List<URL> getDependentFaceletsConfigResources(Long bundleId) {
        Set<Bundle> dependentBundles = this.getDependentBundles(bundleId);
        ArrayList<URL> faceletsConfigResources = new ArrayList<URL>();
        for (Bundle dependentBundle : dependentBundles) {
            List<URL> faceletConfigResources = this.bundleIdFaceletsConfigResourcesMap.get(dependentBundle.getBundleId());
            if (faceletConfigResources == null) continue;
            faceletsConfigResources.addAll(faceletConfigResources);
        }
        return faceletsConfigResources;
    }

    @Override
    public Set<Long> getFacesConfigsBundleIds() {
        return this.bundleIdFacesConfigsMap.keySet();
    }

    @Override
    public List<FacesConfig> getFacesConfigs(Long bundleId) {
        return this.bundleIdFacesConfigsMap.get(bundleId);
    }

    @Override
    public Set<Long> getFaceletsConfigResourcesBundleIds() {
        return this.bundleIdFaceletsConfigResourcesMap.keySet();
    }

    @Override
    public List<URL> getFaceletsConfigResources(Long bundleId) {
        return this.bundleIdFaceletsConfigResourcesMap.get(bundleId);
    }

    @Override
    public List<URL> getFacesConfigURLs(Long bundleId) {
        return this.bundleIdFacesConfigURLsMap.get(bundleId);
    }

    private void log(int level, String message) {
        this.activator.log(level, message);
    }

    private void log(int level, String message, Throwable th) {
        this.activator.log(level, message, th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FacesConfig parseFacesConfig(Bundle bundle, URL url) {
        this.log(4, "found META-INF/faces-config.xml");
        InputStream in = null;
        try {
            in = url.openStream();
            org.apache.myfaces.config.impl.digester.elements.FacesConfig facesConfig = this.facesConfigDigester.getFacesConfig(in, url.toExternalForm());
            return facesConfig;
        }
        catch (Exception e) {
            this.log(2, "fail to parse " + url + " in the bundle " + bundle.getSymbolicName() + " due to " + e.getMessage(), e);
            FacesConfig facesConfig = null;
            return facesConfig;
        }
        finally {
            IOUtils.close((Closeable)in);
        }
    }
}

