/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.myfaces.webapp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.myfaces.config.resource.ConfigurationResource;
import org.apache.geronimo.myfaces.config.resource.osgi.api.ConfigRegistry;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.element.FacesConfigData;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="MyFaces WebApplication Context", j2eeType="MyFacesWebAppContext")
public class MyFacesWebAppContext
implements GBeanLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MyFacesWebAppContext.class);
    private static final Map<String, MyFacesWebAppContext> MYFACES_WEBAPP_CONTEXTS = new ConcurrentHashMap<String, MyFacesWebAppContext>();
    private FacesConfigData facesConfigData;
    private Bundle bundle;
    private ClassLoader classLoader;
    private List<URL> faceletConfigResources;
    private AbstractName abName;
    private LifecycleProvider lifecycleProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MyFacesWebAppContext(@ParamAttribute(name="facesConfigData") FacesConfigData facesConfigData, @ParamAttribute(name="faceletConfigResources") Set<ConfigurationResource> faceletConfigResources, @ParamReference(name="LifecycleProvider") LifecycleProvider lifecycleProvider, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abName) {
        this.bundle = BundleUtils.unwrapBundle((Bundle)bundle);
        this.facesConfigData = facesConfigData;
        this.classLoader = classLoader;
        this.abName = abName;
        this.lifecycleProvider = lifecycleProvider;
        ServiceReference serviceReference = null;
        this.faceletConfigResources = new ArrayList<URL>(faceletConfigResources.size());
        try {
            for (ConfigurationResource faceletConfigResource : faceletConfigResources) {
                this.faceletConfigResources.add(faceletConfigResource.getConfigurationResourceURL(bundle));
            }
            serviceReference = bundle.getBundleContext().getServiceReference(ConfigRegistry.class.getName());
            if (serviceReference != null) {
                ConfigRegistry configRegistry = (ConfigRegistry)bundle.getBundleContext().getService(serviceReference);
                List<URL> dependentFaceletsConfigResources = configRegistry.getDependentFaceletsConfigResources(bundle.getBundleId());
                if (dependentFaceletsConfigResources != null) {
                    this.faceletConfigResources.addAll(dependentFaceletsConfigResources);
                }
            } else {
                logger.warn("Fail to find ConfigRegistry service, those *.taglib.xml from dependent bundles will not be registered in current web application " + bundle.getSymbolicName());
            }
            if (serviceReference == null) return;
        }
        catch (MalformedURLException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                if (serviceReference == null) throw throwable;
                bundle.getBundleContext().ungetService(serviceReference);
                throw throwable;
            }
        }
        bundle.getBundleContext().ungetService(serviceReference);
        return;
    }

    public FacesConfigData getFacesConfigData() {
        return this.facesConfigData;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<URL> getRuntimeFaceletConfigResources() {
        return this.faceletConfigResources;
    }

    public LifecycleProvider getLifecycleProvider() {
        return this.lifecycleProvider;
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getWebModuleName() {
        return this.abName.getNameProperty("WebModule");
    }

    public void doStart() throws Exception {
        MYFACES_WEBAPP_CONTEXTS.put(this.getWebModuleName(), this);
    }

    public void doStop() throws Exception {
        MYFACES_WEBAPP_CONTEXTS.remove(this.getWebModuleName());
    }

    public static MyFacesWebAppContext getMyFacesWebAppContext(String webModuleName) {
        return MYFACES_WEBAPP_CONTEXTS.get(webModuleName);
    }
}

