/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.mail.ProtocolGBean;
import org.apache.geronimo.management.JavaMailResource;

public class MailGBean
implements GBeanLifecycle,
JavaMailResource {
    private final Log log = LogFactory.getLog(MailGBean.class);
    private final String objectName;
    private final Collection protocols;
    private Boolean useDefault;
    private Properties properties;
    private Authenticator authenticator;
    private String storeProtocol;
    private String transportProtocol;
    private String host;
    private String user;
    private Boolean debug;
    private String jndiName;
    public static final GBeanInfo GBEAN_INFO;

    public MailGBean(String objectName, Collection protocols, Boolean useDefault, Properties properties, Authenticator authenticator, String storeProtocol, String transportProtocol, String host, String user, Boolean debug, String jndiName) {
        this.objectName = objectName;
        this.protocols = protocols;
        this.setUseDefault(useDefault);
        this.properties = properties == null ? new Properties() : properties;
        this.setAuthenticator(authenticator);
        this.setStoreProtocol(storeProtocol);
        this.setTransportProtocol(transportProtocol);
        this.setHost(host);
        this.setUser(user);
        this.setDebug(debug);
        this.setJndiName(jndiName);
    }

    public Collection getProtocols() {
        return this.protocols;
    }

    public Boolean getUseDefault() {
        return this.useDefault;
    }

    public void setUseDefault(Boolean useDefault) {
        this.useDefault = useDefault;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public String getStoreProtocol() {
        return this.storeProtocol;
    }

    public void setStoreProtocol(String storeProtocol) {
        this.storeProtocol = storeProtocol;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Object $getResource() {
        Properties props = new Properties(this.properties);
        if (this.protocols != null) {
            for (ProtocolGBean protocol : this.protocols) {
                protocol.addOverrides(props);
            }
        }
        props.putAll((Map<?, ?>)this.properties);
        if (this.storeProtocol != null) {
            props.put("mail.store.protocol", this.storeProtocol);
        }
        if (this.transportProtocol != null) {
            props.put("mail.transport.protocol", this.transportProtocol);
        }
        if (this.host != null) {
            props.put("mail.host", this.host);
        }
        if (this.user != null) {
            props.put("mail.user", this.user);
        }
        if (this.debug != null) {
            props.put("mail.debug", this.debug.toString());
        }
        if (Boolean.TRUE.equals(this.useDefault)) {
            if (this.authenticator == null) {
                return Session.getDefaultInstance((Properties)props);
            }
            return Session.getDefaultInstance((Properties)props, (Authenticator)this.authenticator);
        }
        if (this.authenticator == null) {
            return Session.getInstance((Properties)props);
        }
        return Session.getInstance((Properties)props, (Authenticator)this.authenticator);
    }

    public void doStart() throws Exception {
        this.log.debug((Object)("Started " + this.objectName + " - will return " + (Boolean.TRUE.equals(this.useDefault) ? "default" : "new") + " JavaMail Session " + (this.authenticator == null ? "without" : "with") + " authenticator"));
        String jndiName = this.getJndiName();
        if (jndiName != null && jndiName.length() > 0) {
            Object value = this.$getResource();
            InitialContext context = new InitialContext();
            Name parsedName = context.getNameParser("").parse(jndiName);
            for (int i = 1; i < parsedName.size(); ++i) {
                Name contextName = parsedName.getPrefix(i);
                if (MailGBean.bindingExists(context, contextName)) continue;
                context.createSubcontext(contextName);
            }
            context.bind(jndiName, value);
            this.log.info((Object)("JavaMail session bound to " + jndiName));
        }
    }

    public void doStop() throws Exception {
        this.log.debug((Object)("Stopped " + this.objectName));
        this.stop();
    }

    public void doFail() {
        this.log.warn((Object)("Failed " + this.objectName));
        this.stop();
    }

    private void stop() {
        String jndiName = this.getJndiName();
        if (jndiName != null && jndiName.length() > 0) {
            try {
                InitialContext context = new InitialContext();
                context.unbind(jndiName);
                this.log.info((Object)("JavaMail session unbound from " + jndiName));
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private static boolean bindingExists(Context context, Name contextName) {
        try {
            return context.lookup(contextName) != null;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(MailGBean.class, (String)"JavaMailResource");
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addReference("Protocols", ProtocolGBean.class, "GBean");
        infoFactory.addAttribute("useDefault", Boolean.class, true);
        infoFactory.addAttribute("properties", Properties.class, true);
        infoFactory.addReference("Authenticator", Authenticator.class, "GBean");
        infoFactory.addAttribute("storeProtocol", String.class, true);
        infoFactory.addAttribute("transportProtocol", String.class, true);
        infoFactory.addAttribute("host", String.class, true);
        infoFactory.addAttribute("user", String.class, true);
        infoFactory.addAttribute("debug", Boolean.class, true);
        infoFactory.addAttribute("jndiName", String.class, true);
        infoFactory.addOperation("$getResource");
        infoFactory.addOperation("getProtocols");
        infoFactory.addInterface(JavaMailResource.class);
        infoFactory.setConstructor(new String[]{"objectName", "Protocols", "useDefault", "properties", "Authenticator", "storeProtocol", "transportProtocol", "host", "user", "debug", "jndiName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

