/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.GBeanReference;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.gbean.runtime.ReflectionMethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

public abstract class AbstractGBeanReference
implements GBeanReference {
    protected static final boolean NO_PROXY = Boolean.getBoolean("Xorg.apache.geronimo.gbean.NoProxy");
    private final String name;
    private final Class referenceType;
    private final Class proxyType;
    private final GBeanInstance gbeanInstance;
    private final MethodInvoker setInvoker;
    private final boolean hasTargets;
    private final GReferenceInfo referenceInfo;
    private final Kernel kernel;
    private Object proxy;

    public AbstractGBeanReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, boolean hasTargets) throws InvalidConfigurationException {
        this.gbeanInstance = gbeanInstance;
        this.referenceInfo = referenceInfo;
        this.kernel = kernel;
        this.hasTargets = hasTargets;
        this.name = referenceInfo.getName();
        try {
            this.referenceType = ClassLoading.loadClass(referenceInfo.getReferenceType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Reference Type: " + this.getDescription(), e);
        }
        if (Modifier.isFinal(this.referenceType.getModifiers())) {
            throw new IllegalArgumentException("Proxy interface cannot be a final class: " + this.referenceType.getName());
        }
        try {
            this.proxyType = ClassLoading.loadClass(referenceInfo.getProxyType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Proxy Type:" + this.getDescription(), e);
        }
        if (referenceInfo.getSetterName() != null) {
            try {
                String setterName = referenceInfo.getSetterName();
                Method setterMethod = gbeanInstance.getType().getMethod(setterName, this.proxyType);
                if (NO_PROXY) {
                    this.setInvoker = new ReflectionMethodInvoker(setterMethod);
                }
                this.setInvoker = new FastMethodInvoker(setterMethod);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidConfigurationException("Setter method not found " + this.getDescription(), e);
            }
        } else {
            this.setInvoker = null;
        }
    }

    protected final Kernel getKernel() {
        return this.kernel;
    }

    public final GBeanInstance getGBeanInstance() {
        return this.gbeanInstance;
    }

    public final String getName() {
        return this.name;
    }

    public final GReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public final Class getReferenceType() {
        return this.referenceType;
    }

    public final Class getProxyType() {
        return this.proxyType;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    protected final void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    protected boolean isRunning(Kernel kernel, AbstractName abstractName) {
        try {
            int state = kernel.getGBeanState(abstractName);
            return state == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getDescription() {
        return "\n    GBeanInstance: " + this.gbeanInstance.getName() + "\n    Reference Name: " + this.getName() + "\n    Reference Type: " + this.referenceInfo.getReferenceType() + "\n    Proxy Type: " + this.referenceInfo.getProxyType();
    }

    public final synchronized void inject(Object target) throws Exception {
        if (this.setInvoker != null && this.hasTargets) {
            this.setInvoker.invoke(target, new Object[]{this.getProxy()});
        }
    }

    static {
        if (NO_PROXY) {
            Log log = LogFactory.getLog(AbstractGBeanReference.class);
            log.warn((Object)"GBean reference proxies has been disabled:  This is an experimental and untested operating mode");
        }
    }
}

