/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactManager;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ListableRepository;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.MultipleMatchesException;
import org.apache.geronimo.kernel.repository.Version;

public class DefaultArtifactResolver
implements ArtifactResolver {
    private final ArtifactManager artifactManager;
    private final Collection repositories;
    private final Map explicitResolution;
    public static final GBeanInfo GBEAN_INFO;

    public DefaultArtifactResolver(ArtifactManager artifactManager, ListableRepository repository) {
        this.artifactManager = artifactManager;
        this.repositories = Collections.singleton(repository);
        this.explicitResolution = Collections.EMPTY_MAP;
    }

    public DefaultArtifactResolver(ArtifactManager artifactManager, Collection repositories, Map explicitResolution) {
        this.artifactManager = artifactManager;
        this.repositories = repositories;
        this.explicitResolution = explicitResolution == null ? Collections.EMPTY_MAP : explicitResolution;
    }

    public Artifact generateArtifact(Artifact source, String defaultType) {
        if (source.isResolved()) {
            Artifact deAliased = (Artifact)this.explicitResolution.get(source);
            if (deAliased != null) {
                return deAliased;
            }
            return source;
        }
        String groupId = source.getGroupId() == null ? "default" : source.getGroupId();
        String artifactId = source.getArtifactId();
        String type = source.getType() == null ? defaultType : source.getType();
        Version version = source.getVersion() == null ? new Version(Long.toString(System.currentTimeMillis())) : source.getVersion();
        return new Artifact(groupId, artifactId, version, type);
    }

    public Artifact queryArtifact(Artifact artifact) throws MultipleMatchesException {
        Artifact[] all = this.queryArtifacts(artifact);
        if (all.length > 1) {
            throw new MultipleMatchesException(artifact);
        }
        return all.length == 0 ? null : all[0];
    }

    public Artifact[] queryArtifacts(Artifact artifact) {
        LinkedHashSet set = new LinkedHashSet();
        Iterator iterator = this.repositories.iterator();
        while (iterator.hasNext()) {
            ListableRepository repository = (ListableRepository)iterator.next();
            set.addAll(repository.list(artifact));
        }
        return set.toArray(new Artifact[set.size()]);
    }

    public LinkedHashSet resolveInClassLoader(Collection artifacts) throws MissingDependencyException {
        return this.resolveInClassLoader(artifacts, (Collection)Collections.EMPTY_SET);
    }

    public LinkedHashSet resolveInClassLoader(Collection artifacts, Collection parentConfigurations) throws MissingDependencyException {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (!artifact.isResolved()) {
                artifact = this.resolveInClassLoader(artifact, parentConfigurations);
            }
            resolvedArtifacts.add(artifact);
        }
        return resolvedArtifacts;
    }

    public Artifact resolveInClassLoader(Artifact source) throws MissingDependencyException {
        return this.resolveInClassLoader(source, (Collection)Collections.EMPTY_SET);
    }

    public Artifact resolveInClassLoader(Artifact source, Collection parentConfigurations) throws MissingDependencyException {
        if (source.isResolved()) {
            return source;
        }
        Artifact working = this.resolveVersion(parentConfigurations, source);
        if (working == null || !working.isResolved()) {
            throw new MissingDependencyException("Unable to resolve dependency " + source);
        }
        return working;
    }

    private Artifact resolveVersion(Collection parentConfigurations, Artifact working) {
        SortedSet existingArtifacts;
        Artifact deAliased = (Artifact)this.explicitResolution.get(working);
        if (deAliased != null) {
            working = deAliased;
        }
        if ((existingArtifacts = this.artifactManager != null ? this.artifactManager.getLoadedArtifacts(working) : new TreeSet()).size() == 1) {
            return (Artifact)existingArtifacts.first();
        }
        if (existingArtifacts.size() == 0) {
            TreeSet list = new TreeSet();
            Iterator iterator = this.repositories.iterator();
            while (iterator.hasNext()) {
                ListableRepository repository = (ListableRepository)iterator.next();
                list.addAll(repository.list(working));
            }
            if (list.isEmpty()) {
                return null;
            }
            return (Artifact)list.last();
        }
        Artifact artifact = this.searchParents(parentConfigurations, working);
        if (artifact != null) {
            return artifact;
        }
        return (Artifact)existingArtifacts.last();
    }

    private Artifact searchParents(Collection parentConfigurations, Artifact working) {
        Iterator iterator = parentConfigurations.iterator();
        while (iterator.hasNext()) {
            Artifact artifact;
            Configuration configuration = (Configuration)iterator.next();
            if (this.matches(configuration.getId(), working)) {
                return configuration.getId();
            }
            Environment environment = configuration.getEnvironment();
            if (environment.isInverseClassLoading()) {
                artifact = this.getArtifactVersion(configuration.getDependencies(), working);
                if (artifact != null) {
                    return artifact;
                }
                artifact = this.searchParents(configuration.getClassParents(), working);
                if (artifact == null) continue;
                return artifact;
            }
            artifact = this.searchParents(configuration.getClassParents(), working);
            if (artifact != null) {
                return artifact;
            }
            artifact = this.getArtifactVersion(configuration.getDependencies(), working);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    private Artifact getArtifactVersion(Collection artifacts, Artifact query) {
        Iterator iterator = artifacts.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            if (!this.matches(artifact, query)) continue;
            return artifact;
        }
        return null;
    }

    private boolean matches(Artifact candidate, Artifact query) {
        return query.matches(candidate);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic(DefaultArtifactResolver.class, "ArtifactResolver");
        infoFactory.addAttribute("explicitResolution", Map.class, true, true);
        infoFactory.addReference("ArtifactManager", ArtifactManager.class, "ArtifactManager");
        infoFactory.addReference("Repositories", ListableRepository.class, "Repository");
        infoFactory.addInterface(ArtifactResolver.class);
        infoFactory.setConstructor(new String[]{"ArtifactManager", "Repositories", "explicitResolution"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

