/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.log;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.kernel.log.BootstrapLogFactory;
import org.apache.geronimo.kernel.log.GeronimoLog;

public class GeronimoLogFactory
extends LogFactory {
    private static final Object factoryLock = new Object();
    private static final HashMap instancesByClassLoader = new HashMap();
    private static LogFactory logFactory = new BootstrapLogFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogFactory getLogFactory() {
        Object object = factoryLock;
        synchronized (object) {
            return logFactory;
        }
    }

    public void setLogFactory(LogFactory logFactory) {
        GeronimoLogFactory.logFactory = logFactory;
        Set logs = this.getInstances();
        Iterator iterator = logs.iterator();
        while (iterator.hasNext()) {
            GeronimoLog log = (GeronimoLog)iterator.next();
            log.setLog(logFactory.getInstance(log.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getInstances() {
        Object object = factoryLock;
        synchronized (object) {
            HashSet logs = new HashSet();
            Iterator iterator = instancesByClassLoader.values().iterator();
            while (iterator.hasNext()) {
                Map instanceMap = (Map)iterator.next();
                logs.addAll(instanceMap.values());
            }
            return logs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(Class clazz) throws LogConfigurationException {
        Object object = factoryLock;
        synchronized (object) {
            return this.getInstance(clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(String name) throws LogConfigurationException {
        Object object = factoryLock;
        synchronized (object) {
            Log log;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            HashMap<String, Log> instances = (HashMap<String, Log>)instancesByClassLoader.get(contextClassLoader);
            if (instances == null) {
                instances = new HashMap<String, Log>();
                instancesByClassLoader.put(contextClassLoader, instances);
            }
            if ((log = (Log)instances.get(name)) == null) {
                log = new GeronimoLog(name, logFactory.getInstance(name));
                instances.put(name, log);
            }
            return log;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = factoryLock;
        synchronized (object) {
            instancesByClassLoader.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        Object object = factoryLock;
        synchronized (object) {
            return logFactory.getAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAttributeNames() {
        Object object = factoryLock;
        synchronized (object) {
            return logFactory.getAttributeNames();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object object = factoryLock;
        synchronized (object) {
            logFactory.removeAttribute(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object object = factoryLock;
        synchronized (object) {
            logFactory.setAttribute(name, value);
        }
    }
}

