/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationInfo;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModel;
import org.apache.geronimo.kernel.config.ConfigurationResolver;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.config.LifecycleException;
import org.apache.geronimo.kernel.config.LifecycleMonitor;
import org.apache.geronimo.kernel.config.LifecycleResults;
import org.apache.geronimo.kernel.config.NoSuchConfigException;
import org.apache.geronimo.kernel.config.NoSuchStoreException;
import org.apache.geronimo.kernel.config.NullLifecycleMonitor;
import org.apache.geronimo.kernel.management.State;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Dependency;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.MissingDependencyException;
import org.apache.geronimo.kernel.repository.Version;

public class SimpleConfigurationManager
implements ConfigurationManager {
    protected static final Log log = LogFactory.getLog((Class)SimpleConfigurationManager.class);
    protected final Collection stores;
    private final ArtifactResolver artifactResolver;
    protected final Map configurations = new LinkedHashMap();
    protected final ConfigurationModel configurationModel = new ConfigurationModel();
    protected final Collection repositories;
    protected final Collection watchers;
    private Configuration reloadingConfiguration;

    public SimpleConfigurationManager(Collection stores, ArtifactResolver artifactResolver, Collection repositories) {
        this(stores, artifactResolver, repositories, Collections.EMPTY_SET);
    }

    public SimpleConfigurationManager(Collection stores, ArtifactResolver artifactResolver, Collection repositories, Collection watchers) {
        if (stores == null) {
            stores = Collections.EMPTY_SET;
        }
        if (repositories == null) {
            repositories = Collections.EMPTY_SET;
        }
        if (watchers == null) {
            watchers = Collections.EMPTY_SET;
        }
        this.stores = stores;
        this.artifactResolver = artifactResolver;
        this.repositories = repositories;
        this.watchers = watchers;
    }

    public synchronized boolean isInstalled(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        List storeSnapshot = this.getStoreList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configId)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isLoaded(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        if (this.reloadingConfiguration != null && this.reloadingConfiguration.getId().equals(configId)) {
            return true;
        }
        return this.configurationModel.isLoaded(configId);
    }

    public synchronized boolean isRunning(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        return this.configurationModel.isStarted(configId);
    }

    public Artifact[] getInstalled(Artifact query) {
        Artifact[] all = this.artifactResolver.queryArtifacts(query);
        ArrayList<Artifact> configs = new ArrayList<Artifact>();
        for (int i = 0; i < all.length; ++i) {
            Artifact artifact = all[i];
            if (!this.isConfiguration(artifact)) continue;
            configs.add(artifact);
        }
        if (configs.size() == all.length) {
            return all;
        }
        return configs.toArray(new Artifact[configs.size()]);
    }

    public Artifact[] getLoaded(Artifact query) {
        return this.configurationModel.getLoaded(query);
    }

    public Artifact[] getRunning(Artifact query) {
        return this.configurationModel.getStarted(query);
    }

    public List listStores() {
        List storeSnapshot = this.getStoreList();
        ArrayList<AbstractName> result = new ArrayList<AbstractName>(storeSnapshot.size());
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            result.add(store.getAbstractName());
        }
        return result;
    }

    public ConfigurationStore[] getStores() {
        List storeSnapshot = this.getStoreList();
        return storeSnapshot.toArray(new ConfigurationStore[storeSnapshot.size()]);
    }

    public Collection getRepositories() {
        return this.repositories;
    }

    public List listConfigurations() {
        List storeSnapshot = this.getStoreList();
        ArrayList list = new ArrayList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            list.addAll(this.listConfigurations(store));
        }
        return list;
    }

    public ConfigurationStore getStoreForConfiguration(Artifact configId) {
        if (!configId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configId + " is not fully resolved");
        }
        List storeSnapshot = this.getStoreList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configId)) continue;
            return store;
        }
        return null;
    }

    public List listConfigurations(AbstractName storeName) throws NoSuchStoreException {
        List storeSnapshot = this.getStoreList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!storeName.equals(store.getAbstractName())) continue;
            return this.listConfigurations(store);
        }
        throw new NoSuchStoreException("No such store: " + storeName);
    }

    private List listConfigurations(ConfigurationStore store) {
        List list = store.listConfigurations();
        ListIterator<ConfigurationInfo> iterator = list.listIterator();
        while (iterator.hasNext()) {
            ConfigurationInfo configurationInfo = (ConfigurationInfo)iterator.next();
            configurationInfo = this.isRunning(configurationInfo.getConfigID()) ? new ConfigurationInfo(store.getAbstractName(), configurationInfo.getConfigID(), configurationInfo.getType(), configurationInfo.getCreated(), configurationInfo.getOwnedConfigurations(), configurationInfo.getChildConfigurations(), configurationInfo.getInPlaceLocation(), State.RUNNING) : new ConfigurationInfo(store.getAbstractName(), configurationInfo.getConfigID(), configurationInfo.getType(), configurationInfo.getCreated(), configurationInfo.getOwnedConfigurations(), configurationInfo.getChildConfigurations(), configurationInfo.getInPlaceLocation(), State.STOPPED);
            iterator.set(configurationInfo);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfiguration(Artifact artifact) {
        if (!artifact.isResolved()) {
            throw new IllegalArgumentException("Artifact " + artifact + " is not fully resolved");
        }
        SimpleConfigurationManager simpleConfigurationManager = this;
        synchronized (simpleConfigurationManager) {
            if (this.configurations.containsKey(artifact)) {
                return true;
            }
        }
        List storeSnapshot = this.getStoreList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(artifact)) continue;
            return true;
        }
        return false;
    }

    public synchronized Configuration getConfiguration(Artifact configurationId) {
        if (!configurationId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
        }
        if (this.reloadingConfiguration != null && this.reloadingConfiguration.getId().equals(configurationId)) {
            return this.reloadingConfiguration;
        }
        return (Configuration)this.configurations.get(configurationId);
    }

    public synchronized LifecycleResults loadConfiguration(Artifact configurationId) throws NoSuchConfigException, LifecycleException {
        return this.loadConfiguration(configurationId, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults loadConfiguration(Artifact configurationId, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!configurationId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
        }
        if (this.isLoaded(configurationId)) {
            this.load(configurationId);
            monitor.finished();
            return new LifecycleResults();
        }
        ConfigurationData configurationData = null;
        try {
            configurationData = this.loadConfigurationData(configurationId, monitor);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("load", configurationId, e);
        }
        LifecycleResults results = this.loadConfiguration(configurationData, monitor);
        return results;
    }

    public synchronized LifecycleResults loadConfiguration(ConfigurationData configurationData) throws NoSuchConfigException, LifecycleException {
        return this.loadConfiguration(configurationData, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults loadConfiguration(ConfigurationData configurationData, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        Artifact id = configurationData.getId();
        LifecycleResults results = new LifecycleResults();
        if (!this.isLoaded(id)) {
            LinkedHashMap configurationsToLoad = new LinkedHashMap();
            try {
                this.loadDepthFirst(configurationData, configurationsToLoad, monitor);
            }
            catch (Exception e) {
                monitor.finished();
                throw new LifecycleException("load", id, e);
            }
            LinkedHashMap<Artifact, Configuration> actuallyLoaded = new LinkedHashMap<Artifact, Configuration>(configurationsToLoad.size());
            Artifact configurationId = null;
            try {
                Iterator iterator = configurationsToLoad.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    configurationId = (Artifact)entry.getKey();
                    UnloadedConfiguration unloadedConfiguration = (UnloadedConfiguration)entry.getValue();
                    monitor.loading(configurationId);
                    Configuration configuration = this.load(unloadedConfiguration.getConfigurationData(), unloadedConfiguration.getResolvedParentIds(), actuallyLoaded);
                    monitor.succeeded(configurationId);
                    actuallyLoaded.put(configurationId, configuration);
                }
            }
            catch (Exception e) {
                monitor.failed(configurationId, e);
                Iterator iterator = actuallyLoaded.values().iterator();
                while (iterator.hasNext()) {
                    Configuration configuration = (Configuration)iterator.next();
                    this.unload(configuration);
                }
                monitor.finished();
                throw new LifecycleException("load", id, e);
            }
            this.addNewConfigurationsToModel(actuallyLoaded);
            results.setLoaded(actuallyLoaded.keySet());
        }
        this.load(id);
        monitor.finished();
        return results;
    }

    protected void load(Artifact configurationId) throws NoSuchConfigException {
        this.configurationModel.load(configurationId);
    }

    protected Configuration load(ConfigurationData configurationData, LinkedHashSet resolvedParentIds, Map loadedConfigurations) throws InvalidConfigException {
        Artifact configurationId = configurationData.getId();
        try {
            Collection parents = this.findParentConfigurations(resolvedParentIds, loadedConfigurations);
            Configuration configuration = new Configuration(parents, configurationData, new ConfigurationResolver(configurationData, this.repositories, this.artifactResolver), null);
            configuration.doStart();
            return configuration;
        }
        catch (Exception e) {
            throw new InvalidConfigException("Error starting configuration gbean " + configurationId, e);
        }
    }

    private Collection findParentConfigurations(LinkedHashSet resolvedParentIds, Map loadedConfigurations) throws InvalidConfigException {
        LinkedHashMap<Artifact, Configuration> parents = new LinkedHashMap<Artifact, Configuration>();
        Iterator iterator = resolvedParentIds.iterator();
        while (iterator.hasNext()) {
            Artifact resolvedArtifact = (Artifact)iterator.next();
            Configuration parent = null;
            if (loadedConfigurations.containsKey(resolvedArtifact)) {
                parent = (Configuration)loadedConfigurations.get(resolvedArtifact);
            } else if (this.isLoaded(resolvedArtifact)) {
                parent = this.getConfiguration(resolvedArtifact);
            } else {
                throw new InvalidConfigException("Cound not find parent configuration: " + resolvedArtifact);
            }
            parents.put(resolvedArtifact, parent);
        }
        return parents.values();
    }

    private void addNewConfigurationsToModel(Map loadedConfigurations) throws NoSuchConfigException {
        Iterator iterator = loadedConfigurations.values().iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            this.addNewConfigurationToModel(configuration);
        }
    }

    protected void addNewConfigurationToModel(Configuration configuration) throws NoSuchConfigException {
        this.configurationModel.addConfiguation(configuration.getId(), SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(configuration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(configuration)));
        this.configurations.put(configuration.getId(), configuration);
    }

    protected LinkedHashSet getLoadParents(Configuration configuration) {
        LinkedHashSet loadParent = new LinkedHashSet(configuration.getClassParents());
        Iterator iterator = configuration.getChildren().iterator();
        while (iterator.hasNext()) {
            Configuration childConfiguration = (Configuration)iterator.next();
            LinkedHashSet childLoadParent = this.getLoadParents(childConfiguration);
            childLoadParent.remove(configuration);
            loadParent.addAll(childLoadParent);
        }
        return loadParent;
    }

    protected LinkedHashSet getStartParents(Configuration configuration) {
        LinkedHashSet startParent = new LinkedHashSet(configuration.getServiceParents());
        Iterator iterator = configuration.getChildren().iterator();
        while (iterator.hasNext()) {
            Configuration childConfiguration = (Configuration)iterator.next();
            LinkedHashSet childStartParent = this.getStartParents(childConfiguration);
            childStartParent.remove(configuration);
            startParent.addAll(childStartParent);
        }
        return startParent;
    }

    private static LinkedHashSet getConfigurationIds(Collection configurations) {
        LinkedHashSet<Artifact> configurationIds = new LinkedHashSet<Artifact>(configurations.size());
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            configurationIds.add(configuration.getId());
        }
        return configurationIds;
    }

    private synchronized void loadDepthFirst(ConfigurationData configurationData, LinkedHashMap configurationsToLoad, LifecycleMonitor monitor) throws NoSuchConfigException, IOException, InvalidConfigException, MissingDependencyException {
        Artifact configurationId = configurationData.getId();
        if (!configurationsToLoad.containsKey(configurationId)) {
            LinkedHashSet resolvedParentIds = this.resolveParentIds(configurationData);
            Iterator iterator = resolvedParentIds.iterator();
            while (iterator.hasNext()) {
                Artifact parentId = (Artifact)iterator.next();
                if (this.isLoaded(parentId) || !this.isConfiguration(parentId)) continue;
                ConfigurationData parentConfigurationData = this.loadConfigurationData(parentId, monitor);
                this.loadDepthFirst(parentConfigurationData, configurationsToLoad, monitor);
            }
            configurationsToLoad.put(configurationId, new UnloadedConfiguration(configurationData, resolvedParentIds));
        }
    }

    private ConfigurationData loadConfigurationData(Artifact configurationId, LifecycleMonitor monitor) throws NoSuchConfigException, IOException, InvalidConfigException {
        List storeSnapshot = this.getStoreList();
        monitor.addConfiguration(configurationId);
        monitor.reading(configurationId);
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configurationId)) continue;
            ConfigurationData configurationData = store.loadConfiguration(configurationId);
            monitor.succeeded(configurationId);
            return configurationData;
        }
        NoSuchConfigException exception = new NoSuchConfigException(configurationId);
        monitor.failed(configurationId, exception);
        throw exception;
    }

    private LinkedHashSet resolveParentIds(ConfigurationData configurationData) throws MissingDependencyException, InvalidConfigException {
        Environment environment = configurationData.getEnvironment();
        LinkedHashSet<Artifact> parentIds = new LinkedHashSet<Artifact>();
        ArrayList dependencies = new ArrayList(environment.getDependencies());
        Iterator<Object> iterator = dependencies.listIterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            Artifact resolvedArtifact = this.artifactResolver.resolveInClassLoader(dependency.getArtifact());
            if (this.isConfiguration(resolvedArtifact)) {
                parentIds.add(resolvedArtifact);
                dependency = new Dependency(resolvedArtifact, dependency.getImportType());
                iterator.set(dependency);
                continue;
            }
            if (dependency.getImportType() != ImportType.SERVICES) continue;
            throw new InvalidConfigException("Dependency does not have services: " + resolvedArtifact);
        }
        iterator = configurationData.getChildConfigurations().values().iterator();
        while (iterator.hasNext()) {
            ConfigurationData childConfigurationData = (ConfigurationData)iterator.next();
            LinkedHashSet childParentIds = this.resolveParentIds(childConfigurationData);
            childParentIds.remove(configurationData.getId());
            parentIds.addAll(childParentIds);
        }
        return parentIds;
    }

    public synchronized LifecycleResults startConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.startConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults startConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet unstartedConfigurations = this.configurationModel.start(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, unstartedConfigurations);
        LifecycleResults results = new LifecycleResults();
        Artifact configurationId = null;
        try {
            Iterator iterator = unstartedConfigurations.iterator();
            while (iterator.hasNext()) {
                configurationId = (Artifact)iterator.next();
                Configuration configuration = this.getConfiguration(configurationId);
                monitor.starting(configurationId);
                this.start(configuration);
                monitor.succeeded(configurationId);
                results.addStarted(configurationId);
            }
        }
        catch (Exception e) {
            monitor.failed(configurationId, e);
            this.configurationModel.stop(id);
            Iterator iterator = results.getStarted().iterator();
            while (iterator.hasNext()) {
                configurationId = (Artifact)iterator.next();
                Configuration configuration = this.getConfiguration(configurationId);
                monitor.stopping(configurationId);
                this.stop(configuration);
                monitor.succeeded(configurationId);
            }
            monitor.finished();
            throw new LifecycleException("start", id, e);
        }
        monitor.finished();
        return results;
    }

    protected void start(Configuration configuration) throws Exception {
        throw new UnsupportedOperationException();
    }

    public synchronized LifecycleResults stopConfiguration(Artifact id) throws NoSuchConfigException {
        return this.stopConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults stopConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet stopList = this.configurationModel.stop(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, stopList);
        LifecycleResults results = new LifecycleResults();
        Iterator iterator = stopList.iterator();
        while (iterator.hasNext()) {
            Artifact configurationId = (Artifact)iterator.next();
            Configuration configuration = this.getConfiguration(configurationId);
            monitor.stopping(configurationId);
            this.stop(configuration);
            monitor.succeeded(configurationId);
            results.addStopped(configurationId);
        }
        monitor.finished();
        return results;
    }

    protected void stop(Configuration configuration) {
    }

    public synchronized LifecycleResults restartConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.restartConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults restartConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        LinkedHashSet restartList = this.configurationModel.restart(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, restartList);
        LifecycleResults results = new LifecycleResults();
        Iterator iterator = restartList.iterator();
        while (iterator.hasNext()) {
            Artifact configurationId = (Artifact)iterator.next();
            Configuration configuration = this.getConfiguration(configurationId);
            monitor.stopping(configurationId);
            this.stop(configuration);
            monitor.succeeded(configurationId);
            results.addStopped(configurationId);
        }
        restartList = SimpleConfigurationManager.reverse(restartList);
        HashSet<Artifact> skip = new HashSet<Artifact>();
        Iterator iterator2 = restartList.iterator();
        while (iterator2.hasNext()) {
            Artifact configurationId = (Artifact)iterator2.next();
            if (skip.contains(configurationId)) continue;
            try {
                Configuration configuration = this.getConfiguration(configurationId);
                monitor.starting(configurationId);
                this.start(configuration);
                monitor.succeeded(configurationId);
                results.addStarted(configurationId);
            }
            catch (Exception e) {
                results.addFailed(configurationId, e);
                monitor.failed(configurationId, e);
                skip.add(configurationId);
                LinkedHashSet stopList = this.configurationModel.stop(configurationId, false);
                if (!restartList.containsAll(stopList)) {
                    throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                }
                Iterator iterator1 = stopList.iterator();
                while (iterator1.hasNext()) {
                    Artifact failedId = (Artifact)iterator1.next();
                    if (results.wasStarted(failedId)) {
                        throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                    }
                    skip.add(failedId);
                }
            }
        }
        monitor.finished();
        if (!results.wasStarted(id)) {
            throw new LifecycleException("restart", id, results);
        }
        return results;
    }

    public synchronized LifecycleResults unloadConfiguration(Artifact id) throws NoSuchConfigException {
        return this.unloadConfiguration(id, NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults unloadConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        Set started = this.configurationModel.getStarted();
        LinkedHashSet unloadList = this.configurationModel.unload(id);
        SimpleConfigurationManager.addConfigurationsToMonitor(monitor, unloadList);
        LifecycleResults results = new LifecycleResults();
        Iterator iterator = unloadList.iterator();
        while (iterator.hasNext()) {
            Artifact configurationId = (Artifact)iterator.next();
            Configuration configuration = this.getConfiguration(configurationId);
            if (started.contains(configurationId)) {
                monitor.stopping(configurationId);
                this.stop(configuration);
                monitor.succeeded(configurationId);
                results.addStopped(configurationId);
            } else {
                this.stop(configuration);
            }
            monitor.unloading(configurationId);
            this.unload(configuration);
            monitor.succeeded(configurationId);
            results.addUnloaded(configurationId);
            this.removeConfigurationFromModel(configurationId);
        }
        monitor.finished();
        return results;
    }

    protected void removeConfigurationFromModel(Artifact configurationId) throws NoSuchConfigException {
        if (this.configurationModel.containsConfiguration(configurationId)) {
            this.configurationModel.removeConfiguration(configurationId);
        }
        this.configurations.remove(configurationId);
    }

    protected void unload(Configuration configuration) {
        try {
            configuration.doStop();
        }
        catch (Exception e) {
            log.debug((Object)("Problem unloading config: " + configuration.getId()), (Throwable)e);
        }
    }

    public synchronized LifecycleResults reloadConfiguration(Artifact id) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults reloadConfiguration(Artifact id, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, id.getVersion(), monitor);
    }

    public synchronized LifecycleResults reloadConfiguration(Artifact id, Version version) throws NoSuchConfigException, LifecycleException {
        return this.reloadConfiguration(id, version, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults reloadConfiguration(Artifact id, Version version, LifecycleMonitor monitor) throws NoSuchConfigException, LifecycleException {
        if (!id.isResolved()) {
            throw new IllegalArgumentException("Artifact " + id + " is not fully resolved");
        }
        Configuration configuration = this.getConfiguration(id);
        if (configuration == null) {
            ConfigurationData data = null;
            List storeSnapshot = this.getStoreList();
            for (int i = 0; i < storeSnapshot.size(); ++i) {
                ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
                if (!store.containsConfiguration(id)) continue;
                try {
                    data = store.loadConfiguration(id);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Unable to load existing configuration " + id + " from config store"), (Throwable)e);
                }
            }
            if (data == null) {
                throw new NoSuchConfigException(id);
            }
            UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(data, new LinkedHashSet());
            Artifact newId = new Artifact(id.getGroupId(), id.getArtifactId(), version, id.getType());
            ConfigurationData newData = null;
            try {
                newData = this.loadConfigurationData(newId, monitor);
            }
            catch (Exception e) {
                monitor.finished();
                throw new LifecycleException("reload", id, e);
            }
            return this.reloadConfiguration(existingUnloadedConfiguration, newData, monitor);
        }
        ConfigurationData existingConfigurationData = configuration.getConfigurationData();
        UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(existingConfigurationData, SimpleConfigurationManager.getResolvedParentIds(configuration));
        Artifact newId = new Artifact(id.getGroupId(), id.getArtifactId(), version, id.getType());
        ConfigurationData configurationData = null;
        try {
            configurationData = this.loadConfigurationData(newId, monitor);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("reload", id, e);
        }
        return this.reloadConfiguration(existingUnloadedConfiguration, configurationData, monitor);
    }

    public synchronized LifecycleResults reloadConfiguration(ConfigurationData configurationData) throws LifecycleException, NoSuchConfigException {
        return this.reloadConfiguration(configurationData, (LifecycleMonitor)NullLifecycleMonitor.INSTANCE);
    }

    public synchronized LifecycleResults reloadConfiguration(ConfigurationData configurationData, LifecycleMonitor monitor) throws LifecycleException, NoSuchConfigException {
        Configuration configuration = this.getConfiguration(configurationData.getId());
        if (configuration == null) {
            throw new NoSuchConfigException(configurationData.getId());
        }
        ConfigurationData existingConfigurationData = configuration.getConfigurationData();
        UnloadedConfiguration existingUnloadedConfiguration = new UnloadedConfiguration(existingConfigurationData, SimpleConfigurationManager.getResolvedParentIds(configuration));
        return this.reloadConfiguration(existingUnloadedConfiguration, configurationData, monitor);
    }

    private boolean hasHardDependency(Artifact configurationId, ConfigurationData configurationData) {
        Iterator<Object> iterator = configurationData.getEnvironment().getDependencies().iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            Artifact artifact = dependency.getArtifact();
            if (artifact.getVersion() == null || !artifact.matches(configurationId)) continue;
            return true;
        }
        iterator = configurationData.getChildConfigurations().values().iterator();
        while (iterator.hasNext()) {
            ConfigurationData childConfigurationData = (ConfigurationData)iterator.next();
            if (!this.hasHardDependency(configurationId, childConfigurationData)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LifecycleResults reloadConfiguration(UnloadedConfiguration existingUnloadedConfiguration, ConfigurationData newConfigurationData, LifecycleMonitor monitor) throws LifecycleException, NoSuchConfigException {
        Configuration configuration;
        Iterator<Object> iterator;
        boolean force = false;
        Artifact existingConfigurationId = existingUnloadedConfiguration.getConfigurationData().getId();
        Artifact newConfigurationId = newConfigurationData.getId();
        LinkedHashMap newConfigurations = new LinkedHashMap();
        try {
            this.loadDepthFirst(newConfigurationData, newConfigurations, monitor);
        }
        catch (Exception e) {
            monitor.finished();
            throw new LifecycleException("reload", newConfigurationId, e);
        }
        Set started = this.configurationModel.getStarted();
        LinkedHashMap<Artifact, LinkedHashSet> existingParents = new LinkedHashMap<Artifact, LinkedHashSet>();
        LinkedHashMap<Artifact, UnloadedConfiguration> reloadChildren = new LinkedHashMap<Artifact, UnloadedConfiguration>();
        Iterator iterator2 = SimpleConfigurationManager.reverse(this.configurationModel.reload(existingConfigurationId)).iterator();
        while (iterator2.hasNext()) {
            Artifact configurationId = (Artifact)iterator2.next();
            if (configurationId.equals(existingConfigurationId)) continue;
            if (newConfigurations.containsKey(configurationId)) {
                throw new LifecycleException("reload", newConfigurationId, new IllegalStateException("Circular depenency between " + newConfigurationId + " and " + configurationId));
            }
            Configuration configuration2 = this.getConfiguration(configurationId);
            ConfigurationData configurationData = configuration2.getConfigurationData();
            LinkedHashSet existingParentIds = SimpleConfigurationManager.getResolvedParentIds(configuration2);
            existingParents.put(configurationId, existingParentIds);
            LinkedHashSet<Artifact> resolvedParentIds = null;
            if (this.hasHardDependency(existingConfigurationId, configurationData)) {
                if (force) {
                    throw new LifecycleException("reload", newConfigurationId, new IllegalStateException("Existing configuration " + configurationId + " has a hard dependency on the current version of this configuration " + existingConfigurationId));
                }
                resolvedParentIds = null;
            } else {
                resolvedParentIds = new LinkedHashSet<Artifact>(existingParentIds);
                resolvedParentIds.remove(existingConfigurationId);
                resolvedParentIds.add(newConfigurationId);
            }
            reloadChildren.put(configurationId, new UnloadedConfiguration(configurationData, resolvedParentIds));
            monitor.addConfiguration(configurationId);
        }
        LifecycleResults results = new LifecycleResults();
        Iterator iterator3 = SimpleConfigurationManager.reverse(reloadChildren).keySet().iterator();
        while (iterator3.hasNext()) {
            Artifact configurationId = (Artifact)iterator3.next();
            Configuration configuration3 = this.getConfiguration(configurationId);
            if (started.contains(configurationId)) {
                monitor.stopping(configurationId);
                this.stop(configuration3);
                monitor.succeeded(configurationId);
                results.addStopped(configurationId);
            } else {
                this.stop(configuration3);
            }
            monitor.unloading(configurationId);
            this.unload(configuration3);
            monitor.succeeded(configurationId);
            results.addUnloaded(configurationId);
        }
        Configuration existingConfiguration = this.getConfiguration(existingConfigurationId);
        if (started.contains(existingConfigurationId)) {
            monitor.stopping(existingConfigurationId);
            this.stop(existingConfiguration);
            monitor.succeeded(existingConfigurationId);
            results.addStopped(existingConfigurationId);
        } else if (existingConfiguration != null) {
            this.stop(existingConfiguration);
        }
        if (existingConfiguration != null) {
            monitor.unloading(existingConfigurationId);
            this.unload(existingConfiguration);
            monitor.succeeded(existingConfigurationId);
            results.addUnloaded(existingConfigurationId);
        }
        boolean reinstatedExisting = false;
        LinkedHashMap<Artifact, Configuration> loadedParents = new LinkedHashMap<Artifact, Configuration>();
        LinkedHashMap<Artifact, Configuration> startedParents = new LinkedHashMap<Artifact, Configuration>();
        Configuration newConfiguration = null;
        Artifact configurationId = null;
        try {
            Iterator iterator4 = newConfigurations.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry entry = iterator4.next();
                configurationId = (Artifact)entry.getKey();
                UnloadedConfiguration unloadedConfiguration = (UnloadedConfiguration)entry.getValue();
                monitor.loading(configurationId);
                Configuration configuration4 = this.load(unloadedConfiguration.getConfigurationData(), unloadedConfiguration.getResolvedParentIds(), loadedParents);
                monitor.succeeded(configurationId);
                if (configurationId.equals(newConfigurationId)) {
                    newConfiguration = configuration4;
                    this.reloadingConfiguration = configuration4;
                    continue;
                }
                loadedParents.put(configurationId, configuration4);
            }
            if (newConfiguration == null) {
                AssertionError cause = new AssertionError((Object)"Internal error: configuration was not load");
                results.addFailed(newConfigurationId, (Throwable)((Object)cause));
                throw new LifecycleException("reload", newConfigurationId, results);
            }
            if (started.contains(existingConfigurationId)) {
                LinkedHashSet<Configuration> startList = new LinkedHashSet<Configuration>();
                iterator = this.getStartParents(newConfiguration).iterator();
                while (iterator.hasNext()) {
                    Configuration serviceParent = (Configuration)iterator.next();
                    if (!loadedParents.containsKey(serviceParent.getId())) continue;
                    startList.add(serviceParent);
                }
                iterator = startList.iterator();
                while (iterator.hasNext()) {
                    Configuration startParent = (Configuration)iterator.next();
                    monitor.starting(configurationId);
                    this.start(startParent);
                    monitor.succeeded(configurationId);
                    startedParents.put(configurationId, startParent);
                }
                monitor.starting(newConfigurationId);
                this.start(newConfiguration);
                monitor.succeeded(newConfigurationId);
            }
            results.setLoaded(loadedParents.keySet());
            results.addLoaded(newConfigurationId);
            if (started.contains(existingConfigurationId)) {
                results.setStarted(startedParents.keySet());
                results.addStarted(newConfigurationId);
            }
            this.addNewConfigurationsToModel(loadedParents);
            if (this.configurationModel.containsConfiguration(existingConfigurationId)) {
                this.configurationModel.upgradeConfiguration(existingConfigurationId, newConfigurationId, SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(newConfiguration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(newConfiguration)));
            } else {
                this.configurationModel.addConfiguation(newConfigurationId, SimpleConfigurationManager.getConfigurationIds(this.getLoadParents(newConfiguration)), SimpleConfigurationManager.getConfigurationIds(this.getStartParents(newConfiguration)));
                this.load(newConfigurationId);
            }
            this.configurations.remove(existingConfiguration);
            this.configurations.put(newConfigurationId, newConfiguration);
            this.migrateConfiguration(existingConfigurationId, newConfigurationId, newConfiguration, started.contains(existingConfigurationId));
        }
        catch (Exception e) {
            Configuration configuration5;
            monitor.failed(configurationId, e);
            results.addFailed(configurationId, e);
            iterator = startedParents.values().iterator();
            while (iterator.hasNext()) {
                configuration5 = (Configuration)iterator.next();
                this.stop(configuration5);
            }
            iterator = loadedParents.values().iterator();
            while (iterator.hasNext()) {
                configuration5 = (Configuration)iterator.next();
                this.unload(configuration5);
            }
            if (newConfiguration != null) {
                this.stop(newConfiguration);
                this.unload(newConfiguration);
            }
            configuration = null;
            try {
                this.reloadingConfiguration = configuration = this.load(existingUnloadedConfiguration.getConfigurationData(), existingUnloadedConfiguration.getResolvedParentIds(), Collections.EMPTY_MAP);
                if (started.contains(existingConfigurationId)) {
                    this.start(configuration);
                    results.addStarted(existingConfigurationId);
                }
                results.addLoaded(existingConfigurationId);
                this.configurations.put(existingConfigurationId, configuration);
                reinstatedExisting = true;
            }
            catch (Exception ignored) {
                monitor.failed(existingConfigurationId, e);
                if (configuration != null) {
                    this.unload(configuration);
                }
                Iterator iterator5 = results.getUnloaded().iterator();
                while (iterator5.hasNext()) {
                    Artifact childId = (Artifact)iterator5.next();
                    this.configurationModel.unload(childId);
                    this.removeConfigurationFromModel(childId);
                }
                throw new LifecycleException("reload", newConfigurationId, results);
            }
        }
        finally {
            this.reloadingConfiguration = null;
        }
        HashSet<Artifact> skip = new HashSet<Artifact>();
        Iterator iterator6 = reloadChildren.entrySet().iterator();
        while (iterator6.hasNext()) {
            Map.Entry entry = iterator6.next();
            configurationId = (Artifact)entry.getKey();
            UnloadedConfiguration unloadedConfiguration = (UnloadedConfiguration)entry.getValue();
            if (skip.contains(configurationId)) continue;
            configuration = null;
            try {
                LinkedHashSet resolvedParentIds = !reinstatedExisting ? unloadedConfiguration.getResolvedParentIds() : (LinkedHashSet)existingParents.get(configurationId);
                if (resolvedParentIds != null) {
                    monitor.loading(configurationId);
                    this.reloadingConfiguration = configuration = this.load(unloadedConfiguration.getConfigurationData(), resolvedParentIds, Collections.EMPTY_MAP);
                    monitor.succeeded(configurationId);
                    if (started.contains(configurationId)) {
                        monitor.starting(configurationId);
                        this.start(configuration);
                        monitor.succeeded(configurationId);
                        results.addStarted(configurationId);
                    }
                    results.addLoaded(configurationId);
                    this.configurations.put(configurationId, configuration);
                    continue;
                }
                this.removeConfigurationFromModel(configurationId);
            }
            catch (Exception e) {
                results.addFailed(configurationId, e);
                monitor.failed(configurationId, e);
                skip.add(configurationId);
                if (configuration != null) {
                    this.unload(configuration);
                }
                LinkedHashSet unloadList = this.configurationModel.unload(configurationId, false);
                this.configurationModel.removeConfiguration(configurationId);
                if (!reloadChildren.keySet().containsAll(unloadList)) {
                    throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                }
                Iterator iterator1 = unloadList.iterator();
                while (iterator1.hasNext()) {
                    Artifact failedId = (Artifact)iterator1.next();
                    if (results.wasLoaded(failedId)) {
                        throw new AssertionError((Object)"Configuration data model is corrupt.   You must restart your server.");
                    }
                    skip.add(failedId);
                }
            }
            finally {
                this.reloadingConfiguration = null;
            }
        }
        if (!results.wasLoaded(existingConfigurationId) && !results.wasFailed(existingConfigurationId)) {
            try {
                this.uninstallConfiguration(existingConfigurationId);
            }
            catch (IOException e) {
                log.error((Object)("Unable to uninstall configuration " + existingConfigurationId), (Throwable)e);
            }
        }
        monitor.finished();
        if (results.wasFailed(newConfigurationId) || !results.wasLoaded(newConfigurationId)) {
            throw new LifecycleException("restart", newConfigurationId, results);
        }
        return results;
    }

    protected void migrateConfiguration(Artifact oldName, Artifact newName, Configuration configuration, boolean running) throws NoSuchConfigException {
    }

    private static LinkedHashSet getResolvedParentIds(Configuration configuration) {
        LinkedHashSet<Artifact> resolvedParentIds = new LinkedHashSet<Artifact>();
        Iterator iterator = configuration.getClassParents().iterator();
        while (iterator.hasNext()) {
            Configuration classParent = (Configuration)iterator.next();
            resolvedParentIds.add(classParent.getId());
        }
        iterator = configuration.getServiceParents().iterator();
        while (iterator.hasNext()) {
            Configuration serviceParent = (Configuration)iterator.next();
            resolvedParentIds.add(serviceParent.getId());
        }
        iterator = configuration.getChildren().iterator();
        while (iterator.hasNext()) {
            Configuration child = (Configuration)iterator.next();
            resolvedParentIds.addAll(SimpleConfigurationManager.getResolvedParentIds(child));
        }
        return resolvedParentIds;
    }

    public synchronized void uninstallConfiguration(Artifact configurationId) throws IOException, NoSuchConfigException {
        if (!configurationId.isResolved()) {
            throw new IllegalArgumentException("Artifact " + configurationId + " is not fully resolved");
        }
        if (this.configurations.containsKey(configurationId)) {
            if (this.isRunning(configurationId)) {
                this.stopConfiguration(configurationId);
            }
            if (this.isLoaded(configurationId)) {
                this.unloadConfiguration(configurationId);
            }
        }
        List storeSnapshot = this.getStoreList();
        for (int i = 0; i < storeSnapshot.size(); ++i) {
            ConfigurationStore store = (ConfigurationStore)storeSnapshot.get(i);
            if (!store.containsConfiguration(configurationId)) continue;
            store.uninstall(configurationId);
        }
        this.removeConfigurationFromModel(configurationId);
        this.notifyWatchers(configurationId);
    }

    private void notifyWatchers(Artifact id) {
        Iterator it = this.watchers.iterator();
        while (it.hasNext()) {
            DeploymentWatcher watcher = (DeploymentWatcher)it.next();
            watcher.undeployed(id);
        }
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public boolean isOnline() {
        return false;
    }

    public void setOnline(boolean online) {
    }

    private List getStoreList() {
        return new ArrayList(this.stores);
    }

    private static void addConfigurationsToMonitor(LifecycleMonitor monitor, LinkedHashSet configurations) {
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            Artifact configurationId = (Artifact)iterator.next();
            monitor.addConfiguration(configurationId);
        }
    }

    private static LinkedHashSet reverse(LinkedHashSet set) {
        ArrayList reverseList = new ArrayList(set);
        Collections.reverse(reverseList);
        set = new LinkedHashSet(reverseList);
        return set;
    }

    private static LinkedHashMap reverse(LinkedHashMap map) {
        ArrayList reverseEntrySet = new ArrayList(map.entrySet());
        Collections.reverse(reverseEntrySet);
        map = new LinkedHashMap(reverseEntrySet.size());
        Iterator iterator = reverseEntrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            map.put(key, value);
        }
        return map;
    }

    private static class UnloadedConfiguration {
        private final ConfigurationData configurationData;
        private final LinkedHashSet resolvedParentIds;

        public UnloadedConfiguration(ConfigurationData configurationData, LinkedHashSet resolvedParentIds) {
            this.configurationData = configurationData;
            this.resolvedParentIds = resolvedParentIds;
        }

        public ConfigurationData getConfigurationData() {
            return this.configurationData;
        }

        public LinkedHashSet getResolvedParentIds() {
            return this.resolvedParentIds;
        }
    }
}

