/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.kernel.repository.Artifact;

public class LifecycleResults
implements Serializable {
    private static final long serialVersionUID = 4660197333193740244L;
    private final Set loaded = new LinkedHashSet();
    private final Set unloaded = new LinkedHashSet();
    private final Set started = new LinkedHashSet();
    private final Set stopped = new LinkedHashSet();
    private final Map failed = new LinkedHashMap();

    public boolean wasLoaded(Artifact configurationId) {
        return this.loaded.contains(configurationId);
    }

    public Set getLoaded() {
        return Collections.unmodifiableSet(this.loaded);
    }

    public void addLoaded(Artifact configurationId) {
        this.loaded.add(configurationId);
    }

    public void setLoaded(Set loaded) {
        this.loaded.clear();
        this.loaded.addAll(loaded);
    }

    public boolean wasUnloaded(Artifact configurationId) {
        return this.unloaded.contains(configurationId);
    }

    public Set getUnloaded() {
        return Collections.unmodifiableSet(this.unloaded);
    }

    public void addUnloaded(Artifact configurationId) {
        this.unloaded.add(configurationId);
    }

    public void setUnloaded(Set unloaded) {
        this.unloaded.clear();
        this.unloaded.addAll(unloaded);
    }

    public boolean wasStarted(Artifact configurationId) {
        return this.started.contains(configurationId);
    }

    public Set getStarted() {
        return Collections.unmodifiableSet(this.started);
    }

    public void addStarted(Artifact configurationId) {
        this.started.add(configurationId);
    }

    public void setStarted(Set started) {
        this.started.clear();
        this.started.addAll(started);
    }

    public boolean wasStopped(Artifact configurationId) {
        return this.stopped.contains(configurationId);
    }

    public Set getStopped() {
        return Collections.unmodifiableSet(this.stopped);
    }

    public void addStopped(Artifact configurationId) {
        this.stopped.add(configurationId);
    }

    public void setStopped(Set stopped) {
        this.stopped.clear();
        this.stopped.addAll(stopped);
    }

    public boolean wasFailed(Artifact configurationId) {
        Iterator it = this.failed.keySet().iterator();
        while (it.hasNext()) {
            Artifact failID = (Artifact)it.next();
            if (!configurationId.matches(failID)) continue;
            return true;
        }
        return false;
    }

    public Throwable getFailedCause(Artifact configurationId) {
        return (Throwable)this.failed.get(configurationId);
    }

    public Map getFailed() {
        return Collections.unmodifiableMap(this.failed);
    }

    public void addFailed(Artifact configurationId, Throwable cause) {
        this.failed.put(configurationId, cause);
    }

    public void setFailed(Map failed) {
        this.failed.clear();
        this.failed.putAll(failed);
    }
}

