/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.geronimo.kernel.classloader.AbstractUrlResourceLocation;
import org.apache.geronimo.kernel.classloader.IoUtil;
import org.apache.geronimo.kernel.classloader.JarResourceHandle;
import org.apache.geronimo.kernel.classloader.ResourceHandle;

public class JarResourceLocation
extends AbstractUrlResourceLocation {
    private final JarFile jarFile;

    public JarResourceLocation(URL codeSource, JarFile jarFile) {
        super(codeSource);
        this.jarFile = jarFile;
    }

    public ResourceHandle getResourceHandle(String resourceName) {
        JarEntry jarEntry = this.jarFile.getJarEntry(resourceName);
        if (jarEntry != null) {
            try {
                URL url = new URL(this.getCodeSource(), resourceName);
                return new JarResourceHandle(this.jarFile, jarEntry, this.getCodeSource());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    public void close() {
        IoUtil.close(this.jarFile);
    }
}

