/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.runtime.LifecycleBroadcaster;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;

public class BasicLifecycleMonitor
implements LifecycleMonitor {
    private static final Log log = LogFactory.getLog((Class)BasicLifecycleMonitor.class);
    private final Map boundListeners = new HashMap();
    private final Map listenerPatterns = new HashMap();

    public BasicLifecycleMonitor(Kernel kernel) {
        Set names = kernel.listGBeans((AbstractNameQuery)null);
        Iterator objectNameIterator = names.iterator();
        while (objectNameIterator.hasNext()) {
            GBeanData gBeanData;
            AbstractName source = (AbstractName)objectNameIterator.next();
            try {
                gBeanData = kernel.getGBeanData(source);
            }
            catch (GBeanNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            this.addSource(source, gBeanData.getGBeanInfo().getInterfaces());
        }
    }

    public synchronized void destroy() {
        this.boundListeners.clear();
        this.listenerPatterns.clear();
    }

    private synchronized void addSource(AbstractName source, Set interfaceTypes) {
        if (this.boundListeners.containsKey(source)) {
            return;
        }
        SourceInfo sourceInfo = new SourceInfo(interfaceTypes);
        HashSet listeners = sourceInfo.getListeners();
        Iterator listenerIterator = this.listenerPatterns.entrySet().iterator();
        while (listenerIterator.hasNext()) {
            Map.Entry entry = listenerIterator.next();
            Set patterns = (Set)entry.getValue();
            Iterator patternIterator = patterns.iterator();
            while (patternIterator.hasNext()) {
                AbstractNameQuery pattern = (AbstractNameQuery)patternIterator.next();
                if (!pattern.matches(source, interfaceTypes)) continue;
                LifecycleListener listener = (LifecycleListener)entry.getKey();
                listeners.add(listener);
            }
        }
        this.boundListeners.put(source, sourceInfo);
    }

    private synchronized void removeSource(AbstractName source) {
        this.boundListeners.remove(source);
    }

    public synchronized void addLifecycleListener(LifecycleListener listener, AbstractNameQuery pattern) {
        this.addLifecycleListener(listener, Collections.singleton(pattern));
    }

    public synchronized void addLifecycleListener(LifecycleListener listener, Set patterns) {
        Iterator patternIterator = patterns.iterator();
        while (patternIterator.hasNext()) {
            AbstractNameQuery pattern = (AbstractNameQuery)patternIterator.next();
            Iterator iterator = this.boundListeners.entrySet().iterator();
            while (iterator.hasNext()) {
                SourceInfo sourceInfo;
                Map.Entry entry = iterator.next();
                AbstractName source = (AbstractName)entry.getKey();
                if (!pattern.matches(source, (sourceInfo = (SourceInfo)entry.getValue()).getInterfaceTypes())) continue;
                HashSet listeners = sourceInfo.getListeners();
                listeners.add(listener);
            }
        }
        this.listenerPatterns.put(listener, patterns);
    }

    public synchronized void removeLifecycleListener(LifecycleListener listener) {
        Iterator iterator = this.boundListeners.values().iterator();
        while (iterator.hasNext()) {
            SourceInfo sourceInfo = (SourceInfo)iterator.next();
            sourceInfo.getListeners().remove(listener);
        }
        this.listenerPatterns.remove(listener);
    }

    private synchronized Set getTargets(AbstractName source) {
        SourceInfo targets = (SourceInfo)this.boundListeners.get(source);
        if (targets == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(targets.getListeners());
    }

    private void fireLoadedEvent(AbstractName refInfoName) {
        Set targets = this.getTargets(refInfoName);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.loaded(refInfoName);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStartingEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.starting(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireRunningEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.running(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppingEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.stopping(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireStoppedEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.stopped(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireFailedEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.failed(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    private void fireUnloadedEvent(AbstractName source) {
        Set targets = this.getTargets(source);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            LifecycleListener listener = (LifecycleListener)iterator.next();
            try {
                listener.unloaded(source);
            }
            catch (Throwable e) {
                log.warn((Object)"Exception occured while notifying listener", e);
            }
        }
    }

    public LifecycleBroadcaster createLifecycleBroadcaster(AbstractName abstractName, Set interfaceTypes) {
        return new RawLifecycleBroadcaster(abstractName, interfaceTypes);
    }

    private final class SourceInfo {
        private final Set interfaceTypes;
        private final HashSet listeners = new HashSet();

        public SourceInfo(Set interfaceTypes) {
            this.interfaceTypes = interfaceTypes;
        }

        public Set getInterfaceTypes() {
            return this.interfaceTypes;
        }

        public HashSet getListeners() {
            return this.listeners;
        }
    }

    private class RawLifecycleBroadcaster
    implements LifecycleBroadcaster {
        private final AbstractName abstractName;
        private final Set interfaceTypes;

        public RawLifecycleBroadcaster(AbstractName abstractName, Set interfaceTypes) {
            this.abstractName = abstractName;
            this.interfaceTypes = interfaceTypes;
        }

        public void fireLoadedEvent() {
            BasicLifecycleMonitor.this.addSource(this.abstractName, this.interfaceTypes);
            BasicLifecycleMonitor.this.fireLoadedEvent(this.abstractName);
        }

        public void fireStartingEvent() {
            BasicLifecycleMonitor.this.fireStartingEvent(this.abstractName);
        }

        public void fireRunningEvent() {
            BasicLifecycleMonitor.this.fireRunningEvent(this.abstractName);
        }

        public void fireStoppingEvent() {
            BasicLifecycleMonitor.this.fireStoppingEvent(this.abstractName);
        }

        public void fireStoppedEvent() {
            BasicLifecycleMonitor.this.fireStoppedEvent(this.abstractName);
        }

        public void fireFailedEvent() {
            BasicLifecycleMonitor.this.fireFailedEvent(this.abstractName);
        }

        public void fireUnloadedEvent() {
            BasicLifecycleMonitor.this.fireUnloadedEvent(this.abstractName);
            BasicLifecycleMonitor.this.removeSource(this.abstractName);
        }
    }
}

