/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.KernelFactoryError;
import org.apache.geronimo.kernel.basic.BasicKernelFactory;

public abstract class KernelFactory {
    public static final String KERNEL_FACTORY_KEY = KernelFactory.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KernelFactory newInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = KernelFactory.class.getClassLoader();
        }
        try {
            String kernelFactoryName = System.getProperty(KERNEL_FACTORY_KEY);
            if (kernelFactoryName != null) {
                return KernelFactory.createKernelFactory(kernelFactoryName, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + KERNEL_FACTORY_KEY;
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(serviceId);
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String kernelFactoryName = reader.readLine();
                reader.close();
                if (kernelFactoryName != null && kernelFactoryName.length() > 0) {
                    KernelFactory kernelFactory = KernelFactory.createKernelFactory(kernelFactoryName, classLoader);
                    return kernelFactory;
                }
            }
        }
        catch (Exception ignored) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {}
                inputStream = null;
            }
        }
        return new BasicKernelFactory();
    }

    private static KernelFactory createKernelFactory(String className, ClassLoader classLoader) {
        try {
            return (KernelFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassCastException e) {
            throw new KernelFactoryError("Kernel factory class does not implement KernelFactory: " + className);
        }
        catch (ClassNotFoundException e) {
            throw new KernelFactoryError("Kernel factory class not found: " + className);
        }
        catch (Exception e) {
            throw new KernelFactoryError("Unable to instantiate kernel factory class: " + className, e);
        }
    }

    public abstract Kernel createKernel(String var1);
}

