/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;

public class GBeanData
implements Externalizable {
    private static final long serialVersionUID = -1012491431781444074L;
    private Externalizable[] backwardExternalizables = new Externalizable[]{new V0Externalizable(), new V1Externalizable()};
    private GBeanInfo gbeanInfo;
    private final Map attributes;
    private final Map references;
    private final Set dependencies;
    private AbstractName abstractName;
    private int priority;

    public GBeanData() {
        this.attributes = new HashMap();
        this.references = new HashMap();
        this.dependencies = new HashSet();
    }

    public GBeanData(GBeanInfo gbeanInfo) {
        this();
        this.setGBeanInfo(gbeanInfo);
    }

    public GBeanData(AbstractName abstractName, GBeanInfo gbeanInfo) {
        this();
        this.abstractName = abstractName;
        this.setGBeanInfo(gbeanInfo);
    }

    public GBeanData(GBeanData gbeanData) {
        this.setGBeanInfo(gbeanData.gbeanInfo);
        this.attributes = new HashMap(gbeanData.attributes);
        this.references = new HashMap(gbeanData.references);
        this.dependencies = new HashSet(gbeanData.dependencies);
        this.abstractName = gbeanData.abstractName;
    }

    public AbstractName getAbstractName() {
        return this.abstractName;
    }

    public void setAbstractName(AbstractName abstractName) {
        this.abstractName = abstractName;
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    public void clearAttribute(String name) {
        this.attributes.remove(name);
    }

    public void clearReference(String name) {
        this.references.remove(name);
    }

    public void setGBeanInfo(GBeanInfo gbeanInfo) {
        this.gbeanInfo = gbeanInfo;
        this.priority = gbeanInfo == null ? 5 : gbeanInfo.getPriority();
    }

    public Map getAttributes() {
        return new HashMap(this.attributes);
    }

    public Set getAttributeNames() {
        return new HashSet(this.attributes.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map getReferences() {
        return new HashMap(this.references);
    }

    public Set getReferencesNames() {
        return new HashSet(this.references.keySet());
    }

    public ReferencePatterns getReferencePatterns(String name) {
        return (ReferencePatterns)this.references.get(name);
    }

    public void setReferencePattern(String name, AbstractNameQuery pattern) {
        this.setReferencePatterns(name, Collections.singleton(pattern));
    }

    public void setReferencePattern(String name, AbstractName abstractName) {
        this.setReferencePatterns(name, new ReferencePatterns(abstractName));
    }

    public void setReferencePatterns(String name, Set patterns) {
        this.setReferencePatterns(name, new ReferencePatterns(patterns));
    }

    public void setReferencePatterns(String name, ReferencePatterns patterns) {
        this.references.put(name, patterns);
    }

    public Set getDependencies() {
        return new HashSet(this.dependencies);
    }

    public void setDependencies(Set dependencies) {
        this.dependencies.clear();
        this.addDependencies(dependencies);
    }

    public void addDependencies(Set dependencies) {
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            Object dependency = iterator.next();
            if (dependency instanceof AbstractName) {
                AbstractName name = (AbstractName)dependency;
                this.addDependency(name);
                continue;
            }
            if (dependency instanceof AbstractNameQuery) {
                AbstractNameQuery nameQuery = (AbstractNameQuery)dependency;
                this.addDependency(nameQuery);
                continue;
            }
            if (dependency instanceof ReferencePatterns) {
                ReferencePatterns referencePatterns = (ReferencePatterns)dependency;
                this.addDependency(referencePatterns);
                continue;
            }
            throw new IllegalArgumentException("Unknown dependency type: " + dependency);
        }
    }

    public void addDependency(ReferencePatterns dependency) {
        this.dependencies.add(dependency);
    }

    public void addDependency(AbstractNameQuery refInfo) {
        this.dependencies.add(new ReferencePatterns(refInfo));
    }

    public void addDependency(AbstractName dependency) {
        this.dependencies.add(new ReferencePatterns(dependency));
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object value;
        String name;
        Map.Entry entry;
        out.writeObject(new Integer(this.backwardExternalizables.length - 1));
        out.writeObject(this.gbeanInfo);
        out.writeObject(this.abstractName);
        out.writeInt(this.priority);
        out.writeInt(this.attributes.size());
        Iterator iterator = this.attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            value = entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write attribute: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
            catch (NoClassDefFoundError e) {
                throw (IOException)new IOException("Unable to write attribute: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
        }
        out.writeInt(this.references.size());
        iterator = this.references.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            name = (String)entry.getKey();
            value = (ReferencePatterns)entry.getValue();
            try {
                out.writeObject(name);
                out.writeObject(value);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write reference pattern: " + name + " in gbean: " + this.abstractName).initCause(e);
            }
        }
        out.writeInt(this.dependencies.size());
        iterator = this.dependencies.iterator();
        while (iterator.hasNext()) {
            ReferencePatterns referencePatterns = (ReferencePatterns)((Object)iterator.next());
            try {
                out.writeObject(referencePatterns);
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to write dependency pattern in gbean: " + this.abstractName).initCause(e);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object opaque = in.readObject();
        if (opaque instanceof Integer) {
            this.backwardExternalizables[(Integer)opaque].readExternal(in);
        } else {
            this.gbeanInfo = (GBeanInfo)opaque;
            this.backwardExternalizables[0].readExternal(in);
        }
    }

    private class V1Externalizable
    extends V0Externalizable {
        private V1Externalizable() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected void readGBeanInfo(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.gbeanInfo = (GBeanInfo)in.readObject();
        }

        protected void readPriority(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.priority = in.readInt();
        }
    }

    private class V0Externalizable
    implements Externalizable {
        private V0Externalizable() {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readGBeanInfo(in);
            try {
                GBeanData.this.abstractName = (AbstractName)in.readObject();
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to deserialize AbstractName for GBeanData of type " + GBeanData.this.gbeanInfo.getClassName()).initCause(e);
            }
            this.readPriority(in);
            try {
                int attributeCount = in.readInt();
                for (int i = 0; i < attributeCount; ++i) {
                    Object attributeValue;
                    String attributeName = (String)in.readObject();
                    try {
                        attributeValue = in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName + ", attribute: " + attributeName, e);
                    }
                    catch (IOException e) {
                        throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName + ", attribute: " + attributeName).initCause(e);
                    }
                    GBeanData.this.setAttribute(attributeName, attributeValue);
                }
                int endpointCount = in.readInt();
                for (int i = 0; i < endpointCount; ++i) {
                    ReferencePatterns referencePattern;
                    String referenceName = (String)in.readObject();
                    try {
                        referencePattern = (ReferencePatterns)in.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName + ", reference: " + referenceName, e);
                    }
                    catch (IOException e) {
                        throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName + ", reference: " + referenceName).initCause(e);
                    }
                    GBeanData.this.setReferencePatterns(referenceName, referencePattern);
                }
                int dependencyCount = in.readInt();
                for (int i = 0; i < dependencyCount; ++i) {
                    ReferencePatterns depdendencyPattern = (ReferencePatterns)in.readObject();
                    GBeanData.this.dependencies.add(depdendencyPattern);
                }
            }
            catch (IOException e) {
                throw (IOException)new IOException("Unable to deserialize GBeanData " + GBeanData.this.abstractName).initCause(e);
            }
            catch (ClassNotFoundException e) {
                throw new ClassNotFoundException("Unable to find class used in GBeanData " + GBeanData.this.abstractName, e);
            }
        }

        protected void readGBeanInfo(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        protected void readPriority(ObjectInput in) throws IOException, ClassNotFoundException {
            GBeanData.this.priority = 5;
        }
    }

    public static class PriorityComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof GBeanData && o2 instanceof GBeanData) {
                return ((GBeanData)o1).priority - ((GBeanData)o2).priority;
            }
            return 0;
        }
    }
}

