/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.servlet.ServletHandler;

public class EJBServletHandler
extends ServletHandler {
    private final WebServiceContainer webServiceContainer;

    public EJBServletHandler(WebServiceContainer webServiceContainer) {
        this.webServiceContainer = webServiceContainer;
    }

    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._nextScope != null) {
            this._nextScope.doScope(target, baseRequest, request, response);
        } else if (this._outerScope != null) {
            this._outerScope.doHandle(target, baseRequest, request, response);
        } else {
            this.doHandle(target, baseRequest, request, response);
        }
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Response jettyResponse = (Response)res;
        res.setContentType("text/xml");
        RequestAdapter request = new RequestAdapter(baseRequest);
        ResponseAdapter response = new ResponseAdapter(jettyResponse);
        request.setAttribute(WebServiceContainer.SERVLET_REQUEST, req);
        request.setAttribute(WebServiceContainer.SERVLET_RESPONSE, res);
        request.setAttribute(WebServiceContainer.SERVLET_CONTEXT, null);
        if (this.isWSDLRequest(req)) {
            try {
                this.webServiceContainer.getWsdl((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                baseRequest.setHandled(true);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (HttpException)new HttpException(500, "Could not fetch wsdl!").initCause((Throwable)e);
            }
        }
        try {
            this.webServiceContainer.invoke((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
            baseRequest.setHandled(true);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw (HttpException)new HttpException(500, "Could not process message!").initCause((Throwable)e);
        }
    }

    private boolean isWSDLRequest(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) && (req.getParameter("wsdl") != null || req.getParameter("xsd") != null);
    }

    public static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final Response response;

        public ResponseAdapter(Response response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }

        public OutputStream getOutputStream() {
            try {
                return this.response.getOutputStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.response.getStatus(), responseString);
        }

        public void flushBuffer() throws IOException {
            this.response.flushBuffer();
        }
    }

    public static class RequestAdapter
    implements WebServiceContainer.Request {
        private final Request request;
        private URI uri;
        private static final Map<String, Integer> methods = new HashMap<String, Integer>();

        public RequestAdapter(Request request) {
            this.request = request;
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public URI getURI() {
            if (this.uri == null) {
                try {
                    this.uri = new URI(this.request.getScheme(), null, this.request.getServerName(), this.request.getServerPort(), this.request.getRequestURI(), this.request.getQueryString(), null);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            return this.uri;
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public int getMethod() {
            Integer method = methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map getParameters() {
            return this.request.getParameterMap();
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public String getContextPath() {
            return this.request.getRequestURI();
        }

        static {
            methods.put("OPTIONS", 0);
            methods.put("GET", 1);
            methods.put("HEAD", 2);
            methods.put("POST", 3);
            methods.put("PUT", 4);
            methods.put("DELETE", 5);
            methods.put("TRACE", 6);
            methods.put("CONNECT", 7);
        }
    }
}

