/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.handler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.jetty.util.resource.Resource;

public class BundlePathResource
extends Resource {
    private URL url;
    private String[] resources;

    public BundlePathResource(URL url, Enumeration<String> paths) {
        this.url = url;
        String baseName = BundlePathResource.removeSlash(url.getPath());
        ArrayList<String> list = new ArrayList<String>();
        while (paths.hasMoreElements()) {
            String path = BundlePathResource.getRelativeName(baseName, paths.nextElement());
            list.add(path);
        }
        this.resources = list.toArray(new String[list.size()]);
    }

    private static String removeSlash(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    private static String getRelativeName(String base, String name) {
        if (base != null && name.startsWith(base)) {
            return name.substring(base.length());
        }
        return name;
    }

    public boolean exists() {
        return true;
    }

    public boolean isDirectory() {
        return true;
    }

    public long lastModified() {
        return -1L;
    }

    public long length() {
        return -1L;
    }

    public String[] list() {
        return this.resources;
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    public void release() {
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(new byte[0]);
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() throws IOException {
        return null;
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new IOException("Output not supported");
    }

    public boolean delete() throws SecurityException {
        throw new SecurityException("Delete not supported");
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new SecurityException("RenameTo not supported");
    }

    public Resource addPath(String arg0) throws IOException, MalformedURLException {
        return null;
    }

    public boolean isContainedIn(Resource arg0) throws MalformedURLException {
        return false;
    }
}

