/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.OsgiService;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.jetty8.JettyContainer;
import org.apache.geronimo.jetty8.handler.EJBServletHandler;
import org.apache.geronimo.jetty8.handler.EJBWebServiceContext;
import org.apache.geronimo.jetty8.security.BuiltInAuthMethod;
import org.apache.geronimo.jetty8.security.JettySecurityHandlerFactory;
import org.apache.geronimo.management.LazyStatisticsProvider;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.management.geronimo.stats.JettyWebContainerStatsImpl;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

@GBean
@OsgiService(serviceInterfaces={"org.eclipse.jetty.server.handler.ContextHandlerCollection"})
public class JettyContainerImpl
implements JettyContainer,
SoapHandler,
GBeanLifecycle,
LazyStatisticsProvider,
ServiceFactory {
    private static final String DEFAULT_JETTY_HOME = "var/jetty";
    private final Server server;
    private final Map<String, EJBWebServiceContext> webServices = new HashMap<String, EJBWebServiceContext>();
    private final String objectName;
    private final BundleContext bundleContext;
    private final WebManager manager;
    private final String jettyHome;
    private final ServerInfo serverInfo;
    private File jettyHomeDir;
    private JettyWebContainerStatsImpl stats;
    private StatisticsHandler statsHandler = new StatisticsHandler();
    private ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
    private RequestLogHandler requestLogHandler = new RequestLogHandler();
    private boolean statsOn = false;

    public JettyContainerImpl(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext, @ParamReference(name="WebManager") WebManager manager, @ParamAttribute(name="jettyHome") String jettyHome, @ParamReference(name="ServerInfo") ServerInfo serverInfo) {
        this.objectName = objectName;
        this.bundleContext = bundleContext;
        this.jettyHome = jettyHome;
        this.serverInfo = serverInfo;
        this.server = new Server();
        DefaultHandler defaultHandler = new DefaultHandler();
        Handler[] handlers = new Handler[]{this.contextHandlerCollection, defaultHandler, this.requestLogHandler, this.statsHandler};
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(handlers);
        this.server.setHandler((Handler)handlerCollection);
        this.stats = new JettyWebContainerStatsImpl();
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    @Override
    public void resetStats() {
        this.statsHandler.statsReset();
        this.stats.setStartTime();
    }

    @Override
    public long getCollectStatisticsStarted() {
        return this.statsHandler.getStatsOnMs();
    }

    @Override
    public boolean isStatsOn() {
        return this.statsOn;
    }

    @Override
    public void setStatsOn(boolean on) {
        try {
            if (on) {
                this.resetStats();
                this.statsHandler.start();
            } else {
                this.statsHandler.stop();
            }
            this.statsOn = on;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Stats getStats() {
        if (this.isStatsOn()) {
            this.stats.setLastSampleTime();
            this.stats.getActiveRequestCountImpl().setCurrent((long)this.statsHandler.getRequestsActive());
            this.stats.getActiveRequestCountImpl().setHighWaterMark((long)this.statsHandler.getRequestsActiveMax());
            this.stats.getRequestDurationImpl().setCount((long)this.statsHandler.getRequests());
            this.stats.getResponses1xxImpl().setCount((long)this.statsHandler.getResponses1xx());
            this.stats.getResponses2xxImpl().setCount((long)this.statsHandler.getResponses2xx());
            this.stats.getResponses3xxImpl().setCount((long)this.statsHandler.getResponses3xx());
            this.stats.getResponses4xxImpl().setCount((long)this.statsHandler.getResponses4xx());
            this.stats.getResponses5xxImpl().setCount((long)this.statsHandler.getResponses5xx());
            this.stats.getStatsOnMsImpl().setCount(this.statsHandler.getStatsOnMs());
        }
        return this.stats;
    }

    @Override
    public void addListener(Connector listener) {
        this.server.addConnector(listener);
    }

    @Override
    public void removeListener(Connector listener) {
        this.server.removeConnector(listener);
    }

    @Override
    public void addContext(Handler context) {
        this.contextHandlerCollection.addHandler(context);
    }

    @Override
    public void removeContext(Handler context) {
        this.contextHandlerCollection.removeHandler(context);
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String contextID, ConfigurationFactory configurationFactory, String realmName, String authMethod, Properties properties, ClassLoader classLoader) throws Exception {
        SecurityHandler securityHandler = null;
        if (configurationFactory != null) {
            BuiltInAuthMethod builtInAuthMethod = BuiltInAuthMethod.getValueOf(authMethod);
            JettySecurityHandlerFactory factory = new JettySecurityHandlerFactory(builtInAuthMethod, null, null, realmName, configurationFactory);
            securityHandler = factory.buildSecurityHandler(contextID, null, null, false);
        }
        EJBServletHandler servletHandler = new EJBServletHandler(webServiceContainer);
        EJBWebServiceContext webServiceContext = new EJBWebServiceContext(contextPath, securityHandler, servletHandler, classLoader);
        webServiceContext.setVirtualHosts(virtualHosts);
        this.addContext((Handler)webServiceContext);
        webServiceContext.start();
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        EJBWebServiceContext webServiceContext = this.webServices.remove(contextPath);
        try {
            this.removeContext((Handler)webServiceContext);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public void setRequestLog(RequestLog log) {
        this.requestLogHandler.setRequestLog(log);
    }

    @Override
    public File resolveToJettyHome(String workDir) {
        if (workDir == null) {
            return null;
        }
        return new File(this.jettyHomeDir, workDir);
    }

    @Override
    public RequestLog getRequestLog() {
        return this.requestLogHandler.getRequestLog();
    }

    public void doStart() throws Exception {
        this.jettyHomeDir = new File(this.serverInfo.resolveServerPath(this.jettyHome != null ? this.jettyHome : DEFAULT_JETTY_HOME));
        if (!this.jettyHomeDir.exists()) {
            this.jettyHomeDir.mkdirs();
        }
        this.server.start();
    }

    public void doStop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFail() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Object getService(Bundle bundle, ServiceRegistration serviceRegistration) {
        return this.contextHandlerCollection;
    }

    public void ungetService(Bundle bundle, ServiceRegistration serviceRegistration, Object o) {
    }
}

