/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.security;

import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty8.handler.JaccSecurityHandler;
import org.apache.geronimo.jetty8.security.JettyIdentityService;
import org.apache.geronimo.jetty8.security.SecurityHandlerFactory;
import org.apache.geronimo.jetty8.security.auth.GeronimoJaspiAuthenticator;
import org.apache.geronimo.jetty8.security.auth.JAASLoginService;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.security.jaspi.IdentityService;
import org.apache.geronimo.security.jaspi.LoginService;
import org.apache.geronimo.security.jaspi.impl.GeronimoLoginService;
import org.apache.geronimo.security.jaspi.impl.JaspicCallbackHandler;
import org.eclipse.jetty.security.SecurityHandler;

@GBean
public class AuthConfigProviderHandlerFactory
implements SecurityHandlerFactory {
    private static final String POLICY_CONTEXT_ID_KEY = "javax.security.jacc.PolicyContext";
    private final Map authConfigProperties = new HashMap();
    private final Subject serviceSubject = null;
    private final boolean allowLazyAuthentication;
    private final ConfigurationFactory configurationFactory;
    private final String messageLayer;
    private final String appContext;

    public AuthConfigProviderHandlerFactory(@ParamAttribute(name="messageLayer") String messageLayer, @ParamAttribute(name="appContext") String appContext, @ParamAttribute(name="allowLazyAuthentication") boolean allowLazyAuthentication, @ParamReference(name="ConfigurationFactory") ConfigurationFactory configurationFactory) throws AuthException {
        String appContext1 = appContext;
        this.allowLazyAuthentication = allowLazyAuthentication;
        this.configurationFactory = configurationFactory;
        this.messageLayer = messageLayer;
        this.appContext = appContext;
    }

    @Override
    public SecurityHandler buildSecurityHandler(String policyContextID, Subject defaultSubject, RunAsSource runAsSource, boolean checkRolePermissions) throws AuthException {
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        AccessControlContext defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null);
        JettyIdentityService identityService = new JettyIdentityService(defaultAcc, defaultSubject, runAsSource);
        GeronimoLoginService loginService = new GeronimoLoginService(this.configurationFactory, (IdentityService)identityService);
        this.authConfigProperties.put(POLICY_CONTEXT_ID_KEY, policyContextID);
        AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
        RegistrationListener listener = new RegistrationListener(){

            public void notify(String layer, String appContext) {
            }
        };
        AuthConfigProvider authConfigProvider = authConfigFactory.getConfigProvider(this.messageLayer, this.appContext, listener);
        JaspicCallbackHandler callbackHandler = new JaspicCallbackHandler((LoginService)loginService);
        ServerAuthConfig serverAuthConfig = authConfigProvider.getServerAuthConfig(this.messageLayer, this.appContext, (CallbackHandler)callbackHandler);
        GeronimoJaspiAuthenticator authenticator = new GeronimoJaspiAuthenticator(serverAuthConfig, this.authConfigProperties, (CallbackHandler)callbackHandler, this.serviceSubject, this.allowLazyAuthentication, identityService);
        return new JaccSecurityHandler(policyContextID, authenticator, new JAASLoginService(null, loginService), identityService, defaultAcc);
    }
}

