/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.security.auth.Subject;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.RuntimeCustomizer;
import org.apache.geronimo.j2ee.annotation.Holder;
import org.apache.geronimo.j2ee.jndi.ContextSource;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.jetty8.Host;
import org.apache.geronimo.jetty8.JettyContainer;
import org.apache.geronimo.jetty8.PreHandler;
import org.apache.geronimo.jetty8.PreHandlerFactory;
import org.apache.geronimo.jetty8.SessionHandlerFactory;
import org.apache.geronimo.jetty8.handler.GeronimoWebAppContext;
import org.apache.geronimo.jetty8.handler.IntegrationContext;
import org.apache.geronimo.jetty8.security.SecurityHandlerFactory;
import org.apache.geronimo.kernel.ObjectNameUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.openejb.cdi.OpenWebBeansWebInitializer;
import org.apache.geronimo.openejb.cdi.SharedOwbContext;
import org.apache.geronimo.security.jacc.ApplicationPolicyConfigurationManager;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.apache.geronimo.transaction.GeronimoUserTransaction;
import org.apache.geronimo.web.info.ErrorPageInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.webbeans.config.WebBeansContext;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(name="Jetty WebApplication Context", j2eeType="WebModule")
public class WebAppContextWrapper
implements GBeanLifecycle,
WebModule {
    private static final Logger log = LoggerFactory.getLogger(WebAppContextWrapper.class);
    public static final String GBEAN_ATTR_SESSION_TIMEOUT = "sessionTimeoutSeconds";
    public static final String GBEAN_REF_SESSION_HANDLER_FACTORY = "SessionHandlerFactory";
    public static final String GBEAN_REF_PRE_HANDLER_FACTORY = "PreHandlerFactory";
    private final String originalSpecDD;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ClassLoader webClassLoader;
    private final JettyContainer jettyContainer;
    private final String objectName;
    private final GeronimoWebAppContext webAppContext;
    private static final String JASPER_WEB_XML_NAME = "org.apache.tomcat.util.scan.MergedWebXml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppContextWrapper(@ParamSpecial(type=SpecialAttributeType.objectName) String objectName, @ParamSpecial(type=SpecialAttributeType.abstractName) AbstractName abName, @ParamAttribute(name="contextPath") String contextPath, @ParamAttribute(name="deploymentDescriptor") String originalSpecDD, @ParamAttribute(name="modulePath") String modulePath, @ParamSpecial(type=SpecialAttributeType.classLoader) ClassLoader classLoader, @ParamSpecial(type=SpecialAttributeType.bundle) Bundle bundle, @ParamAttribute(name="workDir") String workDir, @ParamAttribute(name="unshareableResources") Set<String> unshareableResources, @ParamAttribute(name="applicationManagedSecurityResources") Set<String> applicationManagedSecurityResources, @ParamAttribute(name="tagLibMap") Map<String, String> tagLibMap, @ParamAttribute(name="compactPath") boolean compactPath, @ParamReference(name="SessionHandlerFactory") SessionHandlerFactory handlerFactory, @ParamReference(name="PreHandlerFactory") PreHandlerFactory preHandlerFactory, @ParamAttribute(name="policyContextID") String policyContextID, @ParamReference(name="SecurityHandlerFactory") SecurityHandlerFactory securityHandlerFactory, @ParamReference(name="RunAsSource") RunAsSource runAsSource, @ParamReference(name="applicationPolicyConfigurationManager") ApplicationPolicyConfigurationManager applicationPolicyConfigurationManager, @ParamAttribute(name="holder") Holder holder, @ParamAttribute(name="webAppInfo") WebAppInfo webAppInfo, @ParamReference(name="Host") Host host, @ParamReference(name="TrackedConnectionAssociator") TrackedConnectionAssociator trackedConnectionAssociator, @ParamReference(name="JettyContainer") JettyContainer jettyContainer, @ParamReference(name="ContextCustomizer") RuntimeCustomizer contextCustomizer, @ParamReference(name="J2EEServer") J2EEServer server, @ParamReference(name="J2EEApplication") J2EEApplication application, @ParamReference(name="ContextSource") ContextSource contextSource, @ParamReference(name="TransactionManager") TransactionManager transactionManager, @ParamReference(name="SharedOwbContext") SharedOwbContext sharedOwbContext, @ParamAttribute(name="deploymentAttributes") Map<String, Object> deploymentAttributes) throws Exception {
        SessionHandler sessionHandler;
        RunAsSource runAsSource1;
        assert (contextSource != null);
        assert (classLoader != null);
        assert (trackedConnectionAssociator != null);
        assert (jettyContainer != null);
        if (contextPath == null || !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("context contextPath must be non-null and start with '/', not " + contextPath);
        }
        holder = holder == null ? Holder.EMPTY : holder;
        this.server = server;
        this.application = application;
        this.objectName = objectName;
        if (objectName != null) {
            ObjectName myObjectName = ObjectNameUtil.getObjectName((String)objectName);
            this.verifyObjectName(myObjectName);
        }
        this.jettyContainer = jettyContainer;
        this.originalSpecDD = originalSpecDD;
        RunAsSource runAsSource2 = runAsSource1 = runAsSource == null ? RunAsSource.NULL : runAsSource;
        if (null != handlerFactory) {
            if (null == preHandlerFactory) {
                throw new IllegalStateException("A preHandlerFactory must be set if an handler factory is set.");
            }
            PreHandler preHandler = preHandlerFactory.createHandler();
            sessionHandler = handlerFactory.createHandler(preHandler);
        } else {
            sessionHandler = new SessionHandler();
        }
        SecurityHandler securityHandler = null;
        if (securityHandlerFactory != null) {
            Subject defaultSubject = runAsSource1.getDefaultSubject();
            securityHandler = securityHandlerFactory.buildSecurityHandler(policyContextID, defaultSubject, runAsSource, true);
        }
        ServletHandler servletHandler = new ServletHandler();
        Context componentContext = contextSource.getContext();
        GeronimoUserTransaction userTransaction = new GeronimoUserTransaction(transactionManager);
        LinkedHashMap servletContainerInitializerMap = new LinkedHashMap();
        Map servletContainerInitializerClassNamesMap = (Map)deploymentAttributes.get("SERVLET_CONTAINER_INITIALIZERS");
        if (servletContainerInitializerClassNamesMap != null) {
            for (Map.Entry entry : servletContainerInitializerClassNamesMap.entrySet()) {
                String servletContainerInitializerClassName = (String)entry.getKey();
                Set classNames = (Set)entry.getValue();
                try {
                    ServletContainerInitializer servletContainerInitializer = (ServletContainerInitializer)bundle.loadClass(servletContainerInitializerClassName).newInstance();
                    if (classNames == null || classNames.size() == 0) {
                        servletContainerInitializerMap.put(servletContainerInitializer, null);
                        continue;
                    }
                    HashSet<Class> classSet = new HashSet<Class>();
                    for (String cls : classNames) {
                        try {
                            classSet.add(bundle.loadClass(cls));
                        }
                        catch (ClassNotFoundException e) {
                            log.warn("Fail to load class " + cls + " interested by ServletContainerInitializer " + servletContainerInitializerClassName, (Throwable)e);
                        }
                    }
                    servletContainerInitializerMap.put(servletContainerInitializer, classSet);
                }
                catch (IllegalAccessException illegalAccessException) {
                    log.error("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName, (Throwable)illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    log.error("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName, (Throwable)instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    log.error("Fail to initialize ServletContainerInitializer " + servletContainerInitializerClassName, (Throwable)classNotFoundException);
                }
            }
        }
        IntegrationContext integrationContext = new IntegrationContext(componentContext, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator, (UserTransaction)userTransaction, bundle, holder, servletContainerInitializerMap, abName.toString());
        this.webAppContext = new GeronimoWebAppContext(securityHandler, sessionHandler, servletHandler, null, integrationContext, classLoader, modulePath, webAppInfo, policyContextID, applicationPolicyConfigurationManager);
        this.webAppContext.setContextPath(contextPath);
        this.webAppContext.setCompactPath(compactPath);
        this.webAppContext.setWebModuleName(this.getWARName());
        if (workDir == null) {
            workDir = contextPath.replace('/', '_');
        }
        this.webAppContext.setTempDirectory(jettyContainer.resolveToJettyHome(workDir));
        if (contextCustomizer != null) {
            HashMap servletContext = new HashMap();
            HashMap<Class, Object> customizerContext = new HashMap<Class, Object>();
            customizerContext.put(Map.class, servletContext);
            customizerContext.put(Context.class, componentContext);
            contextCustomizer.customize(customizerContext);
            for (Map.Entry entry : servletContext.entrySet()) {
                this.webAppContext.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.setMimeMap((Map)webAppInfo.mimeMappings);
        this.webAppContext.setMimeTypes(mimeTypes);
        this.webAppContext.setConfigurationClasses(new String[0]);
        this.webClassLoader = classLoader;
        this.webAppContext.setClassLoader(this.webClassLoader);
        if (host != null) {
            this.webAppContext.setConnectorNames(host.getHosts());
            this.webAppContext.setVirtualHosts(host.getVirtualHosts());
        }
        this.webAppContext.setDisplayName(webAppInfo.displayName);
        this.webAppContext.getInitParams().putAll(webAppInfo.contextParams);
        this.webAppContext.setDistributable(webAppInfo.distributable);
        this.webAppContext.setWelcomeFiles(webAppInfo.welcomeFiles.toArray(new String[webAppInfo.welcomeFiles.size()]));
        for (Map.Entry entry : webAppInfo.localeEncodingMappings.entrySet()) {
            this.webAppContext.addLocaleEncoding((String)entry.getKey(), (String)entry.getValue());
        }
        ErrorPageErrorHandler errorHandler = (ErrorPageErrorHandler)this.webAppContext.getErrorHandler();
        for (ErrorPageInfo errorPageInfo : webAppInfo.errorPages) {
            if (errorPageInfo.exceptionType != null) {
                errorHandler.addErrorPage(errorPageInfo.exceptionType, errorPageInfo.location);
                continue;
            }
            errorHandler.addErrorPage(errorPageInfo.errorCode.intValue(), errorPageInfo.location);
        }
        if (tagLibMap != null) {
            for (Map.Entry<Object, Object> entry : tagLibMap.entrySet()) {
                this.webAppContext.setResourceAlias((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!webAppInfo.distributable && webAppInfo.sessionConfig != null) {
            SessionManager sessionManager = this.webAppContext.getSessionHandler().getSessionManager();
            if (webAppInfo.sessionConfig.sessionTimeoutMinutes != -1) {
                sessionManager.setMaxInactiveInterval(webAppInfo.sessionConfig.sessionTimeoutMinutes * 60);
            }
            sessionManager.setSessionTrackingModes((Set)webAppInfo.sessionConfig.sessionTrackingModes);
            if (webAppInfo.sessionConfig.sessionCookieConfig != null) {
                SessionCookieConfig sessionCookieConfig = sessionManager.getSessionCookieConfig();
                sessionCookieConfig.setName(webAppInfo.sessionConfig.sessionCookieConfig.name);
                sessionCookieConfig.setPath(webAppInfo.sessionConfig.sessionCookieConfig.path);
                sessionCookieConfig.setDomain(webAppInfo.sessionConfig.sessionCookieConfig.domain);
                sessionCookieConfig.setComment(webAppInfo.sessionConfig.sessionCookieConfig.comment);
                sessionCookieConfig.setHttpOnly(webAppInfo.sessionConfig.sessionCookieConfig.httpOnly);
                sessionCookieConfig.setSecure(webAppInfo.sessionConfig.sessionCookieConfig.secure);
                sessionCookieConfig.setMaxAge(webAppInfo.sessionConfig.sessionCookieConfig.maxAge);
            }
        }
        this.webAppContext.setAttribute(JASPER_WEB_XML_NAME, originalSpecDD);
        WebBeansContext webBeansContext = sharedOwbContext == null ? OpenWebBeansWebInitializer.newWebBeansContext(null) : sharedOwbContext.getOWBContext();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            OpenWebBeansWebInitializer.initializeServletContext((WebBeansContext)webBeansContext, (ServletContext)this.webAppContext.getServletContext());
        }
        finally {
            thread.setContextClassLoader(cl);
        }
        integrationContext.setOwbContext(webBeansContext);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getWARName() {
        try {
            return ObjectName.getInstance(this.objectName).getKeyProperty("name");
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    public WebContainer getContainer() {
        return this.jettyContainer;
    }

    public String getContextPath() {
        return this.webAppContext.getContextPath();
    }

    public void fullyStarted() {
        this.webAppContext.registerServletContext();
    }

    public void doStart() throws Exception {
        this.webAppContext.setClassLoader(this.webClassLoader);
        this.jettyContainer.addContext((Handler)this.webAppContext);
        this.webAppContext.start();
    }

    public void doStop() throws Exception {
        this.webAppContext.unregisterServletContext();
        this.webAppContext.stop();
        this.jettyContainer.removeContext((Handler)this.webAppContext);
        log.debug("WebAppContextWrapper stopped");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.warn("WebAppContextWrapper failed");
    }

    public String getDisplayName() {
        return this.webAppContext.getDisplayName();
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public String[] getServlets() {
        return new String[0];
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }
}

