/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.jetty8.JettyContainer;
import org.apache.geronimo.jetty8.JettyWebConnector;
import org.apache.geronimo.jetty8.Messages;
import org.apache.geronimo.jetty8.connector.AJP13Connector;
import org.apache.geronimo.jetty8.connector.HTTPBlockingConnector;
import org.apache.geronimo.jetty8.connector.HTTPSSelectChannelConnector;
import org.apache.geronimo.jetty8.connector.HTTPSSocketConnector;
import org.apache.geronimo.jetty8.connector.HTTPSelectChannelConnector;
import org.apache.geronimo.jetty8.connector.HTTPSocketConnector;
import org.apache.geronimo.jetty8.requestlog.JettyLogManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.EditableConfigurationManager;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.proxy.ProxyManager;
import org.apache.geronimo.management.geronimo.KeystoreManager;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebAccessLog;
import org.apache.geronimo.management.geronimo.WebContainer;
import org.apache.geronimo.management.geronimo.WebManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean
public class JettyManagerImpl
implements WebManager {
    private static final Logger log = LoggerFactory.getLogger(JettyManagerImpl.class);
    private static final WebManager.ConnectorType HTTP_NIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.0"));
    private static final WebManager.ConnectorType HTTPS_NIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.1"));
    private static final WebManager.ConnectorType HTTP_BLOCKING_NIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.2"));
    private static final WebManager.ConnectorType HTTP_BIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.3"));
    private static final WebManager.ConnectorType HTTPS_BIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.4"));
    private static final WebManager.ConnectorType AJP_NIO = new WebManager.ConnectorType(Messages.getString("JettyManagerImpl.5"));
    private static List<WebManager.ConnectorType> CONNECTOR_TYPES = Arrays.asList(HTTP_NIO, HTTPS_NIO, HTTP_BLOCKING_NIO, HTTP_BIO, HTTPS_BIO, AJP_NIO);
    private static Map<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>> CONNECTOR_ATTRIBUTES = new HashMap<WebManager.ConnectorType, List<WebManager.ConnectorAttribute>>();
    private static Map<WebManager.ConnectorType, GBeanInfo> CONNECTOR_GBEAN_INFOS;
    private final Kernel kernel;

    public JettyManagerImpl(@ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel) {
        this.kernel = kernel;
    }

    public String getProductName() {
        return "Jetty";
    }

    public Object[] getContainers() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        Object[] results = new JettyContainer[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (JettyContainer)proxyManager.createProxy(name, JettyContainer.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(AbstractName connectorName) {
        block11: {
            try {
                GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
                boolean found = false;
                Set intfs = info.getInterfaces();
                for (String intf : intfs) {
                    if (!intf.equals(JettyWebConnector.class.getName())) continue;
                    found = true;
                }
                if (!found) {
                    throw new GBeanNotFoundException(connectorName);
                }
                ConfigurationManager mgr = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
                if (mgr != null && mgr instanceof EditableConfigurationManager) {
                    try {
                        ((EditableConfigurationManager)mgr).removeGBeanFromConfiguration(connectorName.getArtifact(), connectorName);
                        break block11;
                    }
                    catch (InvalidConfigException e) {
                        log.error("Unable to add GBean", (Throwable)e);
                        break block11;
                    }
                    finally {
                        ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)mgr);
                    }
                }
                log.warn("The ConfigurationManager in the kernel does not allow editing");
            }
            catch (GBeanNotFoundException e) {
                log.warn("No such GBean '" + connectorName + "'");
            }
            catch (Exception e) {
                log.error("Failed to remove connector", (Throwable)e);
            }
        }
    }

    public NetworkConnector[] getConnectors(String protocol) {
        if (protocol == null) {
            return this.getConnectors();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        for (AbstractName name : names) {
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(proxyManager.createProxy(name, JettyWebConnector.class.getClassLoader()));
            }
            catch (Exception e) {
                log.error("Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new JettyWebConnector[names.size()]);
    }

    public WebAccessLog getAccessLog(WebContainer container) {
        AbstractNameQuery query = new AbstractNameQuery(JettyLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Jetty access log manager");
        }
        return (WebAccessLog)this.kernel.getProxyManager().createProxy((AbstractName)names.iterator().next(), JettyLogManager.class.getClassLoader());
    }

    public List<WebManager.ConnectorType> getConnectorTypes() {
        return CONNECTOR_TYPES;
    }

    public List<WebManager.ConnectorAttribute> getConnectorAttributes(WebManager.ConnectorType connectorType) {
        return WebManager.ConnectorAttribute.copy(CONNECTOR_ATTRIBUTES.get(connectorType));
    }

    public AbstractName getConnectorConfiguration(WebManager.ConnectorType connectorType, List<WebManager.ConnectorAttribute> connectorAttributes, WebContainer container, String uniqueName) {
        GBeanInfo gbeanInfo = CONNECTOR_GBEAN_INFOS.get(connectorType);
        AbstractName containerName = this.kernel.getAbstractNameFor((Object)container);
        AbstractName name = this.kernel.getNaming().createSiblingName(containerName, uniqueName, "GBean");
        GBeanData gbeanData = new GBeanData(name, gbeanInfo);
        gbeanData.setReferencePattern("JettyContainer", containerName);
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            Object value = connectorAttribute.getValue();
            if (value == null) continue;
            gbeanData.setAttribute(connectorAttribute.getAttributeName(), connectorAttribute.getValue());
        }
        if (connectorType.equals((Object)HTTPS_NIO) || connectorType.equals((Object)HTTPS_BIO)) {
            AbstractNameQuery query = new AbstractNameQuery(KeystoreManager.class.getName());
            gbeanData.setReferencePattern("KeystoreManager", query);
        }
        try {
            ConfigurationManager mgr = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            if (mgr == null || !(mgr instanceof EditableConfigurationManager)) {
                log.warn("The ConfigurationManager in the kernel does not allow editing");
                return null;
            }
            ((EditableConfigurationManager)mgr).addGBeanToConfiguration(containerName.getArtifact(), gbeanData, false);
        }
        catch (InvalidConfigException e) {
            log.error("Unable to add GBean", (Throwable)e);
            return null;
        }
        catch (GBeanNotFoundException e) {
            log.error("Unable to add GBean", (Throwable)e);
            return null;
        }
        return name;
    }

    public WebManager.ConnectorType getConnectorType(AbstractName connectorName) {
        WebManager.ConnectorType connectorType = null;
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(connectorName);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext() && !found) {
                String intf = (String)it.next();
                if (!intf.equals(JettyWebConnector.class.getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(connectorName);
            }
            String searchingFor = info.getName();
            for (Map.Entry<WebManager.ConnectorType, GBeanInfo> entry : CONNECTOR_GBEAN_INFOS.entrySet()) {
                String candidate = entry.getValue().getName();
                if (!candidate.equals(searchingFor)) continue;
                return entry.getKey();
            }
        }
        catch (GBeanNotFoundException e) {
            log.warn("No such GBean '" + connectorName + "'");
        }
        catch (Exception e) {
            log.error("Failed to get connector type", (Throwable)e);
        }
        return connectorType;
    }

    public NetworkConnector[] getConnectors() {
        ProxyManager proxyManager = this.kernel.getProxyManager();
        AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        JettyWebConnector[] results = new JettyWebConnector[names.size()];
        int i = 0;
        for (AbstractName name : names) {
            results[i] = (JettyWebConnector)proxyManager.createProxy(name, JettyWebConnector.class.getClassLoader());
            ++i;
        }
        return results;
    }

    public NetworkConnector[] getConnectorsForContainer(Object container, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(container);
        }
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                try {
                    String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                    if (testProtocol == null || !testProtocol.equals(protocol)) break;
                    results.add(mgr.createProxy(name, JettyWebConnector.class.getClassLoader()));
                }
                catch (Exception e) {
                    log.error("Unable to look up protocol for connector '" + name + "'", (Throwable)e);
                }
                break;
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "': ").initCause(e);
        }
    }

    public NetworkConnector[] getConnectorsForContainer(Object container) {
        AbstractName containerName = this.kernel.getAbstractNameFor(container);
        ProxyManager mgr = this.kernel.getProxyManager();
        try {
            ArrayList<Object> results = new ArrayList<Object>();
            AbstractNameQuery query = new AbstractNameQuery(JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            for (AbstractName name : set) {
                GBeanData data = this.kernel.getGBeanData(name);
                ReferencePatterns refs = data.getReferencePatterns("JettyContainer");
                if (!containerName.equals((Object)refs.getAbstractName())) continue;
                results.add(mgr.createProxy(name, JettyWebConnector.class.getClassLoader()));
            }
            return results.toArray(new JettyWebConnector[results.size()]);
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerName + "'").initCause(e);
        }
    }

    private static void addCommonConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("host", (Object)"0.0.0.0", Messages.getString("JettyManagerImpl.30"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("port", (Object)8080, Messages.getString("JettyManagerImpl.32"), Integer.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("maxThreads", (Object)10, Messages.getString("JettyManagerImpl.34"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("bufferSizeBytes", (Object)8096, Messages.getString("JettyManagerImpl.36"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("headerBufferSizeBytes", (Object)8192, Messages.getString("JettyManagerImpl.57"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("acceptQueueSize", (Object)10, Messages.getString("JettyManagerImpl.38"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("lingerMillis", (Object)30000, Messages.getString("JettyManagerImpl.40"), Integer.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("redirectPort", (Object)8443, Messages.getString("JettyManagerImpl.42"), Integer.class));
    }

    private static void addSslConnectorAttributes(List<WebManager.ConnectorAttribute> connectorAttributes) {
        connectorAttributes.add(new WebManager.ConnectorAttribute("clientAuthRequired", (Object)false, Messages.getString("JettyManagerImpl.44"), Boolean.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("keyStore", (Object)"", Messages.getString("JettyManagerImpl.47"), String.class, true));
        connectorAttributes.add(new WebManager.ConnectorAttribute("trustStore", (Object)"", Messages.getString("JettyManagerImpl.50"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("secureProtocol", (Object)"", Messages.getString("JettyManagerImpl.53"), String.class));
        connectorAttributes.add(new WebManager.ConnectorAttribute("algorithm", (Object)"Default", Messages.getString("JettyManagerImpl.56"), String.class));
    }

    private static <T> void setAttribute(List<WebManager.ConnectorAttribute> connectorAttributes, String attributeName, T value) {
        for (WebManager.ConnectorAttribute connectorAttribute : connectorAttributes) {
            if (!connectorAttribute.getAttributeName().equals(attributeName)) continue;
            connectorAttribute.setValue(value);
            return;
        }
    }

    public void updateConnectorConfig(AbstractName connectorName) throws Exception {
    }

    static {
        ArrayList<Object> connectorAttributes = new ArrayList<WebManager.ConnectorAttribute>();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        JettyManagerImpl.addSslConnectorAttributes(connectorAttributes);
        JettyManagerImpl.setAttribute(connectorAttributes, "port", 8443);
        CONNECTOR_ATTRIBUTES.put(HTTPS_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        JettyManagerImpl.addSslConnectorAttributes(connectorAttributes);
        JettyManagerImpl.setAttribute(connectorAttributes, "port", 8443);
        CONNECTOR_ATTRIBUTES.put(HTTPS_BIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(HTTP_BLOCKING_NIO, connectorAttributes);
        connectorAttributes = new ArrayList();
        JettyManagerImpl.addCommonConnectorAttributes(connectorAttributes);
        CONNECTOR_ATTRIBUTES.put(AJP_NIO, connectorAttributes);
        CONNECTOR_GBEAN_INFOS = new HashMap<WebManager.ConnectorType, GBeanInfo>();
        CONNECTOR_GBEAN_INFOS.put(HTTP_NIO, HTTPSelectChannelConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_NIO, HTTPSSelectChannelConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_BLOCKING_NIO, HTTPBlockingConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTP_BIO, HTTPSocketConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(HTTPS_BIO, HTTPSSocketConnector.GBEAN_INFO);
        CONNECTOR_GBEAN_INFOS.put(AJP_NIO, AJP13Connector.GBEAN_INFO);
    }
}

