/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8;

import javax.naming.Context;
import javax.servlet.Servlet;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.jetty8.JettyServletRegistration;
import org.apache.geronimo.jetty8.handler.IntegrationContext;
import org.eclipse.jetty.servlet.ServletHolder;

public class GeronimoServletHolder
extends ServletHolder {
    private final IntegrationContext integrationContext;
    private final JettyServletRegistration servletRegistration;

    public GeronimoServletHolder(IntegrationContext integrationContext, JettyServletRegistration servletRegistration, String servletClassName) throws ClassNotFoundException {
        this.integrationContext = integrationContext;
        this.servletRegistration = servletRegistration;
        this.setClassName(servletClassName);
        if (integrationContext != null) {
            this._class = servletRegistration.loadClass(servletClassName, Servlet.class);
        }
    }

    public synchronized Servlet newInstance() throws InstantiationException, IllegalAccessException {
        return (Servlet)this.servletRegistration.newInstance(this._className);
    }

    public void destroyInstance(Object o) throws Exception {
        super.destroyInstance(o);
        this.servletRegistration.destroyInstance(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStart();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStop();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }
}

