/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.cluster;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.clustering.ClusteredInvocation;
import org.apache.geronimo.clustering.ClusteredInvocationException;
import org.apache.geronimo.jetty8.AbstractPreHandler;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.server.Request;

public abstract class AbstractClusteredPreHandler
extends AbstractPreHandler {
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ClusteredInvocation invocation = this.newClusteredInvocation(target, baseRequest, request, response);
        try {
            invocation.invoke();
        }
        catch (ClusteredInvocationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof HttpException) {
                throw (HttpException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw (IOException)new IOException().initCause(cause);
        }
    }

    protected abstract ClusteredInvocation newClusteredInvocation(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4);

    protected abstract class WebClusteredInvocation
    implements ClusteredInvocation {
        protected final String target;
        protected final Request baseRequest;
        protected final HttpServletRequest request;
        protected final HttpServletResponse response;

        protected WebClusteredInvocation(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
            this.target = target;
            this.baseRequest = baseRequest;
            this.request = request;
            this.response = response;
        }

        protected void invokeLocally() throws ClusteredInvocationException {
            try {
                AbstractClusteredPreHandler.this.next.handle(this.target, this.baseRequest, this.request, this.response);
            }
            catch (IOException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
            catch (ServletException e) {
                throw new ClusteredInvocationException((Throwable)e);
            }
        }

        public String getRequestedSessionId() {
            return this.request.getRequestedSessionId();
        }
    }
}

