/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty8.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.bind.JAXBException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.Deployable;
import org.apache.geronimo.deployment.DeployableBundle;
import org.apache.geronimo.deployment.DeployableJarFile;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilder;
import org.apache.geronimo.deployment.NamespaceDrivenBuilderCollection;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.gbean.annotation.ParamSpecial;
import org.apache.geronimo.gbean.annotation.SpecialAttributeType;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilderExtension;
import org.apache.geronimo.j2ee.deployment.NamingBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.deployment.WebServiceBuilder;
import org.apache.geronimo.jetty8.Host;
import org.apache.geronimo.jetty8.WebAppContextManager;
import org.apache.geronimo.jetty8.WebAppContextWrapper;
import org.apache.geronimo.jetty8.security.AuthConfigProviderHandlerFactory;
import org.apache.geronimo.jetty8.security.BuiltInAuthMethod;
import org.apache.geronimo.jetty8.security.JettySecurityHandlerFactory;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.util.FileUtils;
import org.apache.geronimo.kernel.util.JarUtils;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.deployment.GBeanResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentBuilder;
import org.apache.geronimo.naming.deployment.ResourceEnvironmentSetter;
import org.apache.geronimo.openejb.cdi.SharedOwbContext;
import org.apache.geronimo.schema.ElementConverter;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deployment.GeronimoSecurityBuilderImpl;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.ComponentPermissions;
import org.apache.geronimo.web.deployment.GenericToSpecificPlanConverter;
import org.apache.geronimo.web.info.LoginConfigInfo;
import org.apache.geronimo.web.info.ServletInfo;
import org.apache.geronimo.web.info.WebAppInfo;
import org.apache.geronimo.web25.deployment.AbstractWebModuleBuilder;
import org.apache.geronimo.web25.deployment.StandardWebAppInfoFactory;
import org.apache.geronimo.web25.deployment.WebAppInfoBuilder;
import org.apache.geronimo.web25.deployment.WebAppInfoFactory;
import org.apache.geronimo.web25.deployment.security.AuthenticationWrapper;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiAuthModuleType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiConfigProviderType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthConfigType;
import org.apache.geronimo.xbeans.geronimo.jaspi.JaspiServerAuthContextType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyAuthenticationType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppDocument;
import org.apache.geronimo.xbeans.geronimo.web.jetty.JettyWebAppType;
import org.apache.geronimo.xbeans.geronimo.web.jetty.config.GerJettyDocument;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.WebApp;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GBean(j2eeType="ModuleBuilder")
public class JettyModuleBuilder
extends AbstractWebModuleBuilder
implements GBeanLifecycle {
    private static final Logger log = LoggerFactory.getLogger(JettyModuleBuilder.class);
    private static final Map<String, String> NAMESPACE_UPDATES = new HashMap<String, String>();
    private static final Map<String, ElementConverter> GERONIMO_SCHEMA_CONVERSIONS = new HashMap<String, ElementConverter>();
    private static final String JASPI_NAMESPACE = "http://geronimo.apache.org/xml/ns/geronimo-jaspi";
    private final Environment defaultEnvironment;
    private final AbstractNameQuery jettyContainerObjectName;
    private final WebAppInfoFactory webAppInfoFactory;
    protected final NamespaceDrivenBuilderCollection clusteringBuilders;
    private final Integer defaultSessionTimeoutMinutes;
    private static final String JETTY_NAMESPACE;

    public JettyModuleBuilder(@ParamAttribute(name="defaultEnvironment") Environment defaultEnvironment, @ParamAttribute(name="defaultSessionTimeoutSeconds") Integer defaultSessionTimeoutSeconds, @ParamAttribute(name="jettyContainerObjectName") AbstractNameQuery jettyContainerName, @ParamAttribute(name="defaultWebApp") WebAppInfo defaultWebApp, @ParamAttribute(name="jspServlet") WebAppInfo jspServlet, @ParamReference(name="PojoWebServiceTemplate", namingType="ServletWebServiceTemplate") Object pojoWebServiceTemplate, @ParamReference(name="WebServiceBuilder", namingType="ModuleBuilder") Collection<WebServiceBuilder> webServiceBuilder, @ParamReference(name="ClusteringBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> clusteringBuilders, @ParamReference(name="ServiceBuilders", namingType="ModuleBuilder") Collection<NamespaceDrivenBuilder> serviceBuilders, @ParamReference(name="NamingBuilders", namingType="ModuleBuilder") NamingBuilder namingBuilders, @ParamReference(name="ModuleBuilderExtensions", namingType="ModuleBuilder") Collection<ModuleBuilderExtension> moduleBuilderExtensions, @ParamReference(name="ResourceEnvironmentSetter", namingType="ModuleBuilder") ResourceEnvironmentSetter resourceEnvironmentSetter, @ParamSpecial(type=SpecialAttributeType.kernel) Kernel kernel, @ParamSpecial(type=SpecialAttributeType.bundleContext) BundleContext bundleContext) throws GBeanNotFoundException, DeploymentException {
        super(kernel, serviceBuilders, namingBuilders, resourceEnvironmentSetter, webServiceBuilder, moduleBuilderExtensions, bundleContext);
        this.defaultEnvironment = defaultEnvironment;
        this.defaultSessionTimeoutMinutes = defaultSessionTimeoutSeconds == null ? 1800 : defaultSessionTimeoutSeconds;
        this.jettyContainerObjectName = jettyContainerName;
        ServletInfo jspServletInfo = jspServlet != null ? (ServletInfo)jspServlet.servlets.get(0) : null;
        this.webAppInfoFactory = new StandardWebAppInfoFactory(defaultWebApp, jspServletInfo);
        this.clusteringBuilders = new NamespaceDrivenBuilderCollection(clusteringBuilders);
    }

    public void doStart() throws Exception {
        XmlBeansUtil.registerNamespaceUpdates(NAMESPACE_UPDATES);
        SchemaConversionUtils.registerNamespaceConversions(GERONIMO_SCHEMA_CONVERSIONS);
    }

    public void doStop() {
        XmlBeansUtil.unregisterNamespaceUpdates(NAMESPACE_UPDATES);
    }

    public void doFail() {
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module createModule(Bundle bundle, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        if (bundle == null) {
            throw new NullPointerException("bundle is null");
        }
        String contextPath = (String)bundle.getHeaders().get("Web-ContextPath");
        if (contextPath == null) {
            return null;
        }
        String specDD = null;
        WebApp webApp = null;
        URL specDDUrl = BundleUtils.getEntry((Bundle)bundle, (String)"WEB-INF/web.xml");
        if (specDDUrl == null) {
            webApp = new WebApp();
        } else {
            try {
                specDD = JarUtils.readAll((URL)specDDUrl);
                InputStream in = specDDUrl.openStream();
                try {
                    webApp = (WebApp)JaxbJavaee.unmarshalJavaee(WebApp.class, (InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                throw new DeploymentException("Error reading web.xml for " + bundle.getSymbolicName(), (Throwable)e);
            }
        }
        AbstractName earName = null;
        String targetPath = ".";
        boolean standAlone = true;
        DeployableBundle deployable = new DeployableBundle(bundle);
        JettyWebAppType jettyWebApp = this.getJettyWebApp(null, (Deployable)deployable, standAlone, targetPath, webApp);
        EnvironmentType environmentType = jettyWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        if (webApp.getDistributable().size() == 1) {
            this.clusteringBuilders.buildEnvironment((XmlObject)jettyWebApp, environment);
        }
        idBuilder.resolve(environment, bundle.getSymbolicName(), "wab");
        if (earName == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        String name = webApp.getModuleName();
        if (name == null) {
            name = bundle.getSymbolicName();
        }
        WebModule module = new WebModule(standAlone, moduleName, name, environment, (Deployable)deployable, targetPath, webApp, (XmlObject)jettyWebApp, specDD, contextPath, JETTY_NAMESPACE, JettyModuleBuilder.shareJndi(null), null);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, bundle, naming, idBuilder);
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, Environment earEnvironment, String contextRoot, Module parentModule, Naming naming, ModuleIDBuilder idBuilder) throws DeploymentException {
        AbstractName moduleName;
        AbstractName earName;
        String warName;
        WebApp webApp;
        String specDD;
        block18: {
            assert (moduleFile != null) : "moduleFile is null";
            assert (targetPath != null) : "targetPath is null";
            assert (!targetPath.endsWith("/")) : "targetPath must not end with a '/'";
            specDD = null;
            webApp = null;
            try {
                if (specDDUrl == null) {
                    specDDUrl = JarUtils.createJarURL((JarFile)moduleFile, (String)"WEB-INF/web.xml");
                }
                specDD = JarUtils.readAll((URL)specDDUrl);
                InputStream in = specDDUrl.openStream();
                try {
                    webApp = (WebApp)JaxbJavaee.unmarshalJavaee(WebApp.class, (InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (JAXBException e) {
                throw new DeploymentException("Error parsing web.xml for " + targetPath, (Throwable)e);
            }
            catch (Exception e) {
                if (moduleFile.getName().endsWith(".war")) break block18;
                return null;
            }
        }
        if (webApp == null) {
            webApp = new WebApp();
        }
        DeployableJarFile deployable = new DeployableJarFile(moduleFile);
        boolean standAlone = earEnvironment == null;
        JettyWebAppType jettyWebApp = this.getJettyWebApp(plan, (Deployable)deployable, standAlone, targetPath, webApp);
        contextRoot = this.getContextRoot(jettyWebApp, contextRoot, webApp, standAlone, moduleFile, targetPath);
        EnvironmentType environmentType = jettyWebApp.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        if (webApp.getDistributable().size() == 1) {
            this.clusteringBuilders.buildEnvironment((XmlObject)jettyWebApp, environment);
        }
        if (!standAlone) {
            EnvironmentBuilder.mergeEnvironments((Environment)earEnvironment, (Environment)environment);
            environment = earEnvironment;
        }
        if ((warName = new File(moduleFile.getName()).getName()).lastIndexOf(46) > -1) {
            warName = warName.substring(0, warName.lastIndexOf(46));
        }
        idBuilder.resolve(environment, warName, "war");
        if (parentModule == null) {
            earName = naming.createRootName(environment.getConfigId(), "null", "J2EEApplication");
            moduleName = naming.createChildName(earName, environment.getConfigId().toString(), "WebModule");
        } else {
            earName = parentModule.getModuleName();
            moduleName = naming.createChildName(earName, targetPath, "WebModule");
        }
        String name = webApp.getModuleName();
        if (name == null) {
            name = standAlone ? FileUtils.removeExtension((String)new File(moduleFile.getName()).getName(), (String)".war") : FileUtils.removeExtension((String)targetPath, (String)".war");
        }
        WebModule module = new WebModule(standAlone, moduleName, name, environment, (Deployable)deployable, targetPath, webApp, (XmlObject)jettyWebApp, specDD, contextRoot, JETTY_NAMESPACE, JettyModuleBuilder.shareJndi((Module)parentModule), parentModule);
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.createModule((Module)module, plan, moduleFile, targetPath, specDDUrl, environment, (Object)contextRoot, earName, naming, idBuilder);
        }
        return module;
    }

    String getContextRoot(JettyWebAppType jettyWebApp, String contextRoot, WebApp webApp, boolean standAlone, JarFile moduleFile, String targetPath) {
        if (jettyWebApp.isSetContextRoot()) {
            contextRoot = jettyWebApp.getContextRoot();
        } else if (contextRoot == null || contextRoot.trim().equals("")) {
            contextRoot = this.determineDefaultContextRoot(webApp, standAlone, moduleFile, targetPath);
        }
        contextRoot = contextRoot.trim();
        return contextRoot;
    }

    JettyWebAppType getJettyWebApp(Object plan, Deployable deployable, boolean standAlone, String targetPath, WebApp webApp) throws DeploymentException {
        XmlObject rawPlan = null;
        try {
            JettyWebAppType jettyWebApp;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((URL)((File)plan).toURI().toURL(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                } else {
                    URL path = deployable.getResource("WEB-INF/geronimo-web.xml");
                    if (path == null) {
                        path = deployable.getResource("WEB-INF/geronimo-jetty.xml");
                    }
                    if (path == null) {
                        log.warn("Web application " + targetPath + " does not contain a WEB-INF/geronimo-web.xml deployment plan.  This may or may not be a problem, depending on whether you have things like resource references that need to be resolved.  You can also give the deployer a separate deployment plan file on the command line.");
                    } else {
                        rawPlan = XmlBeansUtil.parse((URL)path, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    }
                }
            }
            catch (IOException e) {
                log.warn("Failed to load geronimo-web.xml", (Throwable)e);
            }
            if (rawPlan != null) {
                XmlObject webPlan = new GenericToSpecificPlanConverter(GerJettyDocument.type.getDocumentElementName().getNamespaceURI(), JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI(), "jetty").convertToSpecificPlan(rawPlan);
                jettyWebApp = (JettyWebAppType)webPlan.changeType(JettyWebAppType.type);
                XmlBeansUtil.validateDD((XmlObject)jettyWebApp);
            } else {
                jettyWebApp = this.createDefaultPlan();
            }
            return jettyWebApp;
        }
        catch (XmlException e) {
            throw new DeploymentException("xml problem for web app " + targetPath, (Throwable)e);
        }
    }

    private JettyWebAppType createDefaultPlan() {
        return JettyWebAppType.Factory.newInstance();
    }

    protected void postInitContext(EARContext earContext, WebModule webModule, Bundle bundle) throws DeploymentException {
        for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
            mbe.initContext(earContext, (Module)webModule, bundle);
        }
        Map servletNameToPathMap = this.buildServletNameToPathMap((WebApp)webModule.getSpecDD(), webModule.getContextRoot());
        for (WebServiceBuilder serviceBuilder : this.webServiceBuilder) {
            serviceBuilder.findWebServices((Module)webModule, false, servletNameToPathMap, webModule.getEnvironment(), webModule.getSharedContext());
        }
    }

    protected void preInitContext(EARContext earContext, WebModule webModule, Bundle bundle) throws DeploymentException {
        JettyWebAppType gerWebApp = (JettyWebAppType)webModule.getVendorDD();
        boolean hasSecurityRealmName = gerWebApp.isSetSecurityRealmName();
        webModule.getEarContext().getGeneralData().put(WEB_MODULE_HAS_SECURITY_REALM, hasSecurityRealmName);
    }

    public void addGBeans(EARContext earContext, Module module, Bundle bundle, Collection repository) throws DeploymentException {
        EARContext moduleContext = module.getEarContext();
        AbstractName moduleName = module.getModuleName();
        WebModule webModule = (WebModule)module;
        WebApp webApp = (WebApp)webModule.getSpecDD();
        JettyWebAppType jettyWebApp = (JettyWebAppType)webModule.getVendorDD();
        GBeanData webModuleData = new GBeanData(moduleName, WebAppContextWrapper.class);
        this.configureBasicWebModuleAttributes(webApp, jettyWebApp, moduleContext, earContext, webModule, webModuleData);
        GBeanResourceEnvironmentBuilder rebuilder = new GBeanResourceEnvironmentBuilder(webModuleData);
        this.resourceEnvironmentSetter.setResourceEnvironment((ResourceEnvironmentBuilder)rebuilder, webApp.getResourceRef(), jettyWebApp.getResourceRefArray());
        try {
            moduleContext.addGBean(webModuleData);
            AbstractName contextManagerName = earContext.getNaming().createChildName(moduleName, "WebAppContextManager", "ServiceModule");
            GBeanData contextManagerGBean = new GBeanData(contextManagerName, WebAppContextManager.class);
            contextManagerGBean.setPriority(100);
            contextManagerGBean.setReferencePattern("webApp", moduleName);
            moduleContext.addGBean(contextManagerGBean);
            this.configureHosts(earContext, jettyWebApp, webModuleData);
            String contextPath = webModule.getContextRoot();
            if (contextPath == null) {
                throw new DeploymentException("null contextPath");
            }
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
            webModuleData.setAttribute("contextPath", (Object)contextPath);
            if (jettyWebApp.isSetWorkDir()) {
                String workDir = jettyWebApp.getWorkDir();
                webModuleData.setAttribute("workDir", (Object)workDir);
            }
            if (jettyWebApp.isSetWebContainer()) {
                AbstractNameQuery webContainerName = ENCConfigBuilder.getGBeanQuery((String)"GBean", (GerGbeanLocatorType)jettyWebApp.getWebContainer());
                webModuleData.setReferencePattern("JettyContainer", webContainerName);
            } else {
                webModuleData.setReferencePattern("JettyContainer", this.jettyContainerObjectName);
            }
            webModuleData.setAttribute("displayName", (Object)webApp.getDisplayName());
            WebAppInfoBuilder webAppInfoBuilder = new WebAppInfoBuilder(webApp, this.webAppInfoFactory);
            WebAppInfo webAppInfo = webAppInfoBuilder.build();
            webModuleData.setAttribute("webAppInfo", (Object)webAppInfo);
            webModule.getSharedContext().put("WEB_APP_INFO", webAppInfoBuilder);
            if (webAppInfo.sessionConfig != null && webAppInfo.sessionConfig.sessionTimeoutMinutes == -1 && this.defaultSessionTimeoutMinutes != -1) {
                webAppInfo.sessionConfig.sessionTimeoutMinutes = this.defaultSessionTimeoutMinutes;
            }
            if (webAppInfo.distributable) {
                this.clusteringBuilders.build((XmlObject)jettyWebApp, (DeploymentContext)earContext, (DeploymentContext)moduleContext);
                if (webModuleData.getReferencePatterns("SessionHandlerFactory") == null) {
                    log.warn("No clustering builders configured: app will not be clustered");
                    this.configureNoClustering(moduleContext, webModuleData);
                }
            } else {
                this.configureNoClustering(moduleContext, webModuleData);
            }
            this.configureAuthentication(module, webAppInfo.loginConfig, jettyWebApp, webModuleData);
            if (jettyWebApp.isSetSecurityRealmName()) {
                this.configureSecurityRealm(earContext, webApp, jettyWebApp, bundle, webModuleData);
            }
            if (jettyWebApp.getCompactPath()) {
                webModuleData.setAttribute("compactPath", (Object)Boolean.TRUE);
            }
            LinkedHashSet submodules = module.getModules();
            for (Module subModule : submodules) {
                if (subModule.getSharedContext().get(SharedOwbContext.class) == null) continue;
                GBeanData data = (GBeanData)subModule.getSharedContext().get(SharedOwbContext.class);
                AbstractName name = data.getAbstractName();
                webModuleData.setReferencePattern("SharedOwbContext", name);
            }
            HashMap<String, Object> deploymentAttributes = new HashMap<String, Object>();
            deploymentAttributes.put("META_COMPLETE", webApp.isMetadataComplete());
            deploymentAttributes.put("SCHEMA_VERSION", INITIAL_WEB_XML_SCHEMA_VERSION.get(webModule.getEarContext().getGeneralData()));
            deploymentAttributes.put("ORDERED_LIBS", AbstractWebModuleBuilder.ORDERED_LIBS.get(webModule.getEarContext().getGeneralData()));
            deploymentAttributes.put("SERVLET_CONTAINER_INITIALIZERS", AbstractWebModuleBuilder.SERVLET_CONTAINER_INITIALIZERS.get(webModule.getEarContext().getGeneralData()));
            webModuleData.setAttribute("deploymentAttributes", deploymentAttributes);
            for (ModuleBuilderExtension mbe : this.moduleBuilderExtensions) {
                mbe.addGBeans(earContext, module, bundle, repository);
            }
            if (jettyWebApp.isSetSecurityRealmName()) {
                webModuleData.setReferencePattern("applicationPolicyConfigurationManager", (AbstractName)EARContext.JACC_MANAGER_NAME_KEY.get(earContext.getGeneralData()));
            }
            if (!webApp.isMetadataComplete().booleanValue()) {
                webApp.setMetadataComplete(Boolean.valueOf(true));
                if (((Float)INITIAL_WEB_XML_SCHEMA_VERSION.get(webModule.getEarContext().getGeneralData())).floatValue() >= 2.5f) {
                    String specDeploymentPlan = this.getSpecDDAsString(webModule);
                    module.setOriginalSpecDD(specDeploymentPlan);
                    earContext.addFile(new URI("./WEB-INF/web.xml"), specDeploymentPlan);
                }
            }
            webModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
            module.addAsChildConfiguration();
        }
        catch (DeploymentException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize webapp GBean for " + module.getName(), (Throwable)e);
        }
    }

    private void configureNoClustering(EARContext moduleContext, GBeanData webModuleData) throws GBeanAlreadyExistsException {
    }

    private void configureSecurityRealm(EARContext earContext, WebApp webApp, JettyWebAppType jettyWebApp, Bundle bundle, GBeanData webModuleData) throws DeploymentException {
        AbstractName moduleName = webModuleData.getAbstractName();
        if (earContext.getSecurityConfiguration() == null) {
            throw new DeploymentException("You have specified a <security-realm-name> for the webapp " + moduleName + " but no <security> configuration (role mapping) is supplied in the Geronimo plan for the web application (or the Geronimo plan for the EAR if the web app is in an EAR)");
        }
        String securityRealmName = jettyWebApp.getSecurityRealmName().trim();
        webModuleData.setAttribute("securityRealmName", (Object)securityRealmName);
        webModuleData.setReferencePattern("RunAsSource", (AbstractNameQuery)GeronimoSecurityBuilderImpl.ROLE_MAPPER_DATA_NAME.get(earContext.getGeneralData()));
        String policyContextID = moduleName.toString().replaceAll("[, :]", "_");
        webModuleData.setAttribute("policyContextID", (Object)policyContextID);
        ComponentPermissions componentPermissions = this.buildSpecSecurityConfig(earContext, webApp, bundle);
        earContext.addSecurityContext(policyContextID, (Object)componentPermissions);
    }

    private void configureAuthentication(Module module, LoginConfigInfo loginConfigInfo, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws DeploymentException, GBeanAlreadyExistsException {
        EARContext moduleContext = module.getEarContext();
        JettyAuthenticationType authType = jettyWebApp.getAuthentication();
        if (loginConfigInfo != null || authType != null || jettyWebApp.isSetSecurityRealmName()) {
            AbstractName factoryName = moduleContext.getNaming().createChildName(module.getModuleName(), "securityHandlerFactory", "GBean");
            if (authType != null) {
                GBeanData securityFactoryData = new GBeanData(factoryName, AuthConfigProviderHandlerFactory.class);
                securityFactoryData.setAttribute("messageLayer", (Object)"HttpServlet");
                String contextPath = (String)webModuleData.getAttribute("contextPath");
                securityFactoryData.setAttribute("appContext", (Object)("server " + contextPath));
                this.configureConfigurationFactory(jettyWebApp, null, securityFactoryData);
                moduleContext.addGBean(securityFactoryData);
                this.configureLocalJaspicProvider(new JettyAuthenticationWrapper(authType), contextPath, module, securityFactoryData);
                webModuleData.setReferencePattern("SecurityHandlerFactory", factoryName);
            } else if (loginConfigInfo != null && loginConfigInfo.realmName != null || jettyWebApp.isSetSecurityRealmName()) {
                GBeanData securityFactoryData = new GBeanData(factoryName, JettySecurityHandlerFactory.class);
                this.configureConfigurationFactory(jettyWebApp, loginConfigInfo, securityFactoryData);
                BuiltInAuthMethod auth = BuiltInAuthMethod.NONE;
                if (loginConfigInfo != null) {
                    if (loginConfigInfo.authMethod != null) {
                        String authMethod = loginConfigInfo.authMethod.trim();
                        auth = BuiltInAuthMethod.getValueOf((String)authMethod);
                        if (auth == BuiltInAuthMethod.BASIC) {
                            securityFactoryData.setAttribute("realmName", (Object)loginConfigInfo.realmName);
                        } else if (auth == BuiltInAuthMethod.DIGEST) {
                            securityFactoryData.setAttribute("realmName", (Object)loginConfigInfo.realmName);
                        } else if (auth == BuiltInAuthMethod.FORM) {
                            if (loginConfigInfo.formLoginPage != null) {
                                securityFactoryData.setAttribute("loginPage", (Object)loginConfigInfo.formLoginPage);
                                securityFactoryData.setAttribute("errorPage", (Object)loginConfigInfo.formErrorPage);
                            }
                        } else if (auth != BuiltInAuthMethod.CLIENTCERT) {
                            throw new DeploymentException("unrecognized auth method, use jaspi to configure: " + authMethod);
                        }
                    } else {
                        throw new DeploymentException("No auth method configured and no jaspi configured");
                    }
                    if (loginConfigInfo.realmName != null) {
                        webModuleData.setAttribute("realmName", (Object)loginConfigInfo.realmName);
                    }
                }
                securityFactoryData.setAttribute("authMethod", (Object)auth);
                moduleContext.addGBean(securityFactoryData);
                webModuleData.setReferencePattern("SecurityHandlerFactory", factoryName);
            } else {
                log.warn("partial security info but no realm to authenticate against");
            }
        }
    }

    private void configureConfigurationFactory(JettyWebAppType jettyWebApp, LoginConfigInfo loginConfigInfo, GBeanData securityFactoryData) {
        String securityRealmName = jettyWebApp.isSetSecurityRealmName() ? jettyWebApp.getSecurityRealmName().trim() : loginConfigInfo.realmName;
        AbstractNameQuery configurationFactoryName = new AbstractNameQuery(null, Collections.singletonMap("name", securityRealmName), ConfigurationFactory.class.getName());
        securityFactoryData.setReferencePattern("ConfigurationFactory", configurationFactoryName);
    }

    private void configureHosts(EARContext earContext, JettyWebAppType jettyWebApp, GBeanData webModuleData) throws GBeanAlreadyExistsException {
        String[] hosts = jettyWebApp.getHostArray();
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        String[] virtualHosts = jettyWebApp.getVirtualHostArray();
        for (int i = 0; i < virtualHosts.length; ++i) {
            virtualHosts[i] = virtualHosts[i].trim();
        }
        if (hosts.length > 0 || virtualHosts.length > 0) {
            AbstractName hostName = earContext.getNaming().createChildName(webModuleData.getAbstractName(), "Host", "Host");
            GBeanData hostData = new GBeanData(hostName, Host.class);
            hostData.setAttribute("hosts", (Object)hosts);
            hostData.setAttribute("virtualHosts", (Object)virtualHosts);
            earContext.addGBean(hostData);
            webModuleData.setReferencePattern("Host", hostName);
        }
    }

    public String getSchemaNamespace() {
        return JETTY_NAMESPACE;
    }

    static {
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.1", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-1.2", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.1", "http://geronimo.apache.org/xml/ns/j2ee/web/jetty-2.0.2");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty/config", "http://geronimo.apache.org/xml/ns/web/jetty/config-1.0.1");
        NAMESPACE_UPDATES.put("http://geronimo.apache.org/xml/ns/web/jetty/config-1.0", "http://geronimo.apache.org/xml/ns/web/jetty/config-1.0.1");
        GERONIMO_SCHEMA_CONVERSIONS.put("configProvider", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthConfig", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthContext", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("serverAuthModule", (ElementConverter)new NamespaceElementConverter(JASPI_NAMESPACE));
        JETTY_NAMESPACE = JettyWebAppDocument.type.getDocumentElementName().getNamespaceURI();
    }

    private static class JettyAuthenticationWrapper
    implements AuthenticationWrapper {
        private final JettyAuthenticationType authType;

        private JettyAuthenticationWrapper(JettyAuthenticationType authType) {
            this.authType = authType;
        }

        public JaspiConfigProviderType getConfigProvider() {
            return this.authType.getConfigProvider();
        }

        public boolean isSetConfigProvider() {
            return this.authType.isSetConfigProvider();
        }

        public JaspiServerAuthConfigType getServerAuthConfig() {
            return this.authType.getServerAuthConfig();
        }

        public boolean isSetServerAuthConfig() {
            return this.authType.isSetServerAuthConfig();
        }

        public JaspiServerAuthContextType getServerAuthContext() {
            return this.authType.getServerAuthContext();
        }

        public boolean isSetServerAuthContext() {
            return this.authType.isSetServerAuthContext();
        }

        public JaspiAuthModuleType getServerAuthModule() {
            return this.authType.getServerAuthModule();
        }

        public boolean isSetServerAuthModule() {
            return this.authType.isSetServerAuthModule();
        }
    }
}

