/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.security;

import java.security.AccessControlContext;
import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.Subject;
import org.apache.geronimo.jetty7.handler.GeronimoRunAsToken;
import org.apache.geronimo.jetty7.handler.GeronimoUserIdentity;
import org.apache.geronimo.security.Callers;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.RunAsToken;
import org.eclipse.jetty.server.UserIdentity;

public class JettyIdentityService
implements IdentityService {
    private final AccessControlContext defaultAcc;
    private final Subject defaultSubject;
    private final RunAsSource runAsSource;

    public JettyIdentityService(AccessControlContext defaultAcc, Subject defaultSubject, RunAsSource runAsSource) {
        this.defaultAcc = defaultAcc;
        this.defaultSubject = defaultSubject;
        this.runAsSource = runAsSource;
    }

    public Object associate(UserIdentity user) {
        Callers oldCallers = ContextManager.getCallers();
        if (user == null) {
            ContextManager.setCallers((Subject)this.defaultSubject, (Subject)this.defaultSubject);
        } else {
            ContextManager.setCallers((Subject)user.getSubject(), (Subject)user.getSubject());
        }
        return oldCallers;
    }

    public void disassociate(Object previousIdentity) {
        ContextManager.popCallers((Callers)((Callers)previousIdentity));
    }

    public Object setRunAs(UserIdentity userIdentity, RunAsToken token) {
        GeronimoRunAsToken geronimoRunAsToken = (GeronimoRunAsToken)token;
        Subject runAsSubject = geronimoRunAsToken == null ? null : geronimoRunAsToken.getRunAsSubject();
        return ContextManager.pushNextCaller((Subject)runAsSubject);
    }

    public void unsetRunAs(Object previousToken) {
        ContextManager.popCallers((Callers)((Callers)previousToken));
    }

    public UserIdentity newUserIdentity(Subject subject, Principal userPrincipal, String[] roles) {
        if (subject != null) {
            AccessControlContext acc = ContextManager.registerSubjectShort((Subject)subject, (Principal)userPrincipal, roles == null ? null : Arrays.asList(roles));
            return new GeronimoUserIdentity(subject, userPrincipal, acc);
        }
        return new GeronimoUserIdentity(null, null, this.defaultAcc);
    }

    public RunAsToken newRunAsToken(String runAsName) {
        Subject runAsSubject = this.runAsSource.getSubjectForRole(runAsName);
        return new GeronimoRunAsToken(runAsSubject);
    }

    public UserIdentity getSystemUserIdentity() {
        return new GeronimoUserIdentity(null, null, this.defaultAcc);
    }
}

