/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.handler;

import java.util.Set;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.TrackedConnectionAssociator;
import org.apache.geronimo.naming.java.RootContext;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegrationContext {
    private final Context componentContext;
    private final Set<String> unshareableResources;
    private final Set<String> applicationManagedSecurityResources;
    private final TrackedConnectionAssociator trackedConnectionAssociator;
    private final UserTransaction userTransaction;

    public IntegrationContext(Context componentContext, Set<String> unshareableResources, Set<String> applicationManagedSecurityResources, TrackedConnectionAssociator trackedConnectionAssociator, UserTransaction userTransaction) {
        this.componentContext = componentContext;
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        this.trackedConnectionAssociator = trackedConnectionAssociator;
        this.userTransaction = userTransaction;
    }

    public Context getComponentContext() {
        return this.componentContext;
    }

    public Set<String> getUnshareableResources() {
        return this.unshareableResources;
    }

    public Set<String> getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }

    public TrackedConnectionAssociator getTrackedConnectionAssociator() {
        return this.trackedConnectionAssociator;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public SharedConnectorInstanceContext newConnectorInstanceContext(Request baseRequest) {
        return new SharedConnectorInstanceContext(this.getUnshareableResources(), this.getApplicationManagedSecurityResources(), !this.isDispatch(baseRequest));
    }

    private boolean isDispatch(Request baseRequest) {
        if (baseRequest == null) {
            return true;
        }
        return DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType());
    }

    public ConnectorInstanceContext setConnectorInstance(Request baseRequest, SharedConnectorInstanceContext newContext) throws ServletException {
        try {
            SharedConnectorInstanceContext oldContext = (SharedConnectorInstanceContext)this.getTrackedConnectionAssociator().enter((ConnectorInstanceContext)newContext);
            if (oldContext != null && !this.isDispatch(baseRequest)) {
                newContext.share(oldContext);
            }
            return oldContext;
        }
        catch (ResourceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void restoreConnectorContext(ConnectorInstanceContext oldConnectorContext, Request baseRequest, SharedConnectorInstanceContext newContext) throws ServletException {
        try {
            if (this.isDispatch(baseRequest)) {
                this.getTrackedConnectionAssociator().exit(oldConnectorContext);
            } else {
                newContext.hide();
                this.getTrackedConnectionAssociator().exit(oldConnectorContext);
            }
        }
        catch (ResourceException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Context setContext() {
        Context oldContext = RootContext.getComponentContext();
        RootContext.setComponentContext((Context)this.getComponentContext());
        return oldContext;
    }

    public void restoreContext(Context context) {
        RootContext.setComponentContext((Context)context);
    }

    public boolean isTxActive() throws ServletException {
        try {
            return this.getUserTransaction().getStatus() != 6 && this.getUserTransaction().getStatus() != 3;
        }
        catch (SystemException e) {
            throw new ServletException("Could not determine transaction status", (Throwable)e);
        }
    }

    private boolean isMarkedRollback() throws ServletException {
        try {
            return this.getUserTransaction().getStatus() == 1;
        }
        catch (SystemException e) {
            throw new ServletException("Could not determine transaction status", (Throwable)e);
        }
    }

    public void completeTx(boolean txActive, Request baseRequest) throws ServletException {
        if (!txActive && this.isMarkedRollback() || this.isDispatch(baseRequest) && this.isTxActive()) {
            try {
                this.getUserTransaction().rollback();
            }
            catch (SystemException e) {
                throw new ServletException("Error rolling back transaction left open by user program", (Throwable)e);
            }
        }
    }
}

