/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.handler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.Servlet;
import org.apache.geronimo.j2ee.annotation.Injection;
import org.eclipse.jetty.servlet.ServletHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectionServletHandler
extends ServletHandler {
    private static final Logger log = LoggerFactory.getLogger(InjectionServletHandler.class);
    private final Map<String, List<Injection>> injections;

    public InjectionServletHandler(Map<String, List<Injection>> injections) {
        this.injections = injections;
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        List<Injection> classInjections = this.injections.get(servlet.getClass().getName());
        if (classInjections != null) {
            for (Injection injection : classInjections) {
            }
        }
        servlet = super.customizeServlet(servlet);
        this.processAnnotations(servlet);
        return servlet;
    }

    public void processAnnotations(Object instance) {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (Exception e) {
            return;
        }
        if (context == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].isAnnotationPresent(EJB.class)) continue;
            EJB annotation = fields[i].getAnnotation(EJB.class);
            InjectionServletHandler.lookupFieldResource(context, instance, fields[i], annotation.name());
        }
        Method[] methods = instance.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(EJB.class)) continue;
            EJB annotation = methods[i].getAnnotation(EJB.class);
            InjectionServletHandler.lookupMethodResource(context, instance, methods[i], annotation.name());
        }
    }

    protected static void lookupFieldResource(Context context, Object instance, Field field, String name) {
        try {
            Object lookedupResource = null;
            boolean accessibility = false;
            lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(instance.getClass().getName() + "/" + field.getName());
            accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, lookedupResource);
            field.setAccessible(accessibility);
        }
        catch (Exception e) {
            log.error("Error injecting into " + instance.getClass().getName() + "." + field.getName(), (Throwable)e);
        }
    }

    protected static void lookupMethodResource(Context context, Object instance, Method method, String name) {
        try {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid method resource injection annotation");
            }
            Object lookedupResource = null;
            boolean accessibility = false;
            lookedupResource = name != null && name.length() > 0 ? context.lookup(name) : context.lookup(instance.getClass().getName() + "/" + method.getName().substring(3));
            accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, lookedupResource);
            method.setAccessible(accessibility);
        }
        catch (Exception e) {
            log.error("Error injecting into " + instance.getClass().getName() + "." + method.getName() + "()", (Throwable)e);
        }
    }
}

