/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7;

import java.util.Map;
import javax.naming.Context;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty7.JettyServletRegistration;
import org.apache.geronimo.jetty7.handler.IntegrationContext;
import org.eclipse.jetty.servlet.FilterHolder;

@GBean(j2eeType="WebFilter")
public class FilterHolderWrapper
implements GBeanLifecycle {
    private final FilterHolder filterHolder;
    public static final GBeanInfo GBEAN_INFO;

    public FilterHolderWrapper(@ParamAttribute(name="filterName") String filterName, @ParamAttribute(name="filterClass") String filterClass, @ParamAttribute(name="initParams") Map initParams, @ParamReference(name="JettyServletRegistration", namingType="WebModule") JettyServletRegistration jettyServletRegistration) throws Exception {
        this.filterHolder = new InternalFilterHolder(jettyServletRegistration);
        if (jettyServletRegistration != null) {
            this.filterHolder.setName(filterName);
            this.filterHolder.setClassName(filterClass);
            this.filterHolder.setInitParameters(initParams);
            jettyServletRegistration.getServletHandler().addFilter(this.filterHolder);
        }
    }

    public String getFilterName() {
        return this.filterHolder.getName();
    }

    public void doStart() throws Exception {
        this.filterHolder.start();
    }

    public void doStop() throws Exception {
        this.filterHolder.stop();
    }

    public void doFail() {
        try {
            this.filterHolder.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(FilterHolderWrapper.class, (String)"WebFilter");
        infoBuilder.addAttribute("filterName", String.class, true);
        infoBuilder.addAttribute("filterClass", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"filterName", "filterClass", "initParams", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static class InternalFilterHolder
    extends FilterHolder {
        private final JettyServletRegistration servletRegistration;
        private boolean destroyed;

        public InternalFilterHolder(JettyServletRegistration servletRegistration) {
            this.servletRegistration = servletRegistration;
        }

        public synchronized Object newInstance() throws InstantiationException, IllegalAccessException {
            return this.servletRegistration.newInstance(this._className);
        }

        public void destroyInstance(Object o) throws Exception {
            if (!this.destroyed) {
                super.destroyInstance(o);
                this.servletRegistration.destroyInstance(o);
                this.destroyed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doStart() throws Exception {
            IntegrationContext integrationContext = this.servletRegistration.getIntegrationContext();
            Context context = integrationContext.setContext();
            boolean txActive = integrationContext.isTxActive();
            SharedConnectorInstanceContext newContext = integrationContext.newConnectorInstanceContext(null);
            ConnectorInstanceContext connectorContext = integrationContext.setConnectorInstance(null, newContext);
            try {
                try {
                    super.doStart();
                }
                finally {
                    integrationContext.restoreConnectorContext(connectorContext, null, newContext);
                }
            }
            finally {
                integrationContext.restoreContext(context);
                integrationContext.completeTx(txActive, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doStop() throws Exception {
            IntegrationContext integrationContext = this.servletRegistration.getIntegrationContext();
            Context context = integrationContext.setContext();
            boolean txActive = integrationContext.isTxActive();
            SharedConnectorInstanceContext newContext = integrationContext.newConnectorInstanceContext(null);
            ConnectorInstanceContext connectorContext = integrationContext.setConnectorInstance(null, newContext);
            try {
                try {
                    super.doStop();
                }
                finally {
                    integrationContext.restoreConnectorContext(connectorContext, null, newContext);
                }
            }
            finally {
                integrationContext.restoreContext(context);
                integrationContext.completeTx(txActive, null);
            }
        }
    }
}

