/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.security;

import java.security.AccessControlContext;
import javax.security.auth.Subject;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty7.handler.EJBWebServiceSecurityHandler;
import org.apache.geronimo.jetty7.handler.JaccSecurityHandler;
import org.apache.geronimo.jetty7.security.BuiltInAuthMethod;
import org.apache.geronimo.jetty7.security.JettyIdentityService;
import org.apache.geronimo.jetty7.security.SecurityHandlerFactory;
import org.apache.geronimo.jetty7.security.auth.JAASLoginService;
import org.apache.geronimo.jetty7.security.auth.NoneAuthenticator;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;

@GBean
public class JettySecurityHandlerFactory
implements SecurityHandlerFactory {
    private final BuiltInAuthMethod authMethod;
    private final String loginPage;
    private final String errorPage;
    private final String realmName;
    private final ConfigurationFactory configurationFactory;

    public JettySecurityHandlerFactory(@ParamAttribute(name="authMethod") BuiltInAuthMethod authMethod, @ParamAttribute(name="loginPage") String loginPage, @ParamAttribute(name="errorPage") String errorPage, @ParamAttribute(name="realmName") String realmName, @ParamReference(name="ConfigurationFactory") ConfigurationFactory configurationFactory) {
        if (authMethod == null) {
            throw new NullPointerException("authMethod required");
        }
        if (configurationFactory == null) {
            throw new NullPointerException("configurationFactory required");
        }
        this.authMethod = authMethod;
        this.loginPage = loginPage;
        this.errorPage = errorPage;
        this.realmName = realmName;
        this.configurationFactory = configurationFactory;
    }

    public SecurityHandler buildSecurityHandler(String policyContextID, Subject defaultSubject, RunAsSource runAsSource, boolean checkRolePermissions) {
        JAASLoginService loginService = new JAASLoginService(this.configurationFactory, this.realmName);
        Authenticator authenticator = this.buildAuthenticator();
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        AccessControlContext defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null, null);
        JettyIdentityService identityService = new JettyIdentityService(defaultAcc, defaultSubject, runAsSource);
        if (checkRolePermissions) {
            return new JaccSecurityHandler(policyContextID, authenticator, loginService, identityService, defaultAcc);
        }
        return new EJBWebServiceSecurityHandler(policyContextID, authenticator, loginService, identityService, defaultAcc);
    }

    private Authenticator buildAuthenticator() {
        Object authenticator;
        if (this.authMethod == BuiltInAuthMethod.BASIC) {
            authenticator = new BasicAuthenticator();
        } else if (this.authMethod == BuiltInAuthMethod.DIGEST) {
            authenticator = new DigestAuthenticator();
        } else if (this.authMethod == BuiltInAuthMethod.CLIENTCERT) {
            authenticator = new ClientCertAuthenticator();
        } else if (this.authMethod == BuiltInAuthMethod.FORM) {
            boolean dispatch = true;
            authenticator = new FormAuthenticator(this.loginPage, this.errorPage, dispatch);
        } else if (this.authMethod == BuiltInAuthMethod.NONE) {
            authenticator = new NoneAuthenticator();
        } else {
            throw new IllegalStateException("someone added a new BuiltInAuthMethod without telling us");
        }
        return authenticator;
    }
}

