/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.security;

import java.security.AccessControlContext;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import javax.security.auth.message.config.ServerAuthConfig;
import org.apache.geronimo.gbean.annotation.GBean;
import org.apache.geronimo.gbean.annotation.ParamAttribute;
import org.apache.geronimo.gbean.annotation.ParamReference;
import org.apache.geronimo.jetty7.handler.JaccSecurityHandler;
import org.apache.geronimo.jetty7.security.JettyIdentityService;
import org.apache.geronimo.jetty7.security.SecurityHandlerFactory;
import org.apache.geronimo.jetty7.security.auth.JAASLoginService;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.security.jacc.RunAsSource;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.jaspi.JaspiAuthenticator;
import org.eclipse.jetty.security.jaspi.ServletCallbackHandler;

@GBean
public class AuthConfigProviderHandlerFactory
implements SecurityHandlerFactory {
    private static final String POLICY_CONTEXT_ID_KEY = "javax.security.jacc.PolicyContext";
    private final Map authConfigProperties = new HashMap();
    private final Subject serviceSubject = null;
    private final String appContext;
    private final boolean allowLazyAuthentication;
    private final LoginService loginService;
    private final ServerAuthConfig serverAuthConfig;
    private final ServletCallbackHandler servletCallbackHandler;

    public AuthConfigProviderHandlerFactory(@ParamAttribute(name="messageLayer") String messageLayer, @ParamAttribute(name="appContext") String appContext, @ParamAttribute(name="allowLazyAuthentication") boolean allowLazyAuthentication, @ParamReference(name="ConfigurationFactory") ConfigurationFactory configurationFactory) throws AuthException {
        this.appContext = appContext;
        this.allowLazyAuthentication = allowLazyAuthentication;
        AuthConfigFactory authConfigFactory = AuthConfigFactory.getFactory();
        RegistrationListener listener = new RegistrationListener(){

            public void notify(String layer, String appContext) {
            }
        };
        AuthConfigProvider authConfigProvider = authConfigFactory.getConfigProvider(messageLayer, appContext, listener);
        this.loginService = new JAASLoginService(configurationFactory, null);
        this.servletCallbackHandler = new ServletCallbackHandler(this.loginService);
        this.serverAuthConfig = authConfigProvider.getServerAuthConfig(messageLayer, appContext, (CallbackHandler)this.servletCallbackHandler);
    }

    public SecurityHandler buildSecurityHandler(String policyContextID, Subject defaultSubject, RunAsSource runAsSource, boolean checkRolePermissions) {
        if (defaultSubject == null) {
            defaultSubject = ContextManager.EMPTY;
        }
        AccessControlContext defaultAcc = ContextManager.registerSubjectShort((Subject)defaultSubject, null, null);
        JettyIdentityService identityService = new JettyIdentityService(defaultAcc, defaultSubject, runAsSource);
        this.authConfigProperties.put(POLICY_CONTEXT_ID_KEY, policyContextID);
        JaspiAuthenticator authenticator = new JaspiAuthenticator(this.serverAuthConfig, this.authConfigProperties, this.servletCallbackHandler, this.serviceSubject, this.allowLazyAuthentication, (IdentityService)identityService);
        return new JaccSecurityHandler(policyContextID, (Authenticator)authenticator, this.loginService, identityService, defaultAcc);
    }
}

