/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.handler;

import java.io.IOException;
import java.util.Map;
import javax.naming.Context;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;
import org.apache.geronimo.connector.outbound.connectiontracking.SharedConnectorInstanceContext;
import org.apache.geronimo.jetty7.handler.IntegrationContext;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeronimoWebAppContext
extends WebAppContext {
    private Handler handler;
    protected final IntegrationContext integrationContext;
    protected Map<String, String> contextParamMap;

    public GeronimoWebAppContext(SecurityHandler securityHandler, SessionHandler sessionHandler, ServletHandler servletHandler, ErrorHandler errorHandler, IntegrationContext integrationContext, ClassLoader classLoader) {
        super(sessionHandler, securityHandler, servletHandler, errorHandler);
        this.integrationContext = integrationContext;
        this.setClassLoader(classLoader);
    }

    public void setContextParamMap(Map<String, String> contextParamMap) {
        this.contextParamMap = contextParamMap;
    }

    public void setTwistyHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler newTwistyHandler() {
        return new TwistyHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (this.contextParamMap != null && this.contextParamMap.size() > 0) {
            for (Map.Entry<String, String> entry : this.contextParamMap.entrySet()) {
                this.getServletContext().setInitParameter(entry.getKey(), entry.getValue());
            }
        }
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStart();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(null);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(null, newContext);
        try {
            try {
                super.doStop();
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, null, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Context context = this.integrationContext.setContext();
        boolean txActive = this.integrationContext.isTxActive();
        SharedConnectorInstanceContext newContext = this.integrationContext.newConnectorInstanceContext(baseRequest);
        ConnectorInstanceContext connectorContext = this.integrationContext.setConnectorInstance(baseRequest, newContext);
        try {
            try {
                super.doScope(target, baseRequest, request, response);
            }
            finally {
                this.integrationContext.restoreConnectorContext(connectorContext, baseRequest, newContext);
            }
        }
        finally {
            this.integrationContext.restoreContext(context);
            this.integrationContext.completeTx(txActive, baseRequest);
        }
    }

    private class TwistyHandler
    implements Handler {
        private TwistyHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            GeronimoWebAppContext.super.doHandle(target, baseRequest, request, response);
        }

        public void setServer(Server server) {
            GeronimoWebAppContext.super.setServer(server);
        }

        public Server getServer() {
            return GeronimoWebAppContext.super.getServer();
        }

        public void destroy() {
            GeronimoWebAppContext.super.destroy();
        }

        public void start() throws Exception {
            GeronimoWebAppContext.super.start();
        }

        public void stop() throws Exception {
            GeronimoWebAppContext.super.stop();
        }

        public boolean isRunning() {
            return GeronimoWebAppContext.super.isRunning();
        }

        public boolean isStarted() {
            return GeronimoWebAppContext.super.isStarted();
        }

        public boolean isStarting() {
            return GeronimoWebAppContext.super.isStarting();
        }

        public boolean isStopping() {
            return GeronimoWebAppContext.super.isStopping();
        }

        public boolean isStopped() {
            return GeronimoWebAppContext.super.isStopped();
        }

        public boolean isFailed() {
            return GeronimoWebAppContext.super.isFailed();
        }

        public void addLifeCycleListener(LifeCycle.Listener listener) {
        }

        public void removeLifeCycleListener(LifeCycle.Listener listener) {
        }
    }
}

