/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty7.cluster;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.geronimo.clustering.Session;
import org.apache.geronimo.clustering.SessionAlreadyExistException;
import org.apache.geronimo.clustering.SessionListener;
import org.apache.geronimo.clustering.SessionManager;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;

public class ClusteredSessionManager
extends AbstractSessionManager {
    private final SessionManager sessionManager;
    private final Map<String, ClusteredSession> idToSession = new HashMap<String, ClusteredSession>();

    public ClusteredSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        String workerName = sessionManager.getNode().getName();
        workerName = workerName.replaceAll(" ", "");
        HashSessionIdManager sessionIdManager = new HashSessionIdManager();
        sessionIdManager.setWorkerName(workerName);
        this.setIdManager((SessionIdManager)sessionIdManager);
        sessionManager.registerListener((SessionListener)new MigrationListener());
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new ClusteredSession(request);
    }

    public void complete(HttpSession session) {
        ClusteredSession clusteredSession = (ClusteredSession)session;
        clusteredSession.session.onEndAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(AbstractSessionManager.Session session) {
        ClusteredSession clusteredSession = (ClusteredSession)session;
        Map<String, ClusteredSession> map = this.idToSession;
        synchronized (map) {
            this.idToSession.put(clusteredSession.getClusterId(), clusteredSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(String idInCluster) {
        Map<String, ClusteredSession> map = this.idToSession;
        synchronized (map) {
            return this.idToSession.remove(idInCluster) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSessionManager.Session getSession(String idInCluster) {
        Map<String, ClusteredSession> map = this.idToSession;
        synchronized (map) {
            return this.idToSession.get(idInCluster);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessions() {
        Map<String, ClusteredSession> map = this.idToSession;
        synchronized (map) {
            return this.idToSession.size();
        }
    }

    public Map getSessionMap() {
        throw new AssertionError((Object)"getSessionMap is never used.");
    }

    protected void invalidateSessions() {
    }

    public class ClusteredSession
    extends AbstractSessionManager.Session {
        private final Session session;

        protected ClusteredSession(HttpServletRequest request) {
            super((AbstractSessionManager)ClusteredSessionManager.this, request);
            try {
                this.session = ClusteredSessionManager.this.sessionManager.createSession(this.getClusterId());
            }
            catch (SessionAlreadyExistException e) {
                throw (IllegalStateException)new IllegalStateException().initCause(e);
            }
        }

        protected ClusteredSession(Session session) {
            super((AbstractSessionManager)ClusteredSessionManager.this, System.currentTimeMillis(), 0L, session.getSessionId());
            this.session = session;
        }

        protected String getClusterId() {
            return super.getClusterId();
        }

        public void invalidate() throws IllegalStateException {
            super.invalidate();
            this.session.release();
        }
    }

    private class MigrationListener
    implements SessionListener {
        private MigrationListener() {
        }

        public void notifyInboundSessionMigration(Session session) {
            ClusteredSessionManager.this.addSession(new ClusteredSession(session), false);
        }

        public void notifyOutboundSessionMigration(Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            ClusteredSessionManager.this.removeSession(clusteredSession, false);
        }

        public void notifySessionDestruction(Session session) {
            ClusteredSession clusteredSession = this.getClusteredSession(session);
            ClusteredSessionManager.this.removeSession(clusteredSession, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ClusteredSession getClusteredSession(Session session) throws AssertionError {
            ClusteredSession clusteredSession;
            Map map = ClusteredSessionManager.this.idToSession;
            synchronized (map) {
                clusteredSession = (ClusteredSession)((Object)ClusteredSessionManager.this.idToSession.remove(session.getSessionId()));
            }
            if (null == clusteredSession) {
                throw new AssertionError((Object)("Session [" + session + "] is undefined"));
            }
            return clusteredSession;
        }
    }
}

