/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.InternalJAASJettyRealm;
import org.apache.geronimo.jetty6.JettyContainer;
import org.apache.geronimo.jetty6.JettyEJBWebServiceContext;
import org.apache.geronimo.jetty6.JettyServer;
import org.apache.geronimo.management.LazyStatisticsProvider;
import org.apache.geronimo.management.geronimo.NetworkConnector;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.management.geronimo.stats.JettyWebContainerStatsImpl;
import org.apache.geronimo.security.jaas.ConfigurationFactory;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandlerContainer;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.handler.StatisticsHandler;

public class JettyContainerImpl
implements JettyContainer,
SoapHandler,
GBeanLifecycle,
LazyStatisticsProvider {
    private static final String DEFAULT_JETTY_HOME = "var/jetty";
    private final Server server;
    private final Map<String, JettyEJBWebServiceContext> webServices = new HashMap<String, JettyEJBWebServiceContext>();
    private final String objectName;
    private final WebManager manager;
    private final String jettyHome;
    private final ServerInfo serverInfo;
    private File jettyHomeDir;
    private JettyWebContainerStatsImpl stats;
    private final Map<String, InternalJAASJettyRealm> realms = new HashMap<String, InternalJAASJettyRealm>();
    private StatisticsHandler statsHandler = new StatisticsHandler();
    private HandlerCollection handlerCollection = new HandlerCollection();
    private ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
    private DefaultHandler defaultHandler = new DefaultHandler();
    private RequestLogHandler requestLogHandler = new RequestLogHandler();
    private boolean statsHandlerInPlace = false;
    private boolean statsOn = false;
    public static final GBeanInfo GBEAN_INFO;

    public JettyContainerImpl(String objectName, WebManager manager, String jettyHome, ServerInfo serverInfo) {
        this.objectName = objectName;
        this.jettyHome = jettyHome;
        this.serverInfo = serverInfo;
        this.server = new JettyServer();
        Handler[] handlers = new Handler[]{this.contextHandlerCollection, this.defaultHandler, this.requestLogHandler};
        this.handlerCollection.setHandlers(handlers);
        this.server.setHandler((Handler)this.handlerCollection);
        this.stats = new JettyWebContainerStatsImpl();
        this.manager = manager;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    public boolean isEventProvider() {
        return true;
    }

    public NetworkConnector[] getConnectors() {
        return this.manager.getConnectorsForContainer((Object)this);
    }

    public NetworkConnector[] getConnectors(String protocol) {
        return this.manager.getConnectorsForContainer((Object)this, protocol);
    }

    public void resetStats() {
        this.statsHandler.statsReset();
        this.stats.setStartTime();
    }

    public long getCollectStatisticsStarted() {
        return this.statsHandler.getStatsOnMs();
    }

    public boolean isStatsOn() {
        return this.statsOn;
    }

    public void setStatsOn(boolean on) {
        try {
            if (on) {
                if (!this.statsHandlerInPlace) {
                    this.handlerCollection.addHandler((Handler)this.statsHandler);
                    this.statsHandlerInPlace = true;
                }
                this.resetStats();
                this.statsHandler.start();
            } else {
                this.statsHandler.stop();
                if (this.statsHandlerInPlace) {
                    this.handlerCollection.removeHandler((Handler)this.statsHandler);
                    this.statsHandlerInPlace = false;
                }
            }
            this.statsOn = on;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Stats getStats() {
        if (this.isStatsOn()) {
            this.stats.setLastSampleTime();
            this.stats.getActiveRequestCountImpl().setCurrent((long)this.statsHandler.getRequestsActive());
            this.stats.getActiveRequestCountImpl().setLowWaterMark((long)this.statsHandler.getRequestsActiveMin());
            this.stats.getActiveRequestCountImpl().setHighWaterMark((long)this.statsHandler.getRequestsActiveMax());
            this.stats.getRequestDurationImpl().setCount((long)this.statsHandler.getRequests());
            this.stats.getRequestDurationImpl().setMaxTime(this.statsHandler.getRequestsDurationMax());
            this.stats.getRequestDurationImpl().setMinTime(this.statsHandler.getRequestsDurationMin());
            this.stats.getRequestDurationImpl().setTotalTime(this.statsHandler.getRequestsDurationTotal());
            this.stats.getResponses1xxImpl().setCount((long)this.statsHandler.getResponses1xx());
            this.stats.getResponses2xxImpl().setCount((long)this.statsHandler.getResponses2xx());
            this.stats.getResponses3xxImpl().setCount((long)this.statsHandler.getResponses3xx());
            this.stats.getResponses4xxImpl().setCount((long)this.statsHandler.getResponses4xx());
            this.stats.getResponses5xxImpl().setCount((long)this.statsHandler.getResponses5xx());
            this.stats.getStatsOnMsImpl().setCount(this.statsHandler.getStatsOnMs());
        }
        return this.stats;
    }

    public void addListener(Connector listener) {
        this.server.addConnector(listener);
    }

    public void removeListener(Connector listener) {
        this.server.removeConnector(listener);
    }

    public void addContext(AbstractHandlerContainer context) {
        this.contextHandlerCollection.addHandler((Handler)context);
    }

    public void removeContext(AbstractHandlerContainer context) {
        this.contextHandlerCollection.removeHandler((Handler)context);
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String policyContextID, ConfigurationFactory configurationFactory, String realmName, String authMethod, Properties properties, ClassLoader classLoader) throws Exception {
        InternalJAASJettyRealm internalJAASJettyRealm = configurationFactory == null ? null : new InternalJAASJettyRealm(configurationFactory);
        JettyEJBWebServiceContext webServiceContext = new JettyEJBWebServiceContext(contextPath, webServiceContainer, internalJAASJettyRealm, realmName, authMethod, classLoader, null, policyContextID);
        webServiceContext.setVirtualHosts(virtualHosts);
        this.addContext((AbstractHandlerContainer)webServiceContext);
        webServiceContext.start();
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        JettyEJBWebServiceContext webServiceContext = this.webServices.remove(contextPath);
        try {
            this.removeContext((AbstractHandlerContainer)webServiceContext);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public void setRequestLog(RequestLog log) {
        this.requestLogHandler.setRequestLog(log);
    }

    public File resolveToJettyHome(String workDir) {
        if (workDir == null) {
            return null;
        }
        return new File(this.jettyHomeDir, workDir);
    }

    public RequestLog getRequestLog() {
        return this.requestLogHandler.getRequestLog();
    }

    public void doStart() throws Exception {
        this.jettyHomeDir = new File(this.serverInfo.resolveServerPath(this.jettyHome != null ? this.jettyHome : DEFAULT_JETTY_HOME));
        if (!this.jettyHomeDir.exists()) {
            this.jettyHomeDir.mkdirs();
        }
        this.server.start();
    }

    public void doStop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doFail() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((String)"Jetty Web Container", JettyContainerImpl.class);
        infoBuilder.addAttribute("statsOn", Boolean.TYPE, true);
        infoBuilder.addAttribute("collectStatisticsStarted", Long.TYPE, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("jettyHome", String.class, true);
        infoBuilder.addReference("WebManager", WebManager.class);
        infoBuilder.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoBuilder.addOperation("setStatsOn", new Class[]{Boolean.TYPE}, "void");
        infoBuilder.addOperation("resetStats");
        infoBuilder.addInterface(SoapHandler.class);
        infoBuilder.addInterface(JettyContainer.class);
        infoBuilder.addInterface(LazyStatisticsProvider.class);
        infoBuilder.setConstructor(new String[]{"objectName", "WebManager", "jettyHome", "ServerInfo"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

