/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.jetty6.handler.LifecycleCommand;
import org.mortbay.jetty.servlet.FilterHolder;

public class JettyFilterHolder
implements GBeanLifecycle {
    private final FilterHolder filterHolder;
    public static final GBeanInfo GBEAN_INFO;

    public JettyFilterHolder() {
        this.filterHolder = null;
    }

    public JettyFilterHolder(String filterName, String filterClass, Map initParams, JettyServletRegistration jettyServletRegistration) throws Exception {
        this.filterHolder = new InternalFilterHolder(jettyServletRegistration);
        if (jettyServletRegistration != null) {
            this.filterHolder.setName(filterName);
            this.filterHolder.setClassName(filterClass);
            this.filterHolder.setInitParameters(initParams);
            jettyServletRegistration.getServletHandler().addFilter(this.filterHolder);
        }
    }

    public String getFilterName() {
        return this.filterHolder.getName();
    }

    public void doStart() throws Exception {
        this.filterHolder.start();
    }

    public void doStop() throws Exception {
        this.filterHolder.stop();
    }

    public void doFail() {
        try {
            this.filterHolder.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JettyFilterHolder.class, (String)"WebFilter");
        infoBuilder.addAttribute("filterName", String.class, true);
        infoBuilder.addAttribute("filterClass", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"filterName", "filterClass", "initParams", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }

    private static class InternalFilterHolder
    extends FilterHolder {
        private final JettyServletRegistration servletRegistration;
        private boolean destroyed;

        public InternalFilterHolder(JettyServletRegistration servletRegistration) {
            this.servletRegistration = servletRegistration;
        }

        public synchronized Object newInstance() throws InstantiationException, IllegalAccessException {
            return this.servletRegistration.newInstance(this._className);
        }

        public void destroyInstance(Object o) throws Exception {
            if (!this.destroyed) {
                super.destroyInstance(o);
                this.servletRegistration.destroyInstance(o);
                this.destroyed = true;
            }
        }

        public void doStop() {
            LifecycleCommand lifecycleCommand = new LifecycleCommand(){

                public void lifecycleMethod() throws Exception {
                    InternalFilterHolder.this.internalDoStop();
                }
            };
            try {
                this.servletRegistration.getLifecycleChain().lifecycleCommand(lifecycleCommand);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void doStart() throws Exception {
            LifecycleCommand lifecycleCommand = new LifecycleCommand(){

                public void lifecycleMethod() throws Exception {
                    InternalFilterHolder.this.internalDoStart();
                }
            };
            this.servletRegistration.getLifecycleChain().lifecycleCommand(lifecycleCommand);
        }

        private void internalDoStart() throws Exception {
            super.doStart();
        }

        private void internalDoStop() {
            super.doStop();
        }
    }
}

