/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty6;

import java.util.Collection;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.jetty6.JettyFilterHolder;
import org.apache.geronimo.jetty6.JettyServletHolder;
import org.apache.geronimo.jetty6.JettyServletRegistration;
import org.apache.geronimo.jetty6.ServletNameSource;
import org.mortbay.jetty.servlet.FilterMapping;
import org.mortbay.jetty.servlet.ServletHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyFilterMapping
extends FilterMapping {
    private final String[] urlPatterns;
    private final boolean requestDispatch;
    private final boolean forwardDispatch;
    private final boolean includeDispatch;
    private final boolean errorDispatch;
    private final JettyFilterHolder jettyFilterHolder;
    private final Collection<ServletNameSource> jettyServletHolders;
    private final JettyFilterMapping previous;
    private final JettyServletRegistration jettyServletRegistration;
    public static final GBeanInfo GBEAN_INFO;

    public JettyFilterMapping() {
        this.urlPatterns = null;
        this.requestDispatch = false;
        this.forwardDispatch = false;
        this.includeDispatch = false;
        this.errorDispatch = false;
        this.jettyFilterHolder = null;
        this.jettyServletHolders = null;
        this.previous = null;
        this.jettyServletRegistration = null;
    }

    public JettyFilterMapping(String[] urlPatterns, boolean requestDispatch, boolean forwardDispatch, boolean includeDispatch, boolean errorDispatch, JettyFilterHolder jettyFilterHolder, Collection<ServletNameSource> jettyServletHolders, JettyFilterMapping previous, JettyServletRegistration jettyServletRegistration) {
        this.urlPatterns = urlPatterns;
        this.requestDispatch = requestDispatch;
        this.forwardDispatch = forwardDispatch;
        this.includeDispatch = includeDispatch;
        this.errorDispatch = errorDispatch;
        this.jettyFilterHolder = jettyFilterHolder;
        this.jettyServletHolders = jettyServletHolders;
        this.previous = previous;
        this.jettyServletRegistration = jettyServletRegistration;
        if (jettyServletRegistration != null) {
            assert (jettyServletHolders != null ^ urlPatterns != null);
            String filterName = jettyFilterHolder.getFilterName();
            int dispatches = 0;
            if (requestDispatch) {
                dispatches |= 1;
            }
            if (forwardDispatch) {
                dispatches |= 2;
            }
            if (includeDispatch) {
                dispatches |= 4;
            }
            if (errorDispatch) {
                dispatches |= 8;
            }
            this.setFilterName(filterName);
            this.setDispatches(dispatches);
            this.setPathSpecs(urlPatterns);
            if (jettyServletHolders != null) {
                this.resetServlets();
                if (jettyServletHolders instanceof ReferenceCollection) {
                    ((ReferenceCollection)jettyServletHolders).addReferenceCollectionListener(new ReferenceCollectionListener(){

                        public void memberAdded(ReferenceCollectionEvent event) {
                            JettyFilterMapping.this.resetServlets();
                            JettyFilterMapping.this.resetJettyFilterMappings();
                        }

                        public void memberRemoved(ReferenceCollectionEvent event) {
                            JettyFilterMapping.this.resetServlets();
                            JettyFilterMapping.this.resetJettyFilterMappings();
                        }
                    });
                }
            }
            jettyServletRegistration.getServletHandler().addFilterMapping((FilterMapping)this);
        }
    }

    private void resetJettyFilterMappings() {
        ServletHandler servletHandler = this.jettyServletRegistration.getServletHandler();
        FilterMapping[] filterMappings = servletHandler.getFilterMappings();
        FilterMapping[] copy = (FilterMapping[])filterMappings.clone();
        servletHandler.setFilterMappings(copy);
    }

    private void resetServlets() {
        String[] servletNames = new String[this.jettyServletHolders.size()];
        int i = 0;
        for (ServletNameSource jettyServletHolder : this.jettyServletHolders) {
            servletNames[i++] = jettyServletHolder.getServletName();
        }
        this.setServletNames(servletNames);
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public boolean isRequestDispatch() {
        return this.requestDispatch;
    }

    public boolean isForwardDispatch() {
        return this.forwardDispatch;
    }

    public boolean isIncludeDispatch() {
        return this.includeDispatch;
    }

    public boolean isErrorDispatch() {
        return this.errorDispatch;
    }

    public JettyFilterHolder getFilter() {
        return this.jettyFilterHolder;
    }

    public Collection<ServletNameSource> getServlets() {
        return this.jettyServletHolders;
    }

    public JettyFilterMapping getPrevious() {
        return this.previous;
    }

    public JettyServletRegistration getJettyServletRegistration() {
        return this.jettyServletRegistration;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic(JettyFilterMapping.class, (String)"URLWebFilterMapping");
        infoBuilder.addAttribute("urlPatterns", String[].class, true);
        infoBuilder.addAttribute("requestDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("forwardDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("includeDispatch", Boolean.TYPE, true);
        infoBuilder.addAttribute("errorDispatch", Boolean.TYPE, true);
        infoBuilder.addReference("Filter", JettyFilterHolder.class, "WebFilter");
        infoBuilder.addReference("Servlets", JettyServletHolder.class, "Servlet");
        infoBuilder.addReference("Previous", JettyFilterMapping.class, "URLWebFilterMapping");
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"urlPatterns", "requestDispatch", "forwardDispatch", "includeDispatch", "errorDispatch", "Filter", "Servlets", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

